/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.zz.patch;

import de.unkrig.commons.file.contentstransformation.ContentsTransformer;
import de.unkrig.commons.file.filetransformation.FileTransformer;
import de.unkrig.commons.lang.protocol.Mappings;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.PredicateUtil;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.AbstractPrinter;
import de.unkrig.commons.text.Printers;
import de.unkrig.commons.text.StringStream;
import de.unkrig.commons.text.expression.EvaluationException;
import de.unkrig.commons.text.expression.Expression;
import de.unkrig.commons.text.expression.ExpressionEvaluator;
import de.unkrig.commons.text.expression.ExpressionUtil;
import de.unkrig.commons.text.parser.ParseException;
import de.unkrig.commons.text.pattern.Glob;
import de.unkrig.zz.patch.Patch;
import de.unkrig.zz.patch.PatchContentsTransformer;
import de.unkrig.zz.patch.PatchTextTransformer;
import de.unkrig.zz.patch.SubstitutionContentsTransformer;
import de.unkrig.zz.patch.UpdateContentsTransformer;
import de.unkrig.zz.patch.diff.DiffParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;

public class AntTask
extends Task {
    private final Patch patch = new Patch();
    private FileTransformer.Mode mode = FileTransformer.Mode.TRANSFORM;
    private final List<ResourceCollection> resourceCollections = new ArrayList<ResourceCollection>();
    @Nullable
    private File file;
    @Nullable
    private File tofile;
    @Nullable
    private File todir;

    public void setMode(FileTransformer.Mode mode) {
        this.mode = mode;
    }

    public void setKeepOriginals(boolean value) {
        this.patch.setKeepOriginals(value);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setTofile(File file) {
        this.tofile = file;
    }

    public void setTodir(File existingDir) {
        this.todir = existingDir;
    }

    public void setLookInto(String value) {
        this.patch.setLookIntoFormat(Glob.compile(value, -1610612736));
    }

    public void addConfigured(ResourceCollection value) {
        this.resourceCollections.add(value);
    }

    public void addConfiguredUpdate(Element_path element) {
        if (element.path == PredicateUtil.always()) {
            throw new BuildException("'name=<glob>=<update-file>' must be configured");
        }
        this.patch.addContentsTransformation(element.path, new UpdateContentsTransformer(element.path));
    }

    public void addConfiguredSubstitute(SubstituteElement element) {
        this.addContentsTransformation(element.path, new SubstitutionContentsTransformer(element.inputCharset, element.outputCharset, Pattern.compile(element.getRegex(), 8), element.getReplacement(), AntTask.expressionToSubstitutionCondition(element.condition)));
    }

    private static SubstitutionContentsTransformer.Condition expressionToSubstitutionCondition(final Expression condition) {
        if (condition == Expression.TRUE) {
            return SubstitutionContentsTransformer.Condition.ALWAYS;
        }
        if (condition == Expression.FALSE) {
            return SubstitutionContentsTransformer.Condition.NEVER;
        }
        return new SubstitutionContentsTransformer.Condition(){

            @Override
            public boolean evaluate(String path, CharSequence match, int occurrence) {
                try {
                    return ExpressionEvaluator.toBoolean(condition.evaluate(Mappings.mapping("path", path, "match", match, "occurrence", occurrence)));
                }
                catch (EvaluationException ee) {
                    throw new RuntimeException(ee);
                }
            }

            public String toString() {
                return condition.toString();
            }
        };
    }

    public void addConfiguredPatch(final PatchElement element) throws IOException, StringStream.UnexpectedElementException {
        File patchFile = element.patchFile;
        if (patchFile == null) {
            throw new BuildException("Attribute 'patchFile' must be set");
        }
        this.addContentsTransformation(element.path, new PatchContentsTransformer(element.inputCharset, element.outputCharset, patchFile, element.patchFileCharset, new PatchTextTransformer.Condition(){

            @Override
            public boolean evaluate(String path, List<DiffParser.Hunk> hunks, int hunkIndex, DiffParser.Hunk hunk, int lineNumber) {
                try {
                    return ExpressionEvaluator.toBoolean(element.condition.evaluate(Mappings.mapping("path", path, "hunks", hunks, "hunkIndex", hunkIndex, "lineNumber", lineNumber)));
                }
                catch (EvaluationException ee) {
                    throw new RuntimeException(ee);
                }
            }
        }));
    }

    public void addConfiguredRemove(Element_path element) {
        this.patch.addRemoval(element.path);
    }

    public void addConfiguredRename(Element_path2 element) {
        this.patch.addRenaming(element.path);
    }

    public void addConfiguredAdd(AddElement element) {
        this.patch.addAddition(element.path, element.getEntryName(), element.getContents());
    }

    private void addContentsTransformation(Predicate<String> pathPredicate, ContentsTransformer delegate) {
        this.patch.addContentsTransformation(pathPredicate, delegate);
    }

    public void execute() throws BuildException {
        try {
            this.execute2();
        }
        catch (BuildException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void execute2() throws Exception {
        AbstractPrinter printer = new AbstractPrinter(){

            @Override
            public void warn(@Nullable String message) {
                AntTask.this.log(message, 1);
            }

            @Override
            public void verbose(@Nullable String message) {
                AntTask.this.log(message, 3);
            }

            @Override
            public void info(@Nullable String message) {
                AntTask.this.log(message, 2);
            }

            @Override
            public void error(@Nullable String message) {
                AntTask.this.log(message, 0);
            }

            @Override
            public void debug(@Nullable String message) {
                AntTask.this.log(message, 4);
            }
        };
        printer.run(new RunnableWhichThrows<Exception>(){

            @Override
            public void run() throws Exception {
                AntTask.this.execute3();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute3() throws Exception {
        FileTransformer fileTransformer = this.patch.fileTransformer(false, true);
        File file = this.file;
        if (file != null) {
            File out;
            if (this.tofile != null && this.todir != null) {
                throw new BuildException("'tofile=\"...\"' and 'todir=\"...\"' must not be configured at the same time");
            }
            File file2 = this.tofile != null ? this.tofile : (out = this.todir != null ? new File(this.todir, file.getName()) : file);
            if (out.equals(file)) {
                Printers.verbose("Patching ''{0}'' in-place", file);
            } else {
                Printers.verbose("Patching ''{0}'' to ''{1}''", file, out);
            }
            fileTransformer.transform(file.getPath(), file, out, this.mode);
        } else if (this.tofile != null) {
            throw new BuildException("'tofile=\"...\"' must only be configured in conjunction with 'file=\"...\"'");
        }
        for (ResourceCollection rc : this.resourceCollections) {
            for (Resource resource : rc) {
                if (resource.isFilesystemOnly()) {
                    FileResource fileResource = (FileResource)resource;
                    File in = fileResource.getFile();
                    File out = this.todir != null ? new File(this.todir, resource.getName()) : in;
                    Printers.verbose("Patching ''{0}'' to ''{1}''", in, out);
                    fileTransformer.transform(fileResource.getName(), in, out, FileTransformer.Mode.TRANSFORM);
                    continue;
                }
                File out = new File(this.todir, resource.getName());
                Printers.verbose("Patching ''{0}'' to ''{1}''", resource, out);
                InputStream is = resource.getInputStream();
                try {
                    FileOutputStream os = new FileOutputStream(out);
                    try {
                        this.patch.contentsTransformer().transform(resource.getName(), is, os);
                        ((OutputStream)os).close();
                    }
                    finally {
                        try {
                            ((OutputStream)os).close();
                        }
                        catch (Exception exception) {}
                    }
                    is.close();
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static class TextElement {
        private String text = "";

        public void addText(String text) {
            String oldText = this.text;
            if (!text.trim().isEmpty()) {
                this.text = oldText.trim().isEmpty() ? text : oldText + text;
            }
        }
    }

    public static class Element_path2
    extends Element_path {
        public Element_path2() {
            this.flags |= 0x40000000;
        }
    }

    public static class Element_path
    extends ProjectComponent {
        protected int flags = -1610612736;
        Glob path = Glob.ANY;

        @Deprecated
        public void setName(String path) {
            this.setPath(path);
        }

        public void setPath(String glob) {
            this.path = Glob.compile(glob, this.flags);
        }
    }

    public static class AddElement
    extends Element_path {
        @Nullable
        private String entryName;
        @Nullable
        private File contents;

        public void setEntryName(String entryName) {
            this.entryName = entryName;
        }

        public String getEntryName() {
            String entryName = this.entryName;
            if (entryName == null) {
                throw new BuildException("Attribute 'entryName=\"...\"' must be set");
            }
            return entryName;
        }

        public void setContents(File contentsFile) {
            this.contents = contentsFile;
        }

        public File getContents() {
            File contents = this.contents;
            if (contents == null) {
                throw new BuildException("Attribute 'contents=\"...\"' must be set");
            }
            return contents;
        }
    }

    public static class PatchElement
    extends Element_path {
        private Charset inputCharset = Charset.defaultCharset();
        private Charset outputCharset = Charset.defaultCharset();
        @Nullable
        private File patchFile;
        private Charset patchFileCharset = Charset.defaultCharset();
        private Expression condition = ExpressionUtil.constantExpression(Boolean.TRUE);

        public void setInputEncoding(String value) {
            this.inputCharset = Charset.forName(value);
        }

        public void setOutputEncoding(String value) {
            this.outputCharset = Charset.forName(value);
        }

        public void setPatchFile(File patchFile) {
            this.patchFile = patchFile;
        }

        public void setPatchFileEncoding(String charset) {
            this.patchFileCharset = Charset.forName(charset);
        }

        public void setCondition(String expression) throws ParseException {
            this.condition = new ExpressionEvaluator("path", "hunks", "hunkIndex", "hunk", "lineNumber").parse(expression);
        }
    }

    public static class SubstituteElement
    extends Element_path {
        private Charset inputCharset = Charset.defaultCharset();
        private Charset outputCharset = Charset.defaultCharset();
        private Expression condition = Expression.TRUE;
        @Nullable
        private String regex;
        @Nullable
        private String replacement;

        public void setInputEncoding(String charset) {
            this.inputCharset = Charset.forName(charset);
        }

        public void setOutputEncoding(String charset) {
            this.outputCharset = Charset.forName(charset);
        }

        public void setRegex(String regex) {
            if (this.regex != null) {
                throw new BuildException("Only one of 'regex=...' and '<regex>' must be configured");
            }
            this.regex = regex;
        }

        public void addConfiguredRegex(TextElement subelement) {
            if (this.regex != null) {
                throw new BuildException("Only one of 'regex=...' and '<regex>' must be configured");
            }
            this.regex = subelement.text;
        }

        public String getRegex() {
            String regex = this.regex;
            if (regex == null) {
                throw new BuildException("A 'regex=\"...\"' attribute or a '<regex>' subelement must be configured");
            }
            return regex;
        }

        public void setReplacement(String replacementString) {
            if (this.replacement != null) {
                throw new BuildException("Only one of 'replacement=...' and '<replacement>' must be configured");
            }
            this.replacement = replacementString;
        }

        public void addConfiguredReplacement(TextElement subelement) {
            if (this.replacement != null) {
                throw new BuildException("Only one of 'replacement=...' and '<replacement>' must be configured");
            }
            this.replacement = subelement.text;
        }

        public String getReplacement() {
            String replacement = this.replacement;
            if (replacement == null) {
                throw new BuildException("A 'replacement=\"...\"' attribute or a '<replacement>' subelement must be configured");
            }
            return replacement;
        }

        public void setCondition(String expression) throws ParseException {
            this.condition = new ExpressionEvaluator("path", "match", "occurrence").parse(expression);
        }
    }
}

