/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.zz.grep;

import de.unkrig.commons.file.ExceptionHandler;
import de.unkrig.commons.file.fileprocessing.FileProcessings;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormatFactory;
import de.unkrig.commons.file.org.apache.commons.compress.compressors.CompressionFormatFactory;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.LevelFilteredPrinter;
import de.unkrig.commons.text.Printers;
import de.unkrig.commons.text.pattern.Glob;
import de.unkrig.commons.text.pattern.IncludeExclude;
import de.unkrig.commons.util.CommandLineOptionException;
import de.unkrig.commons.util.CommandLineOptions;
import de.unkrig.commons.util.annotation.CommandLineOption;
import de.unkrig.commons.util.annotation.RegexFlags;
import de.unkrig.commons.util.logging.SimpleLogging;
import de.unkrig.zz.grep.Grep;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;

public final class Main {
    private final Grep grep = new Grep();
    private boolean caseSensitive;
    private final IncludeExclude includeExclude;
    private final LevelFilteredPrinter levelFilteredPrinter;

    private Main() {
        this.grep.setExceptionHandler(new ExceptionHandler<IOException>(){

            @Override
            public void handle(String path, IOException ioe) {
                Printers.error(path, ioe);
            }

            @Override
            public void handle(String path, RuntimeException re) {
                Printers.error(path, re);
            }
        });
        this.caseSensitive = true;
        this.includeExclude = new IncludeExclude();
        this.levelFilteredPrinter = new LevelFilteredPrinter();
    }

    public static void main(final String[] args) {
        final Main main = new Main();
        main.levelFilteredPrinter.run(new Runnable(){

            @Override
            public void run() {
                main.main2(args);
            }
        });
    }

    private void main2(String[] args) {
        try {
            this.main3(args);
        }
        catch (Exception e) {
            Printers.error(null, e);
            System.exit(2);
        }
    }

    private void main3(String[] args) throws IOException, InterruptedException {
        try {
            args = CommandLineOptions.parse(args, this);
        }
        catch (CommandLineOptionException cloe) {
            Printers.error(cloe.getMessage() + ", try \"--help\".");
            System.exit(2);
        }
        if (args.length == 0) {
            System.err.println("Pattern missing, try \"--help\".");
            System.exit(2);
        }
        this.grep.addSearch(this.includeExclude, args[0], this.caseSensitive);
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 1; i < args.length; ++i) {
            files.add(new File(args[i]));
        }
        if (files.isEmpty()) {
            this.grep.contentsProcessor().process("", System.in, -1L, -1L, new ProducerWhichThrows<InputStream, IOException>(){

                @Override
                @Nullable
                public InputStream produce() {
                    throw new UnsupportedOperationException();
                }
            });
        } else {
            FileProcessings.process(files, this.grep.fileProcessor(true));
        }
        if (!this.grep.linesSelected) {
            System.exit(1);
        }
    }

    @CommandLineOption
    public static void help() throws IOException {
        System.setProperty("archive.formats", ArchiveFormatFactory.allFormats().toString());
        System.setProperty("compression.formats", CompressionFormatFactory.allFormats().toString());
        CommandLineOptions.printResource(Main.class, "main(String[]).txt", Charset.forName("UTF-8"), (OutputStream)System.out);
        System.exit(0);
    }

    @CommandLineOption
    public void dontSortDirectoryMembers() {
        this.grep.setDirectoryMemberNameComparator(null);
    }

    @CommandLineOption
    public void lookInto(@RegexFlags(value=-1610612736) Glob glob) {
        this.grep.setLookIntoFormat(glob);
    }

    @CommandLineOption
    public void setEncoding(Charset charset) {
        this.grep.setCharset(charset);
    }

    @CommandLineOption(name={"l", "list"})
    public void setList() {
        this.grep.setOperation(Grep.Operation.LIST);
    }

    @CommandLineOption(name={"i", "ignore-case"})
    public void ignoreCase() {
        this.caseSensitive = false;
    }

    @CommandLineOption(name={"v", "inverted"})
    public void inverted() {
        this.grep.setInverted(true);
    }

    @CommandLineOption(name={"da", "disassemble-class-files"})
    public void setDisassemble() {
        this.grep.setDisassembleClassFiles(true);
    }

    @CommandLineOption
    public void setDaVerbose() {
        this.grep.setDisassembleClassFilesVerbose(true);
    }

    @CommandLineOption
    public void setDaSourceDirectory(File directory) {
        this.grep.setDisassembleClassFilesSourceDirectory(directory);
    }

    @CommandLineOption(name={"da-no-lines", "disassemble-class-files-but-hide-lines"})
    public void setDisassembleClassFilesButHideLines() {
        this.grep.setDisassembleClassFilesButHideLines(true);
    }

    @CommandLineOption(name={"da-no-vars", "disassemble-class-files-but-hide-vars"})
    public void setDisassembleClassFilesButHideVars() {
        this.grep.setDisassembleClassFilesButHideVars(true);
    }

    @CommandLineOption
    public void setDaSymbolicLabels() {
        this.grep.setDisassembleClassFilesSymbolicLabels(true);
    }

    @CommandLineOption(cardinality=CommandLineOption.Cardinality.ANY)
    public void addExclude(@RegexFlags(value=0x20000000) Glob regex) {
        this.includeExclude.addExclude(regex, true);
    }

    @CommandLineOption(cardinality=CommandLineOption.Cardinality.ANY)
    public void addInclude(@RegexFlags(value=0x20000000) Glob regex) {
        this.includeExclude.addInclude(regex, true);
    }

    @CommandLineOption(name={"q", "quiet", "silent"})
    public void setQuiet() {
        this.grep.setOperation(Grep.Operation.QUIET);
        this.levelFilteredPrinter.setQuiet();
        SimpleLogging.setQuiet();
    }

    @CommandLineOption
    public void setNowarn() {
        this.levelFilteredPrinter.setNoWarn();
        SimpleLogging.setNoWarn();
    }

    @CommandLineOption
    public void setVerbose() {
        this.levelFilteredPrinter.setVerbose();
        SimpleLogging.setVerbose();
    }

    @CommandLineOption
    public void setDebug() {
        this.levelFilteredPrinter.setDebug();
        SimpleLogging.setDebug();
        SimpleLogging.setDebug();
        SimpleLogging.setDebug();
    }

    @CommandLineOption(cardinality=CommandLineOption.Cardinality.ANY)
    public static void addLog(String spec) {
        SimpleLogging.configureLoggers(spec);
    }

    @Deprecated
    @CommandLineOption(name={"zip", "zz", "nested-zip", "gzip"})
    public static void noLongerSupported() {
        System.err.println("Command line option is no longer supported - try \"--help\".");
        System.exit(2);
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
    }
}

