/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.jdisasm;

import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.jdisasm.BytecodeDecoder;
import de.unkrig.jdisasm.ClassFile;
import de.unkrig.jdisasm.ConstantPool;
import de.unkrig.jdisasm.Disassembler;
import de.unkrig.jdisasm.OperandKind;
import de.unkrig.jdisasm.SignatureParser;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class BytecodeDisassembler {
    private final CountingInputStream cis;
    private final DataInputStream dis;
    private final List<ClassFile.ExceptionTableEntry> exceptionTable;
    @Nullable
    private final ClassFile.LineNumberTableAttribute lineNumberTableAttribute;
    @Nullable
    private final ClassFile.StackMapTableAttribute stackMapTableAttribute;
    @Nullable
    private final Map<Integer, String> sourceLines;
    private final ClassFile.Method method;
    private final SignatureParser.TypeSignature[] parameterTypes;
    private final Disassembler d;
    private int instructionOffset;
    private final Map<Integer, String> branchTargets = new HashMap<Integer, String>();
    private final SortedMap<Integer, String> lines = new TreeMap<Integer, String>();
    private final OperandKind.Visitor<String, IOException> readOperand = new OperandKind.Visitor<String, IOException>(){

        @Override
        public String visitClassFloatIntString1(OperandKind operandType) throws IOException {
            short index = (short)(0xFF & BytecodeDisassembler.this.dis.readByte());
            String t = ((BytecodeDisassembler)BytecodeDisassembler.this).method.getClassFile().constantPool.get(index, ConstantPool.ConstantClassOrFloatOrIntegerOrStringInfo.class).toString();
            if (((BytecodeDisassembler)BytecodeDisassembler.this).d.showClassPoolIndexes) {
                t = t + " (" + (0xFFFF & index) + ")";
            }
            return t;
        }

        @Override
        public String visitClassFloatIntString2(OperandKind operandType) throws IOException {
            short index = BytecodeDisassembler.this.dis.readShort();
            String t = ((BytecodeDisassembler)BytecodeDisassembler.this).method.getClassFile().constantPool.get(index, ConstantPool.ConstantClassOrFloatOrIntegerOrStringInfo.class).toString();
            if (((BytecodeDisassembler)BytecodeDisassembler.this).d.showClassPoolIndexes) {
                t = t + " (" + (0xFFFF & index) + ")";
            }
            return t;
        }

        @Override
        public String visitDoubleLong2(OperandKind operandType) throws IOException {
            short index = BytecodeDisassembler.this.dis.readShort();
            String t = ((BytecodeDisassembler)BytecodeDisassembler.this).method.getClassFile().constantPool.get(index, ConstantPool.ConstantDoubleOrLongInfo.class).toString();
            if (((BytecodeDisassembler)BytecodeDisassembler.this).d.showClassPoolIndexes) {
                t = t + " (" + (0xFFFF & index) + ")";
            }
            return t;
        }

        @Override
        public String visitFieldref2(OperandKind operandType) throws IOException {
            short index = BytecodeDisassembler.this.dis.readShort();
            ConstantPool.ConstantFieldrefInfo fr = ((BytecodeDisassembler)BytecodeDisassembler.this).method.getClassFile().constantPool.get(index, ConstantPool.ConstantFieldrefInfo.class);
            String t = BytecodeDisassembler.this.d.decodeFieldDescriptor(fr.nameAndType.descriptor.bytes) + " " + fr.clasS + '.' + fr.nameAndType.name.bytes;
            if (((BytecodeDisassembler)BytecodeDisassembler.this).d.showClassPoolIndexes) {
                t = t + " (" + (0xFFFF & index) + ")";
            }
            return t;
        }

        @Override
        public String visitMethodref2(OperandKind operandType) throws IOException {
            short index = BytecodeDisassembler.this.dis.readShort();
            ConstantPool.ConstantMethodrefInfo mr = ((BytecodeDisassembler)BytecodeDisassembler.this).method.getClassFile().constantPool.get(index, ConstantPool.ConstantMethodrefInfo.class);
            String t = BytecodeDisassembler.this.d.decodeMethodDescriptor(mr.nameAndType.descriptor.bytes).toString(mr.clasS.toString(), mr.nameAndType.name.bytes);
            if (((BytecodeDisassembler)BytecodeDisassembler.this).d.showClassPoolIndexes) {
                t = t + " (" + (0xFFFF & index) + ")";
            }
            return t;
        }

        @Override
        public String visitInterfaceMethodref2(OperandKind operandType) throws IOException {
            short index = BytecodeDisassembler.this.dis.readShort();
            BytecodeDisassembler.this.dis.readByte();
            BytecodeDisassembler.this.dis.readByte();
            ConstantPool.ConstantInterfaceMethodrefInfo imr = ((BytecodeDisassembler)BytecodeDisassembler.this).method.getClassFile().constantPool.get(index, ConstantPool.ConstantInterfaceMethodrefInfo.class);
            String t = BytecodeDisassembler.this.d.decodeMethodDescriptor(imr.nameAndType.descriptor.bytes).toString(imr.clasS.toString(), imr.nameAndType.name.bytes);
            if (((BytecodeDisassembler)BytecodeDisassembler.this).d.showClassPoolIndexes) {
                t = t + " (" + (0xFFFF & index) + ")";
            }
            return t;
        }

        @Override
        public String visitInterfaceMethodrefOrMethodref2(OperandKind operandType) throws IOException {
            short index = BytecodeDisassembler.this.dis.readShort();
            ConstantPool.ConstantInterfaceMethodrefOrMethodrefInfo imromr = ((BytecodeDisassembler)BytecodeDisassembler.this).method.getClassFile().constantPool.get(index, ConstantPool.ConstantInterfaceMethodrefOrMethodrefInfo.class);
            String t = BytecodeDisassembler.this.d.decodeMethodDescriptor(imromr.nameAndType.descriptor.bytes).toString(imromr.clasS.toString(), imromr.nameAndType.name.bytes);
            if (((BytecodeDisassembler)BytecodeDisassembler.this).d.showClassPoolIndexes) {
                t = t + " (" + (0xFFFF & index) + ")";
            }
            return t;
        }

        @Override
        public String visitClass2(OperandKind operandType) throws IOException {
            short index = BytecodeDisassembler.this.dis.readShort();
            String t = ((BytecodeDisassembler)BytecodeDisassembler.this).method.getClassFile().constantPool.get(index, ConstantPool.ConstantClassInfo.class).toString();
            if (((BytecodeDisassembler)BytecodeDisassembler.this).d.showClassPoolIndexes) {
                t = t + " (" + (0xFFFF & index) + ")";
            }
            return t;
        }

        @Override
        public String visitLocalVariableIndex1(OperandKind operandType) throws IOException {
            short index = (short)(0xFF & BytecodeDisassembler.this.dis.readByte());
            return BytecodeDisassembler.this.d.getLocalVariable(index, BytecodeDisassembler.this.instructionOffset + 2, BytecodeDisassembler.this.method).toString();
        }

        @Override
        public String visitLocalVariableIndex2(OperandKind operandType) throws IOException {
            short index = BytecodeDisassembler.this.dis.readShort();
            return BytecodeDisassembler.this.d.getLocalVariable(index, BytecodeDisassembler.this.instructionOffset + 4, BytecodeDisassembler.this.method).toString();
        }

        @Override
        public String visitImplicitLocalVariableIndex(OperandKind operandType, int index) {
            return BytecodeDisassembler.this.d.getLocalVariable((short)index, BytecodeDisassembler.this.instructionOffset + 1, BytecodeDisassembler.this.method).toString();
        }

        @Override
        public String visitBranchOffset2(OperandKind operandType) throws IOException {
            return BytecodeDisassembler.this.branchTarget(BytecodeDisassembler.this.instructionOffset + BytecodeDisassembler.this.dis.readShort());
        }

        @Override
        public String visitBranchOffset4(OperandKind operandType) throws IOException {
            return BytecodeDisassembler.this.branchTarget(BytecodeDisassembler.this.instructionOffset + BytecodeDisassembler.this.dis.readInt());
        }

        @Override
        public String visitSignedByte(OperandKind operandType) throws IOException {
            return Integer.toString(BytecodeDisassembler.this.dis.readByte());
        }

        @Override
        public String visitUnsignedByte(OperandKind operandType) throws IOException {
            return Integer.toString(0xFF & BytecodeDisassembler.this.dis.readByte());
        }

        @Override
        public String visitSignedShort(OperandKind operandType) throws IOException {
            return Integer.toString(BytecodeDisassembler.this.dis.readShort());
        }

        @Override
        public String visitAtype(OperandKind operandType) throws IOException {
            byte b = BytecodeDisassembler.this.dis.readByte();
            return b == 4 ? "BOOLEAN" : (b == 5 ? "CHAR" : (b == 6 ? "FLOAT" : (b == 7 ? "DOUBLE" : (b == 8 ? "BYTE" : (b == 9 ? "SHORT" : (b == 10 ? "INT" : (b == 11 ? "LONG" : Integer.toString(0xFF & b))))))));
        }

        @Override
        public String visitTableswitch(OperandKind operandType) throws IOException {
            int npads = 3 - BytecodeDisassembler.this.instructionOffset % 4;
            for (int i = 0; i < npads; ++i) {
                byte padByte = BytecodeDisassembler.this.dis.readByte();
                if (padByte == 0) continue;
                throw new RuntimeException("'tableswitch' pad byte #" + i + " is not zero, but " + (0xFF & padByte));
            }
            StringBuilder sb = new StringBuilder("default => ");
            sb.append(BytecodeDisassembler.this.branchTarget(BytecodeDisassembler.this.instructionOffset + BytecodeDisassembler.this.dis.readInt()));
            int low = BytecodeDisassembler.this.dis.readInt();
            int high = BytecodeDisassembler.this.dis.readInt();
            for (int i = low; i <= high; ++i) {
                sb.append(", ").append(i).append(" => ");
                sb.append(BytecodeDisassembler.this.branchTarget(BytecodeDisassembler.this.instructionOffset + BytecodeDisassembler.this.dis.readInt()));
            }
            return sb.toString();
        }

        @Override
        public String visitLookupswitch(OperandKind operandType) throws IOException {
            int npads = 3 - BytecodeDisassembler.this.instructionOffset % 4;
            for (int i = 0; i < npads; ++i) {
                byte padByte = BytecodeDisassembler.this.dis.readByte();
                if (padByte == 0) continue;
                throw new RuntimeException("'lookupswitch' pad byte #" + i + " is not zero, but " + (0xFF & padByte));
            }
            StringBuilder sb = new StringBuilder("default => ");
            sb.append(BytecodeDisassembler.this.branchTarget(BytecodeDisassembler.this.instructionOffset + BytecodeDisassembler.this.dis.readInt()));
            int npairs = BytecodeDisassembler.this.dis.readInt();
            for (int i = 0; i < npairs; ++i) {
                int match = BytecodeDisassembler.this.dis.readInt();
                int offset = BytecodeDisassembler.this.instructionOffset + BytecodeDisassembler.this.dis.readInt();
                sb.append(", ").append(match).append(" => ").append(BytecodeDisassembler.this.branchTarget(offset));
            }
            return sb.toString();
        }

        @Override
        public String visitDynamicCallsite(OperandKind operandType) throws IOException {
            short index = BytecodeDisassembler.this.dis.readShort();
            if (BytecodeDisassembler.this.dis.readByte() != 0 || BytecodeDisassembler.this.dis.readByte() != 0) {
                throw new RuntimeException("'invokevirtual' pad byte is not zero");
            }
            ConstantPool.ConstantInvokeDynamicInfo cidy = ((BytecodeDisassembler)BytecodeDisassembler.this).method.getClassFile().constantPool.get(index, ConstantPool.ConstantInvokeDynamicInfo.class);
            ClassFile.BootstrapMethodsAttribute.BootstrapMethod bm = ((BytecodeDisassembler)BytecodeDisassembler.this).method.getBootstrapMethodsAttribute().bootstrapMethods.get(cidy.bootstrapMethodAttrIndex);
            return bm + "." + cidy.nameAndType;
        }
    };

    public BytecodeDisassembler(InputStream is, List<ClassFile.ExceptionTableEntry> exceptionTable, @Nullable ClassFile.LineNumberTableAttribute lineNumberTableAttribute, @Nullable ClassFile.StackMapTableAttribute stackMapTableAttribute, @Nullable Map<Integer, String> sourceLines, ClassFile.Method method, SignatureParser.TypeSignature[] parameterTypes, Disassembler d) {
        this.cis = new CountingInputStream(is);
        this.dis = new DataInputStream(this.cis);
        this.exceptionTable = exceptionTable;
        this.lineNumberTableAttribute = lineNumberTableAttribute;
        this.stackMapTableAttribute = stackMapTableAttribute;
        this.sourceLines = sourceLines;
        this.method = method;
        this.parameterTypes = parameterTypes;
        this.d = d;
    }

    public void disassembleBytecode(PrintWriter pw) throws IOException {
        TreeMap<Integer, HashSet<Integer>> tryStarts = new TreeMap<Integer, HashSet<Integer>>();
        TreeMap tryEnds = new TreeMap();
        for (ClassFile.ExceptionTableEntry e : this.exceptionTable) {
            ArrayList<ClassFile.ExceptionTableEntry> l;
            HashSet<Integer> s = (HashSet<Integer>)tryStarts.get(e.startPc);
            if (s == null) {
                s = new HashSet<Integer>();
                tryStarts.put(e.startPc, s);
            }
            s.add(e.endPc);
            TreeMap m = (TreeMap)tryEnds.get(e.endPc);
            if (m == null) {
                m = new TreeMap(Collections.reverseOrder());
                tryEnds.put(e.endPc, m);
            }
            if ((l = (ArrayList<ClassFile.ExceptionTableEntry>)m.get(e.startPc)) == null) {
                l = new ArrayList<ClassFile.ExceptionTableEntry>();
                m.put(e.startPc, l);
            }
            l.add(e);
        }
        HashMap<Integer, String> stackMap = new HashMap<Integer, String>();
        ClassFile.StackMapTableAttribute smta = this.stackMapTableAttribute;
        if (this.d.printStackMap && smta != null) {
            Object[] none = new String[]{};
            Object[] locals = new String[this.parameterTypes.length];
            for (int i = 0; i < locals.length; ++i) {
                locals[i] = this.parameterTypes[i].toString();
            }
            Object[] stack = none;
            stackMap.put(0, "Locals=" + Arrays.toString(locals) + " Stack=" + Arrays.toString(stack));
            int bytecodeOffset = -1;
            for (ClassFile.StackMapFrame stackMapFrame : smta.entries) {
                Object[] finalLocals = locals;
                locals = stackMapFrame.accept(new ClassFile.StackMapFrameVisitor<String[]>((String[])finalLocals){
                    final /* synthetic */ String[] val$finalLocals;
                    {
                        this.val$finalLocals = stringArray;
                    }

                    @Override
                    public String[] visitSameFrame(ClassFile.SameFrame sf) {
                        return this.val$finalLocals;
                    }

                    @Override
                    public String[] visitSameLocals1StackItemFrame(ClassFile.SameLocals1StackItemFrame sl1sif) {
                        return this.val$finalLocals;
                    }

                    @Override
                    public String[] visitSameLocals1StackItemFrameExtended(ClassFile.SameLocals1StackItemFrameExtended sl1sife) {
                        return this.val$finalLocals;
                    }

                    @Override
                    public String[] visitChopFrame(ClassFile.ChopFrame cf) {
                        return Arrays.copyOf(this.val$finalLocals, this.val$finalLocals.length - cf.k);
                    }

                    @Override
                    public String[] visitSameFrameExtended(ClassFile.SameFrameExtended sfe) {
                        return this.val$finalLocals;
                    }

                    @Override
                    public String[] visitAppendFrame(ClassFile.AppendFrame af) {
                        return (String[])BytecodeDisassembler.concat(this.val$finalLocals, BytecodeDisassembler.this.toStringArray(af.locals));
                    }

                    @Override
                    public String[] visitFullFrame(ClassFile.FullFrame ff) {
                        return BytecodeDisassembler.this.toStringArray(ff.locals);
                    }
                });
                stack = stackMapFrame.accept(new ClassFile.StackMapFrameVisitor<String[]>((String[])none){
                    final /* synthetic */ String[] val$none;
                    {
                        this.val$none = stringArray;
                    }

                    @Override
                    public String[] visitSameFrame(ClassFile.SameFrame sf) {
                        return this.val$none;
                    }

                    @Override
                    public String[] visitSameLocals1StackItemFrame(ClassFile.SameLocals1StackItemFrame sl1sif) {
                        return new String[]{String.valueOf(sl1sif.stack)};
                    }

                    @Override
                    public String[] visitSameLocals1StackItemFrameExtended(ClassFile.SameLocals1StackItemFrameExtended sl1sife) {
                        return new String[]{String.valueOf(sl1sife.stack)};
                    }

                    @Override
                    public String[] visitChopFrame(ClassFile.ChopFrame cf) {
                        return this.val$none;
                    }

                    @Override
                    public String[] visitSameFrameExtended(ClassFile.SameFrameExtended sfe) {
                        return this.val$none;
                    }

                    @Override
                    public String[] visitAppendFrame(ClassFile.AppendFrame af) {
                        return this.val$none;
                    }

                    @Override
                    public String[] visitFullFrame(ClassFile.FullFrame ff) {
                        return BytecodeDisassembler.this.toStringArray(ff.stack);
                    }
                });
                stackMap.put(bytecodeOffset += 1 + stackMapFrame.offsetDelta, "Locals=" + Arrays.toString(locals) + " Stack=" + Arrays.toString(stack));
            }
        }
        BytecodeDecoder<String, IOException> bytecodeDecoder = new BytecodeDecoder<String, IOException>(){

            @Override
            @Nullable
            public String decoded(String mnemonic, OperandKind ... operandKinds) throws IOException {
                if ("end".equals(mnemonic)) {
                    return null;
                }
                if (operandKinds.length == 0) {
                    return mnemonic;
                }
                Formatter f = new Formatter();
                f.format("%-15s", mnemonic);
                for (int i = 0; i < operandKinds.length; ++i) {
                    f.format(" %s", operandKinds[i].accept(BytecodeDisassembler.this.readOperand));
                }
                return f.toString();
            }
        };
        while (true) {
            this.instructionOffset = (int)this.cis.getCount();
            String line = (String)bytecodeDecoder.decode(this.dis);
            if (line == null) break;
            this.lines.put(this.instructionOffset, line);
        }
        String indentation = "        ";
        for (Map.Entry<Integer, String> e : this.lines.entrySet()) {
            String string;
            int n;
            Map.Entry sc;
            Integer startPc;
            Map.Entry e2;
            int endPc;
            int instructionOffset = e.getKey();
            String text = e.getValue();
            Iterator iterator = tryEnds.entrySet().iterator();
            while (iterator.hasNext() && (endPc = ((Integer)(e2 = iterator.next()).getKey()).intValue()) <= instructionOffset) {
                SortedMap startPc2Ete = (SortedMap)e2.getValue();
                for (List etes : startPc2Ete.values()) {
                    if (endPc < instructionOffset) {
                        pw.println("*** Error: Exception table entry ends at invalid code array index " + endPc + " (current instruction offset is " + instructionOffset + ")");
                    }
                    indentation = indentation.substring(4);
                    pw.print(indentation + "} catch (");
                    Iterator it2 = etes.iterator();
                    while (true) {
                        ClassFile.ExceptionTableEntry ete = (ClassFile.ExceptionTableEntry)it2.next();
                        ConstantPool.ConstantClassInfo ct = ete.catchType;
                        pw.print((ct == null ? "[all exceptions] => " : ct + " => ") + this.branchTarget(ete.handlerPc));
                        if (!it2.hasNext()) break;
                        pw.print(", ");
                    }
                    pw.println(")");
                }
                iterator.remove();
            }
            String string2 = this.branchTargets.get(instructionOffset);
            if (string2 != null) {
                pw.println(string2);
            }
            Iterator iterator2 = tryStarts.entrySet().iterator();
            while (iterator2.hasNext() && (startPc = (Integer)(sc = iterator2.next()).getKey()) <= instructionOffset) {
                for (int i = ((Set)sc.getValue()).size(); i > 0; --i) {
                    if (startPc < instructionOffset) {
                        pw.println("*** Error: Exception table entry starts at invalid code array index " + startPc + " (current instruction offset is " + instructionOffset + ")");
                    }
                    pw.println(indentation + "try {");
                    indentation = indentation + "    ";
                }
                iterator2.remove();
            }
            if (this.lineNumberTableAttribute != null && (n = this.findLineNumber(instructionOffset)) != -1) {
                String sourceLine;
                String string3 = sourceLine = this.sourceLines != null ? this.sourceLines.get(n) : null;
                if (sourceLine == null) {
                    if (this.d.showLineNumbers) {
                        pw.println(indentation + "// Line " + n);
                    }
                } else if (this.d.showLineNumbers) {
                    pw.println(indentation + "//                                      Line " + n + ": " + sourceLine);
                } else {
                    pw.println(indentation + "//                                      " + sourceLine);
                }
            }
            if ((string = (String)stackMap.get(instructionOffset)) != null) {
                pw.println(indentation + "// " + string);
            }
            pw.println(indentation + text);
        }
    }

    protected String[] toStringArray(Object[] objects) {
        String[] result = new String[objects.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = String.valueOf(objects[i]);
        }
        return result;
    }

    private static <T> T[] concat(T[] lhs, T[] rhs) {
        T[] result = Arrays.copyOf(lhs, lhs.length + rhs.length);
        System.arraycopy(rhs, 0, result, lhs.length, rhs.length);
        return result;
    }

    private int findLineNumber(int offset) {
        ClassFile.LineNumberTableAttribute lnta = this.lineNumberTableAttribute;
        if (lnta == null) {
            return -1;
        }
        for (ClassFile.LineNumberTableEntry lnte : lnta.entries) {
            if (lnte.startPc != offset) continue;
            return lnte.lineNumber;
        }
        return -1;
    }

    private String branchTarget(int offset) {
        String label = this.branchTargets.get(offset);
        if (label == null) {
            label = this.d.symbolicLabels ? "L" + (1 + this.branchTargets.size()) : "#" + offset;
            this.branchTargets.put(offset, label);
        }
        return label;
    }

    @NotNullByDefault(value=false)
    private static class CountingInputStream
    extends FilterInputStream {
        private long count;

        CountingInputStream(InputStream is) {
            super(is);
        }

        @Override
        public int read() throws IOException {
            int res = super.read();
            if (res != -1) {
                ++this.count;
            }
            return res;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int res = super.read(b, off, len);
            if (res != -1) {
                this.count += (long)res;
            }
            return res;
        }

        public long getCount() {
            return this.count;
        }
    }
}

