/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.junit4.runner;

import de.unkrig.commons.junit4.runner.internal.RemoteTestClassRunner;
import de.unkrig.commons.junit4.runner.internal.RemoteTestClassRunnerClient;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Collections;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;

public class PipeTestClassRunner
extends ParentRunner<Runner> {
    private RemoteTestClassRunner delegate;

    public PipeTestClassRunner(Class<?> clasS) throws Exception {
        this(clasS, null);
    }

    public PipeTestClassRunner(Class<?> clasS, @Nullable Runner runner) throws Exception {
        super(clasS);
        PipedOutputStream toSlave = new PipedOutputStream();
        final PipedInputStream fromMaster = new PipedInputStream();
        fromMaster.connect(toSlave);
        final PipedOutputStream toMaster = new PipedOutputStream();
        PipedInputStream fromSlave = new PipedInputStream();
        fromSlave.connect(toMaster);
        new Thread(){

            @Override
            public void run() {
                try {
                    RemoteTestClassRunnerClient.run(fromMaster, toMaster);
                }
                catch (Exception e) {
                    throw new AssertionError((Object)e);
                }
            }
        }.start();
        this.delegate = new RemoteTestClassRunner(clasS, runner, "(piped)", toSlave, fromSlave);
    }

    @NotNullByDefault(value=false)
    protected void runChild(Runner child, RunNotifier notifier) {
        assert (child == this.delegate);
        child.run(notifier);
    }

    protected List<Runner> getChildren() {
        return Collections.singletonList(this.delegate);
    }

    @NotNullByDefault(value=false)
    protected Description describeChild(Runner child) {
        assert (child == this.delegate);
        return child.getDescription();
    }
}

