/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.org.apache.commons.compress.archivers.sevenz;

import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormat;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.sevenz.SevenZArchiveInputStream;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.sevenz.SevenZArchiveOutputStream;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.StreamingNotSupportedException;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;
import org.apache.commons.compress.compressors.FileNameUtil;

public final class SevenZArchiveFormat
implements ArchiveFormat {
    private static final FileNameUtil FILE_NAME_UTIL = new FileNameUtil(Collections.singletonMap(".7z", ""), ".7z");
    private static final ArchiveFormat INSTANCE = new SevenZArchiveFormat();

    private SevenZArchiveFormat() {
    }

    public static ArchiveFormat get() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return "7z";
    }

    @Override
    public boolean isArchiveFileName(String fileName) {
        return FILE_NAME_UTIL.isCompressedFilename(fileName);
    }

    @Override
    public String getArchiveFileName(String fileName) {
        return FILE_NAME_UTIL.getCompressedFilename(fileName);
    }

    @Override
    public ArchiveInputStream archiveInputStream(InputStream is) throws StreamingNotSupportedException {
        throw new StreamingNotSupportedException("7z");
    }

    @Override
    public ArchiveInputStream open(File archiveFile) throws IOException {
        return new SevenZArchiveInputStream(archiveFile);
    }

    @Override
    public ArchiveOutputStream archiveOutputStream(OutputStream os) throws StreamingNotSupportedException {
        throw new StreamingNotSupportedException("7z");
    }

    @Override
    public ArchiveOutputStream create(File archiveFile) throws IOException {
        return new SevenZArchiveOutputStream(new SevenZOutputFile(archiveFile));
    }

    @Override
    public void writeEntry(ArchiveOutputStream archiveOutputStream, String name, ConsumerWhichThrows<? super OutputStream, ? extends IOException> writeContents) throws IOException {
        if (!(archiveOutputStream instanceof SevenZArchiveOutputStream)) {
            throw new IllegalArgumentException(archiveOutputStream.getClass().getName());
        }
        SevenZArchiveEntry szae = new SevenZArchiveEntry();
        szae.setName(name);
        archiveOutputStream.putArchiveEntry(szae);
        writeContents.consume(archiveOutputStream);
        archiveOutputStream.closeArchiveEntry();
    }

    @Override
    public void writeDirectoryEntry(ArchiveOutputStream archiveOutputStream, String name) throws IOException {
        if (!(archiveOutputStream instanceof SevenZArchiveOutputStream)) {
            throw new IllegalArgumentException(archiveOutputStream.getClass().getName());
        }
        SevenZArchiveEntry szae = new SevenZArchiveEntry();
        szae.setDirectory(true);
        szae.setName(name);
        archiveOutputStream.putArchiveEntry(szae);
        archiveOutputStream.closeArchiveEntry();
    }

    @Override
    public void writeEntry(ArchiveOutputStream archiveOutputStream, ArchiveEntry archiveEntry, @Nullable String name, ConsumerWhichThrows<? super OutputStream, ? extends IOException> writeContents) throws IOException {
        SevenZArchiveEntry szae;
        if (!(archiveOutputStream instanceof SevenZArchiveOutputStream)) {
            throw new IllegalArgumentException(archiveOutputStream.getClass().getName());
        }
        if (archiveEntry instanceof SevenZArchiveEntry) {
            szae = (SevenZArchiveEntry)archiveEntry;
            if (name != null) {
                szae.setName(name);
            }
        } else {
            szae = new SevenZArchiveEntry();
            szae.setName(name != null ? name : archiveEntry.getName());
            szae.setLastModifiedDate(archiveEntry.getLastModifiedDate());
        }
        archiveOutputStream.putArchiveEntry(szae);
        if (!archiveEntry.isDirectory()) {
            writeContents.consume(archiveOutputStream);
        }
        archiveOutputStream.closeArchiveEntry();
    }

    @Override
    public boolean matches(byte[] signature, int signatureLength) {
        return SevenZFile.matches(signature, signatureLength);
    }

    public String toString() {
        return this.getName();
    }
}

