/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.zz.patch.diff;

import de.unkrig.commons.io.LineUtil;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.StringStream;
import de.unkrig.zz.patch.diff.DiffException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public final class DiffParser {
    private static final Pattern DIFF_LINE;
    private static final Pattern CD_FILE_HEADER1;
    private static final Pattern CD_FILE_HEADER2;
    private static final Pattern CD_HUNK_SEPARATOR;
    private static final Pattern CD_HUNK_HEADER1;
    private static final Pattern CD_HUNK_HEADER2;
    private static final Pattern CD_LINE_CHANGE;
    private static final Pattern TD_HUNK_HEADER;
    private static final Pattern TD_LINE_ADDED;
    private static final Pattern TD_LINE_DELETED;
    private static final Pattern TD_SEPARATOR;
    private static final Pattern UD_FILE1_HEADER;
    private static final Pattern UD_FILE2_HEADER;
    private static final Pattern UD_HUNK_HEADER;
    private static final Pattern UD_LINE_CHANGE;

    static {
        AssertionUtil.enableAssertionsForThisClass();
        DIFF_LINE = Pattern.compile("diff.* \\S+ \\S+\\s*");
        CD_FILE_HEADER1 = Pattern.compile("\\*\\*\\* (.+?) +\\d\\d\\d\\d-\\d\\d-\\d\\d .*", 32);
        CD_FILE_HEADER2 = Pattern.compile("--- (.+?) +\\d\\d\\d\\d-\\d\\d-\\d\\d .*", 32);
        CD_HUNK_SEPARATOR = Pattern.compile("\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\s*");
        CD_HUNK_HEADER1 = Pattern.compile("\\*\\*\\* (\\d+),(\\d+) \\*\\*\\*\\*\\s*");
        CD_HUNK_HEADER2 = Pattern.compile("--- (\\d+),(\\d+) ----\\s*");
        CD_LINE_CHANGE = Pattern.compile("([ \\-\\+!]) (.*)", 32);
        TD_HUNK_HEADER = Pattern.compile("(\\d+)(?:,(\\d+))?([adc])(\\d+)(?:,(\\d+))?\\s*");
        TD_LINE_ADDED = Pattern.compile("> (.*)", 32);
        TD_LINE_DELETED = Pattern.compile("< (.*)", 32);
        TD_SEPARATOR = Pattern.compile("---(.*)", 32);
        UD_FILE1_HEADER = Pattern.compile("--- (.+?) +\\d\\d\\d\\d-\\d\\d-\\d\\d .*", 32);
        UD_FILE2_HEADER = Pattern.compile("\\+\\+\\+ (.+?) +\\d\\d\\d\\d-\\d\\d-\\d\\d .*", 32);
        UD_HUNK_HEADER = Pattern.compile("@@ -(\\d+),(\\d+) \\+(\\d+),(\\d+) @@\\s*");
        UD_LINE_CHANGE = Pattern.compile("([\\-\\+ ])(.*)", 32);
    }

    private DiffParser() {
    }

    public static List<Differential> parse(File file, Charset charset) throws IOException, StringStream.UnexpectedElementException {
        InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(file), charset);
        try {
            List<Differential> list = DiffParser.parse(r);
            return list;
        }
        finally {
            try {
                ((Reader)r).close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Unable to fully structure code
     */
    public static List<Differential> parse(Reader r) throws DiffException, IOException, StringStream.UnexpectedElementException {
        ss = new StringStream<IOException>(LineUtil.readLineWithSeparator(r));
        differentials = new ArrayList<Differential>();
        while (!ss.atEnd()) {
            block8: {
                block11: {
                    block10: {
                        block9: {
                            block7: {
                                fileName1 = null;
                                fileName2 = null;
                                if (ss.peekRead(DiffParser.DIFF_LINE)) {
                                    fileName1 = ss.group(1);
                                    fileName2 = ss.group(2);
                                }
                                hunks = new ArrayList<Hunk>();
                                if (!ss.peek(DiffParser.CD_FILE_HEADER1)) break block7;
                                ss.read(DiffParser.CD_FILE_HEADER1);
                                fileName1 = ss.group(1);
                                ss.read(DiffParser.CD_FILE_HEADER2);
                                fileName2 = ss.group(1);
                                while (ss.peekRead(DiffParser.CD_HUNK_SEPARATOR)) {
                                    hunks.add(DiffParser.parseContextDiffHunk(ss));
                                }
                                break block8;
                            }
                            if (!ss.peek(DiffParser.CD_HUNK_SEPARATOR)) break block9;
                            while (ss.peekRead(DiffParser.CD_HUNK_SEPARATOR)) {
                                hunks.add(DiffParser.parseContextDiffHunk(ss));
                            }
                            break block8;
                        }
                        if (!ss.peek(DiffParser.TD_HUNK_HEADER)) break block10;
                        do {
                            hunks.add(DiffParser.parseTraditionalDiffHunk(ss));
                        } while (ss.peek(DiffParser.TD_HUNK_HEADER));
                        break block8;
                    }
                    if (!ss.peek(DiffParser.UD_FILE1_HEADER)) break block11;
                    ss.read(DiffParser.UD_FILE1_HEADER);
                    fileName1 = ss.group(1);
                    if (!DiffParser.$assertionsDisabled && fileName1 == null) {
                        throw new AssertionError();
                    }
                    ss.read(DiffParser.UD_FILE2_HEADER);
                    fileName2 = ss.group(1);
                    if (DiffParser.$assertionsDisabled || fileName2 != null) ** GOTO lbl46
                    throw new AssertionError();
lbl-1000:
                    // 1 sources

                    {
                        hunks.add(DiffParser.parseUnifiedDiffHunk(ss));
lbl46:
                        // 2 sources

                        ** while (ss.peek((Pattern)DiffParser.UD_HUNK_HEADER))
                    }
lbl47:
                    // 1 sources

                    break block8;
                }
                throw new DiffException("Unknown DIFF format '" + ss.peek() + "'");
            }
            differentials.add(new Differential(fileName1, fileName2, hunks));
        }
        return differentials;
    }

    private static Hunk parseUnifiedDiffHunk(StringStream<IOException> ss) throws IOException, DiffException, StringStream.UnexpectedElementException {
        ss.read(UD_HUNK_HEADER);
        int from1 = Integer.parseInt(ss.group(1)) - 1;
        int count1 = Integer.parseInt(ss.group(2));
        int from2 = Integer.parseInt(ss.group(3)) - 1;
        int count2 = Integer.parseInt(ss.group(4));
        ArrayList<LineChange> lineChanges = new ArrayList<LineChange>();
        int lines1 = 0;
        int lines2 = 0;
        while (ss.peekRead(UD_LINE_CHANGE)) {
            String code = ss.group(1);
            assert (code != null);
            String contents = ss.group(2);
            assert (contents != null);
            switch (code.charAt(0)) {
                case '+': {
                    lineChanges.add(new LineChange(LineChange.Mode.ADDED, contents));
                    ++lines2;
                    break;
                }
                case '-': {
                    lineChanges.add(new LineChange(LineChange.Mode.DELETED, contents));
                    ++lines1;
                    break;
                }
                case ' ': {
                    lineChanges.add(new LineChange(LineChange.Mode.CONTEXT, contents));
                    ++lines1;
                    ++lines2;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        if (lines1 != count1) {
            throw new DiffException("Unified diff hunk header says " + count1 + " FILE1 lines, but " + lines1 + " lines appear");
        }
        if (lines2 != count2) {
            throw new DiffException("Unified diff hunk header says " + count2 + " FILE2 lines, but " + lines2 + " lines appear");
        }
        return new Hunk(from1, from2, lineChanges);
    }

    /*
     * Unable to fully structure code
     */
    private static Hunk parseContextDiffHunk(StringStream<IOException> ss) throws DiffException, IOException, StringStream.UnexpectedElementException {
        block31: {
            block30: {
                ss.read(DiffParser.CD_HUNK_HEADER1);
                file1From = Integer.parseInt(ss.group(1));
                file1To = Integer.parseInt(ss.group(2));
                lineChanges = new ArrayList<LineChange>();
                if (!ss.peek(DiffParser.CD_HUNK_HEADER2)) {
                    i = file1From;
                    while (i <= file1To) {
                        ss.read(DiffParser.CD_LINE_CHANGE);
                        code = ss.group(1);
                        if (!DiffParser.$assertionsDisabled && code == null) {
                            throw new AssertionError();
                        }
                        contents = ss.group(2);
                        if (!DiffParser.$assertionsDisabled && contents == null) {
                            throw new AssertionError();
                        }
                        switch (code.charAt(0)) {
                            case ' ': {
                                lineChanges.add(new LineChange(LineChange.Mode.CONTEXT, contents));
                                break;
                            }
                            case '-': {
                                lineChanges.add(new LineChange(LineChange.Mode.DELETED, contents));
                                break;
                            }
                            case '!': {
                                lineChanges.add(new LineChange(LineChange.Mode.DELETED, contents));
                                lineChanges.add(null);
                                break;
                            }
                            case '+': {
                                throw new DiffException("Unexpected '+' line in FILE1 part of context diff hunk");
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                        ++i;
                    }
                }
                ss.read(DiffParser.CD_HUNK_HEADER2);
                file2From = Integer.parseInt(ss.group(1));
                file2To = Integer.parseInt(ss.group(2));
                if (!ss.peek(DiffParser.CD_HUNK_SEPARATOR)) break block30;
                for (LineChange lc : lineChanges) {
                    if (lc != null) continue;
                    throw new DiffException("Context diff hunk has '!' if FILE1 part, but lacks the FILE2 part");
                }
                break block31;
            }
            idx = lineChanges.isEmpty() != false ? -1 : 0;
            i = file2From;
            while (i <= file2To) {
                ss.read(DiffParser.CD_LINE_CHANGE);
                code = ss.group(1);
                if (!DiffParser.$assertionsDisabled && code == null) {
                    throw new AssertionError();
                }
                contents = ss.group(2);
                if (!DiffParser.$assertionsDisabled && contents == null) {
                    throw new AssertionError();
                }
                switch (code.charAt(0)) {
                    case ' ': {
                        if (idx != -1) ** GOTO lbl63
                        lineChanges.add(new LineChange(LineChange.Mode.CONTEXT, contents));
                        break;
                        while ((lc = (LineChange)lineChanges.get(idx)) != null && lc.mode == LineChange.Mode.DELETED) {
                            ++idx;
lbl63:
                            // 2 sources

                            if (idx < lineChanges.size()) continue;
                        }
                        if (idx >= lineChanges.size()) {
                            throw new DiffException("Short FILE1 part");
                        }
                        if (lineChanges.get(idx) != null && contents.equals(((LineChange)lineChanges.get((int)idx++)).text)) break;
                        throw new DiffException("Inconsistent FILE2 context line '" + contents + "'");
                    }
                    case '+': {
                        if (idx != -1) ** GOTO lbl75
                        lineChanges.add(new LineChange(LineChange.Mode.ADDED, contents));
                        break;
                        while ((lc = (LineChange)lineChanges.get(idx)) != null && lc.mode == LineChange.Mode.DELETED) {
                            ++idx;
lbl75:
                            // 2 sources

                            if (idx < lineChanges.size()) continue;
                        }
                        if (idx > lineChanges.size()) {
                            throw new DiffException("Short FILE1 part");
                        }
                        lineChanges.add(idx++, new LineChange(LineChange.Mode.ADDED, contents));
                        break;
                    }
                    case '!': {
                        if (idx == -1) {
                            throw new DiffException("Unexpected '!' line in context diff");
                        }
                        if (idx + 2 >= lineChanges.size()) {
                            throw new DiffException("Short FILE1 part");
                        }
                        if ((lc = (LineChange)lineChanges.get(idx++)) == null) {
                            throw new DiffException("Unmatched '" + contents + "'");
                        }
                        if (lc.mode != LineChange.Mode.DELETED) {
                            throw new DiffException("'" + contents + "' does not match '" + lc + "'");
                        }
                        lc = (LineChange)lineChanges.get(idx);
                        if (lc != null) {
                            throw new DiffException("'" + contents + "' does not match '" + lc + "'");
                        }
                        lineChanges.set(idx++, new LineChange(LineChange.Mode.ADDED, contents));
                        break;
                    }
                    case '-': {
                        throw new DiffException("Unexpected '-' line in FILE2 part of context diff hunk");
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                ++i;
            }
            if (idx != -1 && idx != lineChanges.size()) {
                throw new DiffException("Short FILE2 part in context diff hunk");
            }
        }
        return new Hunk(file1From - 1, file2From - 1, lineChanges);
    }

    private static Hunk parseTraditionalDiffHunk(StringStream<IOException> ss) throws IOException, DiffException, StringStream.UnexpectedElementException {
        int from2;
        int from1;
        ss.read(TD_HUNK_HEADER);
        String code = ss.group(3);
        assert (code != null && code.length() == 1);
        ArrayList<LineChange> lineChanges = new ArrayList<LineChange>();
        switch (code.charAt(0)) {
            case 'a': {
                from1 = Integer.parseInt(ss.group(1));
                from2 = Integer.parseInt(ss.group(4)) - 1;
                if (ss.group(2) != null) {
                    throw new DiffException("Traditional diff ADD hunk has FILE1 range");
                }
                int to2 = ss.group(5) == null ? from2 + 1 : Integer.parseInt(ss.group(5));
                int i = from2;
                while (i < to2) {
                    ss.read(TD_LINE_ADDED);
                    String contents = ss.group(1);
                    assert (contents != null);
                    lineChanges.add(new LineChange(LineChange.Mode.ADDED, contents));
                    ++i;
                }
                break;
            }
            case 'd': {
                int to1;
                from1 = Integer.parseInt(ss.group(1)) - 1;
                from2 = Integer.parseInt(ss.group(4));
                int n = to1 = ss.group(2) == null ? from1 + 1 : Integer.parseInt(ss.group(2));
                if (ss.group(5) != null) {
                    throw new DiffException("Traditional diff DELETE hunk has FILE2 range");
                }
                int i = from1;
                while (i < to1) {
                    ss.read(TD_LINE_DELETED);
                    String contents = ss.group(1);
                    assert (contents != null);
                    lineChanges.add(new LineChange(LineChange.Mode.DELETED, contents));
                    ++i;
                }
                break;
            }
            case 'c': {
                String contents;
                from1 = Integer.parseInt(ss.group(1)) - 1;
                from2 = Integer.parseInt(ss.group(4)) - 1;
                int to1 = ss.group(2) == null ? from1 + 1 : Integer.parseInt(ss.group(2));
                int to2 = ss.group(5) == null ? from2 + 1 : Integer.parseInt(ss.group(5));
                int i = from1;
                while (i < to1) {
                    ss.read(TD_LINE_DELETED);
                    contents = ss.group(1);
                    assert (contents != null);
                    lineChanges.add(new LineChange(LineChange.Mode.DELETED, contents));
                    ++i;
                }
                ss.read(TD_SEPARATOR);
                i = from2;
                while (i < to2) {
                    ss.read(TD_LINE_ADDED);
                    contents = ss.group(1);
                    assert (contents != null);
                    lineChanges.add(new LineChange(LineChange.Mode.ADDED, contents));
                    ++i;
                }
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return new Hunk(from1, from2, lineChanges);
    }

    public static class Differential {
        @Nullable
        public final String fileName1;
        @Nullable
        public final String fileName2;
        public final List<Hunk> hunks;

        public Differential(@Nullable String fileName1, @Nullable String fileName2, List<Hunk> hunks) {
            this.fileName1 = fileName1;
            this.fileName2 = fileName2;
            this.hunks = hunks;
        }
    }

    public static class Hunk {
        public final int from1;
        public final int from2;
        public final List<LineChange> lineChanges;

        public Hunk(int from1, int from2, List<LineChange> lineChanges) {
            this.from1 = from1;
            this.from2 = from2;
            this.lineChanges = lineChanges;
        }

        public String toString() {
            return String.valueOf(this.from1) + "/" + this.from2 + this.lineChanges;
        }
    }

    public static class LineChange {
        public final Mode mode;
        public final String text;

        public LineChange(Mode mode, String text) {
            this.mode = mode;
            this.text = text;
        }

        public String toString() {
            return (Object)((Object)this.mode) + " " + this.text;
        }

        public static enum Mode {
            CONTEXT,
            ADDED,
            DELETED;

        }
    }
}

