/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.zz.patch;

import de.unkrig.commons.file.contentstransformation.ContentsTransformer;
import de.unkrig.commons.lang.protocol.Function;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.pattern.PatternUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SubstitutionContentsTransformer
implements ContentsTransformer {
    private static final Logger LOGGER = Logger.getLogger(SubstitutionContentsTransformer.class.getName());
    private final Charset inputCharset;
    private final Charset outputCharset;
    private final Pattern pattern;
    private final String replacementString;
    private final Condition condition;
    private int initialBufferCapacity = 8192;

    public SubstitutionContentsTransformer(Charset inputCharset, Charset outputCharset, Pattern pattern, String replacementString, Condition condition) {
        this.inputCharset = inputCharset;
        this.outputCharset = outputCharset;
        this.pattern = pattern;
        this.replacementString = replacementString;
        this.condition = condition;
    }

    public void setInitialBufferCapacity(int initialBufferCapacity) {
        this.initialBufferCapacity = initialBufferCapacity;
    }

    public String toString() {
        return "(" + this.pattern + " => " + this.replacementString + " iff " + this.condition + ")";
    }

    @Override
    public void transform(final String path, InputStream is, OutputStream os) throws IOException {
        OutputStreamWriter out;
        int count;
        LOGGER.log(Level.FINE, "Substituting matches of ''{0}'' with ''{1}'' in ''{2}'' iff ''{3}''", new Object[]{this.pattern, this.replacementString, path, this.condition});
        Function<Matcher, String> replacer = PatternUtil.replacementStringMatchReplacer(this.replacementString);
        if (this.condition != Condition.ALWAYS) {
            final Function<Matcher, String> replacer2 = replacer;
            replacer = new Function<Matcher, String>(){
                private int occurrence;

                @Override
                @Nullable
                public String call(@Nullable Matcher matcher) {
                    if (!$assertionsDisabled && matcher == null) {
                        throw new AssertionError();
                    }
                    String replacement = (String)replacer2.call(matcher);
                    if (!$assertionsDisabled && replacement == null) {
                        throw new AssertionError();
                    }
                    return SubstitutionContentsTransformer.this.condition.evaluate(path, matcher.group(), this.occurrence++) ? replacement : null;
                }
            };
        }
        if ((count = PatternUtil.replaceSome(new InputStreamReader(is, this.inputCharset), this.pattern, replacer, out = new OutputStreamWriter(os, this.outputCharset), this.initialBufferCapacity)) == 0) {
            LOGGER.log(Level.FINE, "No matches of ''{0}'' in ''{1}'' were replaced with ''{2}''", new Object[]{this.pattern, path, this.replacementString});
        } else {
            LOGGER.log(Level.CONFIG, "{0} matches of ''{1}'' were replaced with ''{2}'' in ''{3}''", new Object[]{count, this.pattern, this.replacementString, path});
        }
        ((Writer)out).flush();
    }

    public static interface Condition {
        public static final Condition ALWAYS = new Condition(){

            @Override
            public boolean evaluate(String name, CharSequence match, int occurrence) {
                return true;
            }

            public String toString() {
                return "ALWAYS";
            }
        };
        public static final Condition NEVER = new Condition(){

            @Override
            public boolean evaluate(String name, CharSequence match, int occurrence) {
                return false;
            }

            public String toString() {
                return "NEVER";
            }
        };

        public boolean evaluate(String var1, CharSequence var2, int var3);
    }
}

