/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.zz.patch;

import de.unkrig.commons.file.contentstransformation.TextTransformer;
import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.io.LineUtil;
import de.unkrig.zz.patch.diff.DiffException;
import de.unkrig.zz.patch.diff.DiffParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PatchTextTransformer
implements TextTransformer {
    private static final Logger LOGGER = Logger.getLogger(PatchTextTransformer.class.getName());
    private final List<DiffParser.Hunk> hunks;
    private final Condition condition;
    private static /* synthetic */ int[] $SWITCH_TABLE$de$unkrig$zz$patch$diff$DiffParser$LineChange$Mode;

    public PatchTextTransformer(List<DiffParser.Hunk> hunks, Condition condition) {
        this.hunks = hunks;
        this.condition = condition;
    }

    public boolean isIdentity() {
        return this.hunks.isEmpty();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void transform(String path, Reader reader, Writer writer) throws IOException {
        if (this.hunks.isEmpty()) {
            IoUtil.copy(reader, writer);
            return;
        }
        PatchTextTransformer.LOGGER.log(Level.CONFIG, "{0}: Patch {1} {1,choice,1#hunk|1<hunks}", new Object[]{path, this.hunks.size()});
        lineReader = LineUtil.readLineWithSeparator(new BufferedReader(reader));
        i = 0;
        hunkIndex = 0;
        while (hunkIndex < this.hunks.size()) {
            block19: {
                hunk = this.hunks.get(hunkIndex);
                if (!this.condition.evaluate(path, this.hunks, hunkIndex, hunk, hunk.from1 + 1)) break block19;
                if (i <= hunk.from1) ** GOTO lbl19
                throw new DiffException("Changes overlap (hunk starts at line " + hunk.from1 + ", but " + i + " lines have already been read)");
lbl-1000:
                // 1 sources

                {
                    line = lineReader.produce();
                    if (line == null) {
                        throw new DiffException("Hunk begins at line " + hunk.from1 + ", but the file contains only " + i + " lines");
                    }
                    writer.write(line);
                    ++i;
lbl19:
                    // 2 sources

                    ** while (i < hunk.from1)
                }
lbl20:
                // 2 sources

                for (DiffParser.LineChange lc : hunk.lineChanges) {
                    switch (PatchTextTransformer.$SWITCH_TABLE$de$unkrig$zz$patch$diff$DiffParser$LineChange$Mode()[lc.mode.ordinal()]) {
                        case 1: {
                            line = lineReader.produce();
                            if (line == null) {
                                throw new DiffException("Context line \"" + lc.text + "\" is past the end-of-file");
                            }
                            if (!lc.text.equals(line)) {
                                throw new DiffException("Context line mismatch; expected \"" + lc.text + "\", but was \"" + line + "\"");
                            }
                            writer.write(lc.text);
                            ++i;
                            break;
                        }
                        case 2: {
                            writer.write(lc.text);
                            break;
                        }
                        case 3: {
                            line = lineReader.produce();
                            if (line == null) {
                                throw new DiffException("Deleted line \"" + lc.text + "\" is beyond the end-of-file");
                            }
                            if (!lc.text.equals(line)) {
                                throw new DiffException("Deleted line mismatch; expected \"" + lc.text + "\", but was \"" + line + "\"");
                            }
                            ++i;
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                }
                if (hunk.from1 == i) {
                    PatchTextTransformer.LOGGER.log(Level.CONFIG, "{0}: Patching after line {1}", new Object[]{path, i});
                } else if (hunk.from1 == i - 1) {
                    PatchTextTransformer.LOGGER.log(Level.CONFIG, "{0}: Patching line {1}", new Object[]{path, i});
                } else {
                    PatchTextTransformer.LOGGER.log(Level.CONFIG, "{0}: Patching lines {1}...{2}", new Object[]{path, hunk.from1 + 1, i});
                }
            }
            ++hunkIndex;
        }
        while ((line = lineReader.produce()) != null) {
            writer.write(line);
        }
        writer.flush();
        PatchTextTransformer.LOGGER.log(Level.FINE, "{0}: Patched {1,choice,0#{1} hunks|1#{1} hunk|1<{1} hunks}", new Object[]{path, this.hunks.size()});
    }

    static /* synthetic */ int[] $SWITCH_TABLE$de$unkrig$zz$patch$diff$DiffParser$LineChange$Mode() {
        if ($SWITCH_TABLE$de$unkrig$zz$patch$diff$DiffParser$LineChange$Mode != null) {
            return $SWITCH_TABLE$de$unkrig$zz$patch$diff$DiffParser$LineChange$Mode;
        }
        int[] nArray = new int[DiffParser.LineChange.Mode.values().length];
        try {
            nArray[DiffParser.LineChange.Mode.ADDED.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DiffParser.LineChange.Mode.CONTEXT.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DiffParser.LineChange.Mode.DELETED.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$de$unkrig$zz$patch$diff$DiffParser$LineChange$Mode = nArray;
        return nArray;
    }

    public static interface Condition {
        public static final Condition ALWAYS = new Condition(){

            @Override
            public boolean evaluate(String path, List<DiffParser.Hunk> hunks, int hunkIndex, DiffParser.Hunk hunk, int lineNumber) {
                return true;
            }
        };

        public boolean evaluate(String var1, List<DiffParser.Hunk> var2, int var3, DiffParser.Hunk var4, int var5);
    }
}

