/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.zz.pack;

import de.unkrig.commons.file.ExceptionHandler;
import de.unkrig.commons.file.contentsprocessing.ContentsProcessings;
import de.unkrig.commons.file.contentsprocessing.ContentsProcessor;
import de.unkrig.commons.file.fileprocessing.FileProcessings;
import de.unkrig.commons.file.fileprocessing.FileProcessor;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormat;
import de.unkrig.commons.file.org.apache.commons.compress.compressors.CompressionFormat;
import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.PredicateUtil;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.util.concurrent.ConcurrentUtil;
import de.unkrig.commons.util.concurrent.SquadExecutor;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.Collator;
import java.util.Comparator;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.StreamingNotSupportedException;
import org.apache.commons.compress.compressors.CompressorException;

public class Pack {
    @Nullable
    private ArchiveFormat archiveFormat;
    @Nullable
    private CompressionFormat compressionFormat;
    @Nullable
    private ArchiveOutputStream archiveOutputStream;
    private Predicate<? super String> lookIntoFormat = PredicateUtil.always();
    @Nullable
    private Comparator<Object> directoryMemberNameComparator = Collator.getInstance();
    private ExceptionHandler<IOException> exceptionHandler = ExceptionHandler.defaultHandler();
    private Predicate<? super String> pathPredicate = PredicateUtil.always();

    static {
        AssertionUtil.enableAssertionsForThisClass();
    }

    public void setArchiveFormat(ArchiveFormat value) {
        this.archiveFormat = value;
    }

    public void setCompressionFormat(@Nullable CompressionFormat value) {
        this.compressionFormat = value;
    }

    public Closeable setOutputStream(OutputStream os) throws StreamingNotSupportedException, ArchiveException, IOException, CompressorException {
        ArchiveFormat af;
        CompressionFormat cf = this.compressionFormat;
        if (cf != null) {
            os = cf.compressorOutputStream(os);
        }
        if ((af = this.archiveFormat) == null) {
            throw new ArchiveException("Archive format not specified");
        }
        this.archiveOutputStream = af.archiveOutputStream(os);
        return this.archiveOutputStream;
    }

    public void setLookIntoFormat(Predicate<? super String> value) {
        this.lookIntoFormat = value;
    }

    public void setPathPredicate(Predicate<? super String> value) {
        this.pathPredicate = value;
    }

    public void setExceptionHandler(ExceptionHandler<IOException> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setDirectoryMemberNameComparator(@Nullable Comparator<Object> directoryMemberNameComparator) {
        this.directoryMemberNameComparator = directoryMemberNameComparator;
    }

    public ContentsProcessor<Void> contentsProcessor() {
        return new ContentsProcessor<Void>(){

            @Override
            @Nullable
            public Void process(String name, InputStream is, long size, long crc32, ProducerWhichThrows<? extends InputStream, ? extends IOException> opener) throws IOException {
                if (!Pack.this.pathPredicate.evaluate(name)) {
                    return null;
                }
                AssertionUtil.notNull(Pack.this.archiveFormat).writeEntry(AssertionUtil.notNull(Pack.this.archiveOutputStream), name, IoUtil.copyFrom(is));
                return null;
            }
        };
    }

    public FileProcessor<Void> fileProcessor(boolean lookIntoDirectories) {
        FileProcessor<Void> fp = FileProcessings.recursiveCompressedAndArchiveFileProcessor(this.lookIntoFormat, this.pathPredicate, ContentsProcessings.nopArchiveCombiner(), this.contentsProcessor(), this.exceptionHandler);
        if (lookIntoDirectories) {
            fp = FileProcessings.directoryTreeProcessor(this.pathPredicate, fp, this.directoryMemberNameComparator, FileProcessings.nopDirectoryCombiner(), new SquadExecutor(ConcurrentUtil.SEQUENTIAL_EXECUTOR_SERVICE), this.exceptionHandler);
        }
        return fp;
    }
}

