/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.zz.pack;

import de.unkrig.commons.file.contentsprocessing.ContentsProcessor;
import de.unkrig.commons.file.fileprocessing.FileProcessor;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormatFactory;
import de.unkrig.commons.file.org.apache.commons.compress.compressors.CompressionFormatFactory;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.pattern.Glob;
import de.unkrig.zz.pack.Pack;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileProvider;

public class AntTask
extends Task {
    private static final Logger LOGGER = Logger.getLogger(Task.class.getName());
    private final Pack pack = new Pack();
    @Nullable
    private File archiveFile;
    @Nullable
    private File file;
    private final List<ResourceCollection> resourceCollections = new ArrayList<ResourceCollection>();

    public void setArchiveFile(File archiveFile) {
        this.archiveFile = archiveFile;
    }

    public void setArchiveFormat(String archiveFormat) throws ArchiveException {
        this.pack.setArchiveFormat(ArchiveFormatFactory.forFormatName(archiveFormat));
    }

    public void setCompressionFormat(String compressionFormat) throws CompressorException {
        this.pack.setCompressionFormat(CompressionFormatFactory.forFormatName(compressionFormat));
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setLookInto(String glob) {
        this.pack.setLookIntoFormat(Glob.compile(glob, -1610612736));
    }

    @Deprecated
    public void setName(String glob) {
        this.setPath(glob);
    }

    public void setPath(String glob) {
        this.pack.setPathPredicate(Glob.compile(glob, -1610612736));
    }

    public void addConfigured(ResourceCollection value) {
        this.resourceCollections.add(value);
    }

    public void execute() throws BuildException {
        try {
            this.execute2();
        }
        catch (BuildException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void execute2() throws Exception {
        File archiveFile = this.archiveFile;
        if (archiveFile == null) {
            throw new BuildException("Attribute 'archiveFile=\"...\"' missing");
        }
        FileOutputStream os = new FileOutputStream(AssertionUtil.notNull(this.archiveFile, "Attribute 'archiveFile=\"...\"' missing"));
        Closeable c = os;
        try {
            c = this.pack.setOutputStream(os);
            this.execute3();
            c.close();
        }
        finally {
            try {
                c.close();
            }
            catch (Exception exception) {}
        }
    }

    private void execute3() throws IOException, InterruptedException {
        ContentsProcessor<Void> contentsProcessor = this.pack.contentsProcessor();
        FileProcessor<Void> fileProcessor = this.pack.fileProcessor(false);
        File file = this.file;
        if (file != null) {
            LOGGER.log(Level.CONFIG, "Packing ''{0}''", file.getPath());
            fileProcessor.process(file.getPath(), file);
        }
        for (ResourceCollection resourceCollection : this.resourceCollections) {
            for (final Resource resource : resourceCollection) {
                String resourceName = resource.getName();
                LOGGER.log(Level.CONFIG, "Packing ''{0}''", resourceName);
                if (resource.isFilesystemOnly()) {
                    fileProcessor.process(resourceName, ((FileProvider)resource).getFile());
                    continue;
                }
                InputStream is = resource.getInputStream();
                try {
                    contentsProcessor.process(resourceName, is, resource.getSize(), -1L, new ProducerWhichThrows<InputStream, IOException>(){

                        @Override
                        @Nullable
                        public InputStream produce() throws IOException {
                            return resource.getInputStream();
                        }
                    });
                    is.close();
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

