/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.zz.grep;

import de.unkrig.commons.file.ExceptionHandler;
import de.unkrig.commons.file.contentsprocessing.ContentsProcessings;
import de.unkrig.commons.file.contentsprocessing.ContentsProcessor;
import de.unkrig.commons.file.contentsprocessing.SelectiveContentsProcessor;
import de.unkrig.commons.file.fileprocessing.FileProcessings;
import de.unkrig.commons.file.fileprocessing.FileProcessor;
import de.unkrig.commons.io.ByteFilterInputStream;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.PredicateUtil;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.Printers;
import de.unkrig.commons.text.pattern.Glob;
import de.unkrig.commons.util.concurrent.ConcurrentUtil;
import de.unkrig.commons.util.concurrent.SquadExecutor;
import de.unkrig.zz.grep.DisassemblerByteFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.nio.charset.Charset;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;

public class Grep {
    private Predicate<? super String> lookIntoFormat = PredicateUtil.always();
    private Charset charset = Charset.defaultCharset();
    private Operation operation = Operation.NORMAL;
    private boolean inverted;
    private boolean disassembleClassFiles;
    private boolean disassembleClassFilesVerbose;
    @Nullable
    private File disassembleClassFilesSourceDirectory;
    private boolean disassembleClassFilesButHideLines;
    private boolean disassembleClassFilesButHideVars;
    private boolean disassembleClassFilesSymbolicLabels;
    @Nullable
    private Comparator<Object> directoryMemberNameComparator = Collator.getInstance();
    private ExceptionHandler<IOException> exceptionHandler = ExceptionHandler.defaultHandler();
    private final List<Search> searches = new ArrayList<Search>();
    boolean linesSelected;

    public void setLookIntoFormat(Predicate<? super String> value) {
        this.lookIntoFormat = value;
    }

    public void setCharset(Charset value) {
        this.charset = value;
    }

    public void setOperation(Operation value) {
        this.operation = value;
    }

    public void setInverted(boolean value) {
        this.inverted = value;
    }

    public void setDisassembleClassFiles(boolean value) {
        this.disassembleClassFiles = value;
    }

    public void setDisassembleClassFilesVerbose(boolean value) {
        this.disassembleClassFilesVerbose = value;
    }

    public void setDisassembleClassFilesSourceDirectory(@Nullable File value) {
        this.disassembleClassFilesSourceDirectory = value;
    }

    public void setDisassembleClassFilesButHideLines(boolean value) {
        this.disassembleClassFilesButHideLines = value;
    }

    public void setDisassembleClassFilesButHideVars(boolean value) {
        this.disassembleClassFilesButHideVars = value;
    }

    public void setDisassembleClassFilesSymbolicLabels(boolean value) {
        this.disassembleClassFilesSymbolicLabels = value;
    }

    public void addSearch(Glob path, String regex, boolean caseSensitive) {
        this.searches.add(new Search(path, Pattern.compile(regex, caseSensitive ? 0 : 2)));
    }

    public void setExceptionHandler(ExceptionHandler<IOException> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setDirectoryMemberNameComparator(@Nullable Comparator<Object> directoryMemberNameComparator) {
        this.directoryMemberNameComparator = directoryMemberNameComparator;
    }

    public boolean getLinesSelected() {
        return this.linesSelected;
    }

    public ContentsProcessor<Void> contentsProcessor() {
        return new ContentsProcessor<Void>(){

            @Override
            @Nullable
            public Void process(String path, InputStream is, long size, long crc32, ProducerWhichThrows<? extends InputStream, ? extends IOException> opener) throws IOException {
                String line;
                ArrayList<Pattern> patterns = new ArrayList<Pattern>();
                for (Search search : Grep.this.searches) {
                    if (!search.path.matches(path)) continue;
                    patterns.add(search.pattern);
                }
                if (patterns.isEmpty()) {
                    return null;
                }
                if (Grep.this.disassembleClassFiles && path.endsWith(".class")) {
                    DisassemblerByteFilter disassemblerByteFilter = new DisassemblerByteFilter();
                    disassemblerByteFilter.setVerbose(Grep.this.disassembleClassFilesVerbose);
                    disassemblerByteFilter.setSourceDirectory(Grep.this.disassembleClassFilesSourceDirectory);
                    disassemblerByteFilter.setHideLines(Grep.this.disassembleClassFilesButHideLines);
                    disassemblerByteFilter.setHideVars(Grep.this.disassembleClassFilesButHideVars);
                    disassemblerByteFilter.setSymbolicLabels(Grep.this.disassembleClassFilesSymbolicLabels);
                    is = new ByteFilterInputStream(is, disassemblerByteFilter);
                }
                PushbackReader pbr = new PushbackReader(new BufferedReader(new InputStreamReader(is, Grep.this.charset)));
                block6: while ((line = Grep.readLine(pbr)) != null) {
                    boolean found = false;
                    for (Pattern pattern : patterns) {
                        if (!pattern.matcher(line).find()) continue;
                        found = true;
                        break;
                    }
                    if (!(found ^ Grep.this.inverted)) continue;
                    Grep.this.linesSelected = true;
                    switch (Grep.this.operation) {
                        case NORMAL: {
                            Printers.info(String.valueOf(path) + ": " + line);
                            continue block6;
                        }
                        case LIST: {
                            Printers.info(path);
                            return null;
                        }
                        case QUIET: {
                            return null;
                        }
                    }
                }
                return null;
            }
        };
    }

    public FileProcessor<Void> fileProcessor(boolean lookIntoDirectories) {
        Predicate<Object> pathPredicate = PredicateUtil.never();
        for (Search search : this.searches) {
            pathPredicate = PredicateUtil.or(pathPredicate, search.path);
        }
        FileProcessor<Void> fp = FileProcessings.recursiveCompressedAndArchiveFileProcessor(this.lookIntoFormat, PredicateUtil.always(), ContentsProcessings.nopArchiveCombiner(), new SelectiveContentsProcessor<Void>(pathPredicate, this.contentsProcessor(), ContentsProcessings.nopContentsProcessor()), this.exceptionHandler);
        if (lookIntoDirectories) {
            fp = FileProcessings.directoryTreeProcessor(pathPredicate, fp, this.directoryMemberNameComparator, FileProcessings.nopDirectoryCombiner(), new SquadExecutor(ConcurrentUtil.SEQUENTIAL_EXECUTOR_SERVICE), this.exceptionHandler);
        }
        return fp;
    }

    @Nullable
    static String readLine(PushbackReader pbr) throws IOException {
        int c = pbr.read();
        if (c == -1) {
            return null;
        }
        StringBuilder sb = new StringBuilder(1000);
        while (c != -1 && c != 10) {
            if (c == 13) {
                c = pbr.read();
                if (c == 10) break;
                pbr.unread(c);
                break;
            }
            if (sb.length() < 65536) {
                sb.append((char)c);
            }
            c = pbr.read();
        }
        return sb.toString();
    }

    public static enum Operation {
        NORMAL,
        LIST,
        QUIET;

    }

    private final class Search {
        final Glob path;
        final Pattern pattern;

        Search(Glob path, Pattern pattern) {
            this.path = path;
            this.pattern = pattern;
        }
    }
}

