/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.zz.grep;

import de.unkrig.commons.file.contentsprocessing.ContentsProcessor;
import de.unkrig.commons.file.fileprocessing.FileProcessor;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.pattern.Glob;
import de.unkrig.zz.grep.Grep;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileProvider;

public class AntTask
extends Task {
    private static final Logger LOGGER = Logger.getLogger(Task.class.getName());
    private final Grep grep = new Grep();
    @Nullable
    private File file;
    @Nullable
    private String path;
    @Nullable
    private String regex;
    @Nullable
    private Boolean caseSensitive;
    @Nullable
    private String property;
    private final List<ResourceCollection> resourceCollections = new ArrayList<ResourceCollection>();

    public void setFile(File file) {
        this.file = file;
    }

    public void setLookInto(String value) {
        this.grep.setLookIntoFormat(Glob.compile(value, -1610612736));
    }

    public void setEncoding(String value) {
        this.grep.setCharset(Charset.forName(value));
    }

    public void setOperation(Grep.Operation value) {
        this.grep.setOperation(value);
    }

    public void setInverted(boolean value) {
        this.grep.setInverted(value);
    }

    public void setDisassembleClassFiles(boolean value) {
        this.grep.setDisassembleClassFiles(value);
    }

    public void setDisassembleClassFilesVerbose(boolean value) {
        this.grep.setDisassembleClassFilesVerbose(value);
    }

    public void setDisassembleClassFilesSourceDirectory(@Nullable File value) {
        this.grep.setDisassembleClassFilesSourceDirectory(value);
    }

    public void setDisassembleClassFilesButHideLines(boolean value) {
        this.grep.setDisassembleClassFilesButHideLines(value);
    }

    public void setDisassembleClassFilesButHideVars(boolean value) {
        this.grep.setDisassembleClassFilesButHideVars(value);
    }

    public void setDisassembleClassFilesSymbolicLabels(boolean value) {
        this.grep.setDisassembleClassFilesSymbolicLabels(value);
    }

    @Deprecated
    public void setName(String value) {
        this.setPath(value);
    }

    public void setPath(String pathGlob) {
        this.path = pathGlob;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public void setCaseSensitive(boolean value) {
        this.caseSensitive = value;
    }

    public void setProperty(String propertyName) {
        this.property = propertyName;
    }

    public void addConfiguredSearch(Element_path_regex_caseSensitive element) {
        if (this.path != null || this.regex != null || this.caseSensitive != null) {
            throw new BuildException("'path=\"...\"', 'regex=\"...\"' and 'caseSensitive=\"...\"' are mutually exclusive with '<search>' subelements");
        }
        String path = element.path;
        String regex = element.regex;
        if (regex == null) {
            throw new BuildException("Attribute 'regex' must be set");
        }
        this.grep.addSearch(path == null ? Glob.ANY : Glob.compile(path, -1610612736), regex, element.caseSensitive);
    }

    public void addConfigured(ResourceCollection value) {
        this.resourceCollections.add(value);
    }

    public void execute() throws BuildException {
        try {
            this.execute2();
        }
        catch (BuildException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void execute2() throws Exception {
        String regex = this.regex;
        String path = this.path;
        Boolean caseSensitive = this.caseSensitive;
        if (regex != null) {
            this.grep.addSearch(path == null ? Glob.ANY : Glob.compile(path, -1610612736), regex, caseSensitive == null ? true : caseSensitive);
        } else if (path != null || caseSensitive != null) {
            throw new BuildException("'path=\"...\"' and 'caseSensitive=\"...\"' don't make sense without 'regex=\"...\"'");
        }
        ContentsProcessor<Void> contentsProcessor = this.grep.contentsProcessor();
        FileProcessor<Void> fileProcessor = this.grep.fileProcessor(false);
        File file = this.file;
        if (file != null) {
            LOGGER.log(Level.CONFIG, "Grepping ''{0}''", file.getPath());
            fileProcessor.process(file.getPath(), file);
        }
        for (ResourceCollection resourceCollection : this.resourceCollections) {
            for (final Resource resource : resourceCollection) {
                String path2 = resource.getName();
                LOGGER.log(Level.CONFIG, "Grepping ''{0}''", path2);
                if (resource.isFilesystemOnly()) {
                    fileProcessor.process(path2, ((FileProvider)resource).getFile());
                    continue;
                }
                InputStream is = resource.getInputStream();
                try {
                    contentsProcessor.process(path2, is, resource.getSize(), -1L, new ProducerWhichThrows<InputStream, IOException>(){

                        @Override
                        @Nullable
                        public InputStream produce() throws IOException {
                            return resource.getInputStream();
                        }
                    });
                    is.close();
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (this.property != null && this.grep.getLinesSelected()) {
            this.getProject().setProperty(this.property, "true");
        }
    }

    public static class Element_path_regex_caseSensitive {
        @Nullable
        private String path;
        @Nullable
        private String regex;
        private boolean caseSensitive = true;

        @Deprecated
        public void setName(String value) {
            this.setPath(value);
        }

        public void setPath(String glob) {
            this.path = glob;
        }

        public void setRegex(String regex) {
            this.regex = regex;
        }

        public void setCaseSensitive(boolean value) {
            this.caseSensitive = value;
        }
    }
}

