/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.zz.find;

import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormatFactory;
import de.unkrig.commons.file.org.apache.commons.compress.compressors.CompressionFormatFactory;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.ProducerUtil;
import de.unkrig.commons.text.LevelFilteredPrinter;
import de.unkrig.commons.text.Printers;
import de.unkrig.commons.text.pattern.Glob;
import de.unkrig.commons.util.CommandLineOptionException;
import de.unkrig.commons.util.CommandLineOptions;
import de.unkrig.commons.util.annotation.CommandLineOption;
import de.unkrig.commons.util.annotation.RegexFlags;
import de.unkrig.commons.util.logging.SimpleLogging;
import de.unkrig.zz.find.Find;
import de.unkrig.zz.find.Parser;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;

public final class Main {
    private final Find find = new Find();
    private final LevelFilteredPrinter levelFilteredPrinter = new LevelFilteredPrinter();

    static {
        AssertionUtil.enableAssertionsForThisClass();
    }

    private Main() {
    }

    public static void main(final String[] args) {
        new Main().levelFilteredPrinter.run(new Runnable(){

            @Override
            public void run() {
                new Main(null).main2(args);
            }
        });
    }

    private void main2(String[] args) {
        try {
            args = CommandLineOptions.parse(args, this);
        }
        catch (CommandLineOptionException cloe) {
            Printers.error(String.valueOf(cloe.getMessage()) + ", try \"--help\".");
            System.exit(1);
        }
        int i = 0;
        ArrayList<String> files = new ArrayList<String>();
        while (i < args.length) {
            String arg = args[i];
            if (arg.startsWith("-") && !"-".equals(arg) || "(".equals(arg) || "!".equals(arg)) break;
            files.add(arg);
            ++i;
        }
        try {
            Parser parser = new Parser(ProducerUtil.fromArray(args, i, args.length), System.out);
            this.find.setExpression(parser.parse());
        }
        catch (Exception e) {
            Printers.error("Parsing predicates", e);
            System.exit(1);
        }
        final boolean[] hadExceptions = new boolean[1];
        ConsumerWhichThrows<IOException, IOException> exceptionHandler = new ConsumerWhichThrows<IOException, IOException>(){

            @Override
            public void consume(IOException ioe) {
                Printers.error(ioe.toString());
                hadExceptions[0] = true;
            }
        };
        this.find.setExceptionHandler((ConsumerWhichThrows<? super IOException, IOException>)exceptionHandler);
        try {
            for (String file : files) {
                try {
                    if ("-".equals(file)) {
                        this.find.findInStream(System.in);
                        continue;
                    }
                    this.find.findInFile(new File(file));
                }
                catch (IOException ioe) {
                    exceptionHandler.consume(ioe);
                }
            }
            if (hadExceptions[0]) {
                System.exit(2);
            }
        }
        catch (Exception e) {
            Printers.error(null, e);
            System.exit(2);
        }
    }

    @CommandLineOption
    public static void help() throws IOException {
        ArrayList<String> algorithms = new ArrayList<String>();
        Provider[] providerArray = Security.getProviders();
        int n = providerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Provider p = providerArray[n2];
            for (Provider.Service s : p.getServices()) {
                if (!"MessageDigest".equals(s.getType())) continue;
                algorithms.add(s.getAlgorithm());
            }
            ++n2;
        }
        System.setProperty("archive.formats", ArchiveFormatFactory.allFormats().toString());
        System.setProperty("compression.formats", CompressionFormatFactory.allFormats().toString());
        System.setProperty("digest.providers", ((Object)algorithms).toString());
        CommandLineOptions.printResource(Main.class, "main(String[]).txt", Charset.forName("UTF-8"), (OutputStream)System.out);
        System.exit(0);
    }

    @CommandLineOption
    public void setLookInto(@RegexFlags(value=-1610612736) Glob fomatAndPath) {
        this.find.setLookIntoFormat(fomatAndPath);
    }

    @CommandLineOption(name={"depth", "descendants-first"})
    public void setDescendantsFirst() {
        this.find.setDescendantsFirst(true);
    }

    @CommandLineOption
    public void setMinDepth(int levels) {
        this.find.setMinDepth(levels);
    }

    @CommandLineOption
    public void setMaxDepth(int levels) {
        this.find.setMaxDepth(levels);
    }

    @CommandLineOption
    public void setNowarn() {
        this.levelFilteredPrinter.setNoWarn();
    }

    @CommandLineOption
    public void setQuiet() {
        this.levelFilteredPrinter.setQuiet();
    }

    @CommandLineOption
    public void setVerbose() {
        this.levelFilteredPrinter.setVerbose();
    }

    @CommandLineOption
    public void setDebug() {
        this.levelFilteredPrinter.setDebug();
    }

    @CommandLineOption(cardinality=CommandLineOption.Cardinality.ANY)
    public static void addLog(String spec) {
        SimpleLogging.configureLoggers(spec);
    }

    @CommandLineOption(name={"-zip", "-zz", "-nested-zip", "-z"})
    public static void noLongerSupported() {
        System.err.println("Command line option is no longer supported - try \"--help\".");
        System.exit(1);
    }

    /* synthetic */ Main(Main main) {
        this();
    }
}

