/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.zz.diff;

import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class NestedZipFileStream
extends FilterInputStream {
    private static final Logger LOGGER = Logger.getAnonymousLogger();
    private final ZipFile zipFile;
    private ZipInputStream[] currentNestedZips = new ZipInputStream[0];
    private String[] currentNestedNames = new String[0];

    static {
        LOGGER.setParent(Logger.getLogger(NestedZipFileStream.class.getName()));
    }

    public NestedZipFileStream(File file) throws IOException {
        super(null);
        try {
            this.zipFile = new ZipFile(file);
        }
        catch (IOException ioe) {
            throw ExceptionUtil.wrap("Opening '" + file + "'", ioe);
        }
    }

    @Override
    public void close() throws IOException {
        int j = 0;
        while (j < this.currentNestedZips.length) {
            if (this.currentNestedZips[j] != null) {
                this.currentNestedZips[j].close();
                this.currentNestedZips[j] = null;
            }
            ++j;
        }
        this.zipFile.close();
    }

    @Nullable
    public ZipEntry getEntry(String[] names) throws IOException {
        block26: {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "ENTRY names={0}", Arrays.asList(names));
            }
            if (names.length == 0) {
                throw new IllegalArgumentException();
            }
            int i = 0;
            while (i < names.length - 1 && i < this.currentNestedNames.length && names[i].equals(this.currentNestedNames[i])) {
                ++i;
            }
            if (i == 0) {
                int j = this.currentNestedZips.length - 1;
                while (j >= 0) {
                    if (this.currentNestedZips[j] != null) {
                        this.currentNestedZips[j].close();
                        this.currentNestedZips[j] = null;
                    }
                    --j;
                }
            } else {
                ZipEntry ze;
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINER, "Attempt reuse from level {0}", i);
                }
                Object[] tmp = new ZipInputStream[names.length];
                System.arraycopy(this.currentNestedZips, 0, tmp, 0, i);
                int j = this.currentNestedZips.length - 1;
                while (j >= i) {
                    if (this.currentNestedZips[j] != null) {
                        this.currentNestedZips[j].close();
                    }
                    --j;
                }
                this.currentNestedZips = tmp;
                tmp = new String[names.length];
                System.arraycopy(this.currentNestedNames, 0, tmp, 0, i);
                this.currentNestedNames = tmp;
                do {
                    if ((ze = this.currentNestedZips[i - 1].getNextEntry()) != null) continue;
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.log(Level.FINER, "Attempted reuse failed on level {0}", i);
                    }
                    j = i - 1;
                    while (j >= 0) {
                        if (this.currentNestedZips[j] != null) {
                            this.currentNestedZips[j].close();
                            this.currentNestedZips[j] = null;
                        }
                        --j;
                    }
                    break block26;
                } while (!ze.getName().equals(names[i]));
                if (i == names.length - 1) {
                    this.in = this.currentNestedZips[i - 1];
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer("Attempted reuse successful");
                    }
                    return ze;
                }
                this.currentNestedZips[i] = new ZipInputStream(this.currentNestedZips[i - 1]);
                this.currentNestedNames[i] = ze.getName();
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINER, "Reusing level {0}", i);
                }
                ++i;
                while (i < names.length) {
                    do {
                        if ((ze = this.currentNestedZips[i - 1].getNextEntry()) != null) continue;
                        return null;
                    } while (!ze.getName().equals(names[i]));
                    if (i == names.length - 1) {
                        this.in = this.currentNestedZips[i - 1];
                        return ze;
                    }
                    this.currentNestedZips[i] = new ZipInputStream(this.currentNestedZips[i - 1]);
                    this.currentNestedNames[i] = ze.getName();
                    ++i;
                }
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Processing ''{0}''", String.valueOf(this.zipFile.getName()) + "!" + names[0]);
        }
        this.currentNestedZips = new ZipInputStream[names.length - 1];
        this.currentNestedNames = new String[names.length - 1];
        ZipEntry ze = this.zipFile.getEntry(names[0]);
        if (ze == null) {
            return null;
        }
        this.in = this.zipFile.getInputStream(ze);
        if (names.length == 1) {
            return ze;
        }
        this.currentNestedNames[0] = names[0];
        this.currentNestedZips[0] = new ZipInputStream(this.in);
        int idx = 1;
        ZipEntry ze2;
        while ((ze2 = this.currentNestedZips[idx - 1].getNextEntry()) != null) {
            if (!ze2.getName().equals(names[idx])) continue;
            this.in = this.currentNestedZips[idx - 1];
            if (idx == names.length - 1) {
                return ze2;
            }
            this.currentNestedNames[idx] = ze2.getName();
            this.currentNestedZips[idx] = new ZipInputStream(this.currentNestedZips[idx - 1]);
            ++idx;
        }
        return null;
    }
}

