/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.zz.diff;

import de.unkrig.commons.io.ByteFilterInputStream;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.Printers;
import de.unkrig.commons.text.scanner.AbstractScanner;
import de.unkrig.commons.text.scanner.JavaScanner;
import de.unkrig.commons.text.scanner.ScanException;
import de.unkrig.commons.text.scanner.ScannerUtil;
import de.unkrig.commons.text.scanner.StringScanner;
import de.unkrig.zz.diff.DisassemblerByteFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Checksum;
import org.incava.util.diff.Diff;
import org.incava.util.diff.Difference;

public class DocumentDiff {
    private static final Pattern WHITESPACE_PATTERN;
    private final Collection<LineEquivalence> equivalentLines = new ArrayList<LineEquivalence>();
    private final Collection<LineEquivalence> ignores = new ArrayList<LineEquivalence>();
    private boolean ignoreWhitespace;
    private boolean disassembleClassFiles;
    private boolean disassembleClassFilesVerbose;
    @Nullable
    private File disassembleClassFilesSourceDirectory;
    private boolean disassembleClassFilesButHideLines;
    private boolean disassembleClassFilesButHideVars;
    private boolean disassembleClassFilesSymbolicLabels;
    private Charset charset = Charset.defaultCharset();
    private DocumentDiffMode documentDiffMode = DocumentDiffMode.NORMAL;
    private int contextSize = 3;
    private Tokenization tokenization = Tokenization.LINE;
    private boolean ignoreCStyleComments;
    private boolean ignoreCPlusPlusStyleComments;
    private boolean ignoreDocComments;
    private static final byte[] IGNORED_LINE;

    static {
        AssertionUtil.enableAssertionsForThisClass();
        WHITESPACE_PATTERN = Pattern.compile("\\s+");
        IGNORED_LINE = new byte[]{127, 47, 25};
    }

    public void setIgnoreWhitespace(boolean value) {
        this.ignoreWhitespace = value;
    }

    public void setDisassembleClassFiles(boolean value) {
        this.disassembleClassFiles = value;
    }

    public void setDisassembleClassFilesVerbose(boolean value) {
        this.disassembleClassFilesVerbose = value;
    }

    public void setDisassembleClassFilesSourceDirectory(@Nullable File value) {
        this.disassembleClassFilesSourceDirectory = value;
    }

    public void setDisassembleClassFilesButHideLines(boolean value) {
        this.disassembleClassFilesButHideLines = value;
    }

    public void setDisassembleClassFilesButHideVars(boolean value) {
        this.disassembleClassFilesButHideVars = value;
    }

    public void setDisassembleClassFilesSymbolicLabels(boolean value) {
        this.disassembleClassFilesSymbolicLabels = value;
    }

    public void setCharset(Charset value) {
        this.charset = value;
    }

    public void setDocumentDiffMode(DocumentDiffMode value) {
        this.documentDiffMode = value;
    }

    public void setContextSize(int value) {
        this.contextSize = value;
    }

    public void setTokenization(Tokenization value) {
        this.tokenization = value;
    }

    public void setIgnoreCStyleComments(boolean value) {
        this.ignoreCStyleComments = value;
    }

    public void setIgnoreCPlusPlusStyleComments(boolean value) {
        this.ignoreCPlusPlusStyleComments = value;
    }

    public void setIgnoreDocComments(boolean value) {
        this.ignoreDocComments = value;
    }

    public void addEquivalentLine(LineEquivalence lineEquivalence) {
        this.equivalentLines.add(lineEquivalence);
    }

    public void addIgnore(LineEquivalence lineEquivalence) {
        this.ignores.add(lineEquivalence);
    }

    public long diff(String path1, String path2, InputStream stream1, InputStream stream2) throws IOException {
        Line[] lines1 = this.readAllLines(stream1, path1);
        Line[] lines2 = this.readAllLines(stream2, path2);
        Printers.verbose("''{0}'' ({1} {1,choice,0#lines|1#line|1<lines}) vs. ''{2}'' ({3} {3,choice,0#lines|1#line|1<lines})", path1, lines1.length, path2, lines2.length);
        List<Difference> diffs = this.logicalDiff(lines1, lines2);
        Printers.verbose("{0} raw {0,choice,0#differences|1#difference|1<differences} found", diffs.size());
        if (diffs.isEmpty()) {
            return 0L;
        }
        ArrayList<Pattern> effectiveIgnores = new ArrayList<Pattern>();
        for (LineEquivalence ignore : this.ignores) {
            if (!ignore.pathPattern.evaluate(path1)) continue;
            effectiveIgnores.add(ignore.lineRegex);
        }
        if (!effectiveIgnores.isEmpty()) {
            Iterator<Difference> it = diffs.iterator();
            block6: while (it.hasNext()) {
                int i;
                Difference d = it.next();
                if (d.getDeletedStart() != -1) {
                    i = d.getDeletedStart();
                    while (i <= d.getDeletedEnd()) {
                        if (!DocumentDiff.contains(lines1[i].text, effectiveIgnores)) continue block6;
                        ++i;
                    }
                }
                if (d.getAddedStart() != -1) {
                    i = d.getAddedStart();
                    while (i <= d.getAddedEnd()) {
                        if (!DocumentDiff.contains(lines2[i].text, effectiveIgnores)) continue block6;
                        ++i;
                    }
                }
                it.remove();
            }
            Printers.verbose("Reduced to {0} non-ignorable differences", diffs.size());
            if (diffs.isEmpty()) {
                return 0L;
            }
        }
        switch (this.documentDiffMode) {
            case NORMAL: {
                DocumentDiff.normalDiff(lines1, lines2, diffs);
                break;
            }
            case CONTEXT: {
                Printers.info("*** " + path1);
                Printers.info("--- " + path2);
                this.contextDiff(lines1, lines2, diffs);
                break;
            }
            case UNIFIED: {
                Printers.info("--- " + path1);
                Printers.info("+++ " + path2);
                this.unifiedDiff(lines1, lines2, diffs);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return diffs.size();
    }

    private List<Difference> logicalDiff(Line[] lines1, Line[] lines2) {
        switch (this.tokenization) {
            case LINE: {
                return new Diff<Line>(lines1, lines2).diff();
            }
            case JAVA: {
                HashMap<Integer, Integer> tokenIndexToLineIndex1 = new HashMap<Integer, Integer>(lines1.length);
                HashMap<Integer, Integer> tokenIndexToLineIndex2 = new HashMap<Integer, Integer>(lines2.length);
                List<String> tokens1 = this.tokenize(lines1, tokenIndexToLineIndex1);
                List<String> tokens2 = this.tokenize(lines2, tokenIndexToLineIndex2);
                List<Difference> diffs = new Diff<Object>(tokens1.toArray(), tokens2.toArray()).diff();
                ArrayList<Difference> tmp = new ArrayList<Difference>();
                if (!diffs.isEmpty()) {
                    int ae1;
                    int as1;
                    int de1;
                    Difference d = diffs.get(0);
                    int ds1 = d.getDeletedStart();
                    if (ds1 != -1) {
                        ds1 = (Integer)tokenIndexToLineIndex1.get(ds1);
                    }
                    if ((de1 = d.getDeletedEnd()) != -1) {
                        de1 = (Integer)tokenIndexToLineIndex1.get(de1);
                    }
                    if ((as1 = d.getAddedStart()) != -1) {
                        as1 = (Integer)tokenIndexToLineIndex2.get(as1);
                    }
                    if ((ae1 = d.getAddedEnd()) != -1) {
                        ae1 = (Integer)tokenIndexToLineIndex2.get(ae1);
                    }
                    int i = 1;
                    while (i < diffs.size()) {
                        int ae2;
                        int as2;
                        int de2;
                        d = diffs.get(i);
                        int ds2 = d.getDeletedStart();
                        if (ds2 != -1) {
                            ds2 = (Integer)tokenIndexToLineIndex1.get(ds2);
                        }
                        if ((de2 = d.getDeletedEnd()) != -1) {
                            de2 = (Integer)tokenIndexToLineIndex1.get(de2);
                        }
                        if ((as2 = d.getAddedStart()) != -1) {
                            as2 = (Integer)tokenIndexToLineIndex2.get(as2);
                        }
                        if ((ae2 = d.getAddedEnd()) != -1) {
                            ae2 = (Integer)tokenIndexToLineIndex2.get(ae2);
                        }
                        if (!(de1 == -1 ? ds2 > ds1 + 1 : ds2 != de1) || (ae1 == -1 ? as2 <= as1 + 1 : as2 == ae1)) {
                            de1 = de2 != -1 ? de2 : ds2;
                            ae1 = ae2 != -1 ? ae2 : as2;
                        } else {
                            tmp.add(new Difference(ds1, de1, as1, ae1));
                            ds1 = ds2;
                            de1 = de2;
                            as1 = as2;
                            ae1 = ae2;
                        }
                        ++i;
                    }
                    tmp.add(new Difference(ds1, de1, as1, ae1));
                }
                return tmp;
            }
        }
        throw new AssertionError((Object)this.tokenization);
    }

    private List<String> tokenize(Line[] lines, Map<Integer, Integer> tokenIndexToLineIndex) {
        ArrayList<String> tokens = new ArrayList<String>(lines.length);
        StringScanner<JavaScanner.TokenType> ss = ScannerUtil.filter(JavaScanner.rawStringScanner(), new Predicate<AbstractScanner.Token<JavaScanner.TokenType>>(){
            boolean ignoreThisComment;

            @Override
            public boolean evaluate(@Nullable AbstractScanner.Token<JavaScanner.TokenType> token) {
                if (token == null) {
                    return true;
                }
                if (token.type == JavaScanner.TokenType.C_COMMENT || token.type == JavaScanner.TokenType.MULTI_LINE_C_COMMENT_BEGINNING) {
                    boolean bl = this.ignoreThisComment = token.text.startsWith("/**") ? DocumentDiff.this.ignoreDocComments : DocumentDiff.this.ignoreCStyleComments;
                }
                if (token.type == JavaScanner.TokenType.C_COMMENT || token.type == JavaScanner.TokenType.MULTI_LINE_C_COMMENT_BEGINNING || token.type == JavaScanner.TokenType.MULTI_LINE_C_COMMENT_MIDDLE || token.type == JavaScanner.TokenType.MULTI_LINE_C_COMMENT_END) {
                    return !this.ignoreThisComment;
                }
                if (token.type == JavaScanner.TokenType.CXX_COMMENT) {
                    return !DocumentDiff.this.ignoreCPlusPlusStyleComments;
                }
                return token.type != JavaScanner.TokenType.SPACE;
            }
        });
        int lineIndex = 0;
        while (lineIndex < lines.length) {
            String line = lines[lineIndex].toString();
            ss.setInput(line);
            try {
                AbstractScanner.Token<JavaScanner.TokenType> t = ss.produce();
                while (t != null) {
                    tokenIndexToLineIndex.put(tokens.size(), lineIndex);
                    tokens.add(t.text);
                    t = ss.produce();
                }
            }
            catch (ScanException scanException) {
                // empty catch block
            }
            ++lineIndex;
        }
        return tokens;
    }

    private static boolean contains(String text, Iterable<Pattern> patterns) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(text).find()) continue;
            return true;
        }
        return false;
    }

    private static void normalDiff(Line[] lines1, Line[] lines2, List<Difference> diffs) {
        for (Difference diff : diffs) {
            int delStart = diff.getDeletedStart();
            int delEnd = diff.getDeletedEnd();
            int addStart = diff.getAddedStart();
            int addEnd = diff.getAddedEnd();
            Printers.info(String.valueOf(DocumentDiff.toString(delStart, delEnd)) + (delEnd == -1 ? "a" : (addEnd == -1 ? "d" : "c")) + DocumentDiff.toString(addStart, addEnd));
            if (delEnd != -1) {
                DocumentDiff.printLines(delStart, delEnd, "< ", lines1);
                if (addEnd != -1) {
                    Printers.info("---");
                }
            }
            if (addEnd == -1) continue;
            DocumentDiff.printLines(addStart, addEnd, "> ", lines2);
        }
    }

    private void contextDiff(final Line[] lines1, final Line[] lines2, List<Difference> diffs) {
        this.chunkedDiff(diffs, new ChunkPrinter(){

            @Override
            public void print(List<Difference> chunk) {
                Printers.info("***************");
                Difference firstDifference = chunk.get(0);
                Difference lastDifference = chunk.get(chunk.size() - 1);
                int boc1 = Math.max(0, firstDifference.getDeletedStart() - DocumentDiff.this.contextSize);
                int eoc1 = Math.min(lastDifference.getDeletedEnd() == -1 ? lastDifference.getDeletedStart() + DocumentDiff.this.contextSize - 1 : lastDifference.getDeletedEnd() + DocumentDiff.this.contextSize, lines1.length - 1);
                Printers.info("*** " + DocumentDiff.toString(boc1, eoc1) + " ****");
                for (Difference d : chunk) {
                    DocumentDiff.printLines(boc1, d.getDeletedStart() - 1, "  ", lines1);
                    if (d.getDeletedEnd() == -1) {
                        boc1 = d.getDeletedStart();
                        continue;
                    }
                    DocumentDiff.printLines(d.getDeletedStart(), d.getDeletedEnd(), d.getAddedEnd() == -1 ? "- " : "! ", lines1);
                    boc1 = d.getDeletedEnd() + 1;
                }
                DocumentDiff.printLines(boc1, eoc1, "  ", lines1);
                int boc2 = Math.max(0, firstDifference.getAddedStart() - DocumentDiff.this.contextSize);
                int eoc2 = Math.min(lastDifference.getAddedEnd() == -1 ? lastDifference.getAddedStart() + DocumentDiff.this.contextSize - 1 : lastDifference.getAddedEnd() + DocumentDiff.this.contextSize, lines2.length - 1);
                Printers.info("--- " + DocumentDiff.toString(boc2, eoc2) + " ----");
                for (Difference d : chunk) {
                    DocumentDiff.printLines(boc2, d.getAddedStart() - 1, "  ", lines2);
                    if (d.getAddedEnd() == -1) {
                        boc2 = d.getAddedStart();
                        continue;
                    }
                    DocumentDiff.printLines(d.getAddedStart(), d.getAddedEnd(), d.getDeletedEnd() == -1 ? "+ " : "! ", lines2);
                    boc2 = d.getAddedEnd() + 1;
                }
                DocumentDiff.printLines(boc2, eoc2, "  ", lines2);
            }
        });
    }

    private void unifiedDiff(final Line[] lines1, final Line[] lines2, List<Difference> diffs) {
        this.chunkedDiff(diffs, new ChunkPrinter(){

            @Override
            public void print(List<Difference> chunk) {
                Difference firstDifference = chunk.get(0);
                Difference lastDifference = chunk.get(chunk.size() - 1);
                int boc1 = Math.max(0, firstDifference.getDeletedStart() - DocumentDiff.this.contextSize);
                int eoc1 = Math.min(lastDifference.getDeletedEnd() == -1 ? lastDifference.getDeletedStart() + DocumentDiff.this.contextSize - 1 : lastDifference.getDeletedEnd() + DocumentDiff.this.contextSize, lines1.length - 1);
                int boc2 = Math.max(0, firstDifference.getAddedStart() - DocumentDiff.this.contextSize);
                int eoc2 = Math.min(lastDifference.getAddedEnd() == -1 ? lastDifference.getAddedStart() + DocumentDiff.this.contextSize - 1 : lastDifference.getAddedEnd() + DocumentDiff.this.contextSize, lines2.length - 1);
                Printers.info("@@ -" + (boc1 + 1) + "," + (eoc1 - boc1 + 1) + " +" + (boc2 + 1) + "," + (eoc2 - boc2 + 1) + " @@");
                for (Difference d : chunk) {
                    DocumentDiff.printLines(boc1, d.getDeletedStart() - 1, " ", lines1);
                    if (d.getDeletedEnd() == -1) {
                        boc1 = d.getDeletedStart();
                    } else {
                        DocumentDiff.printLines(d.getDeletedStart(), d.getDeletedEnd(), "-", lines1);
                        boc1 = d.getDeletedEnd() + 1;
                    }
                    if (d.getAddedEnd() == -1) {
                        boc2 = d.getAddedStart();
                        continue;
                    }
                    DocumentDiff.printLines(d.getAddedStart(), d.getAddedEnd(), "+", lines2);
                    boc2 = d.getAddedEnd() + 1;
                }
                DocumentDiff.printLines(boc1, eoc1, " ", lines1);
            }
        });
    }

    private void chunkedDiff(List<Difference> diffs, ChunkPrinter chunkPrinter) {
        Iterator<Difference> it = diffs.iterator();
        Difference lookahead = it.hasNext() ? it.next() : null;
        while (lookahead != null) {
            ArrayList<Difference> agg = new ArrayList<Difference>();
            agg.add(lookahead);
            while (true) {
                int afterDeletion = lookahead.getDeletedEnd() == -1 ? lookahead.getDeletedStart() : lookahead.getDeletedEnd() + 1;
                Difference difference = lookahead = it.hasNext() ? it.next() : null;
                if (lookahead == null || lookahead.getDeletedStart() - afterDeletion > 2 * this.contextSize) break;
                agg.add(lookahead);
            }
            chunkPrinter.print(agg);
        }
    }

    private static String toString(int start, int end) {
        StringBuilder sb = new StringBuilder();
        sb.append(end == -1 ? start : start + 1);
        if (end != -1 && start != end) {
            sb.append(",").append(end + 1);
        }
        return sb.toString();
    }

    private static void printLines(int start, int end, String indicator, Line[] lines) {
        int lnum = start;
        while (lnum <= end) {
            Printers.info(String.valueOf(indicator) + lines[lnum]);
            ++lnum;
        }
    }

    private Line[] readAllLines(InputStream inputStream, String path) throws IOException {
        try {
            Line[] lineArray = this.readAllLines2(inputStream, path);
            return lineArray;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private Line[] readAllLines2(InputStream is, String path) throws IOException {
        if (this.disassembleClassFiles && path.endsWith(".class")) {
            DisassemblerByteFilter disassemblerByteFilter = new DisassemblerByteFilter();
            disassemblerByteFilter.setVerbose(this.disassembleClassFilesVerbose);
            disassemblerByteFilter.setSourceDirectory(this.disassembleClassFilesSourceDirectory);
            disassemblerByteFilter.setHideLines(this.disassembleClassFilesButHideLines);
            disassemblerByteFilter.setHideVars(this.disassembleClassFilesButHideVars);
            disassemblerByteFilter.setSymbolicLabels(this.disassembleClassFilesSymbolicLabels);
            is = new ByteFilterInputStream(is, disassemblerByteFilter);
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(is, this.charset));
        ArrayList<Pattern> equivalences = new ArrayList<Pattern>();
        for (LineEquivalence le : this.equivalentLines) {
            if (!le.pathPattern.evaluate(path)) continue;
            equivalences.add(le.lineRegex);
        }
        ArrayList<Line> contents = new ArrayList<Line>();
        try {
            Line line;
            while ((line = this.readLine(br, equivalences)) != null) {
                contents.add(line);
            }
        }
        catch (IOException ioe) {
            throw ExceptionUtil.wrap("Reading '" + path + "'", ioe);
        }
        catch (RuntimeException re) {
            throw ExceptionUtil.wrap("Reading '" + path + "'", re);
        }
        return contents.toArray(new Line[contents.size()]);
    }

    @Nullable
    private Line readLine(BufferedReader br, Collection<Pattern> equivalences) throws IOException {
        String line = br.readLine();
        if (line == null) {
            return null;
        }
        return new Line(line, equivalences);
    }

    private static interface Checksummable {
        public void update(Checksum var1);
    }

    private static interface ChunkPrinter {
        public void print(List<Difference> var1);
    }

    public static enum DocumentDiffMode {
        NORMAL,
        CONTEXT,
        UNIFIED;

    }

    private class Line
    implements Checksummable {
        private final String text;
        private byte[] value;

        Line(String text, Collection<Pattern> equivalences) {
            this.text = text;
            if (DocumentDiff.this.ignoreWhitespace) {
                text = WHITESPACE_PATTERN.matcher(text).replaceAll(" ");
            }
            for (Pattern p : equivalences) {
                Matcher matcher = p.matcher(text);
                if (!matcher.find()) continue;
                if (matcher.groupCount() == 0) {
                    this.value = IGNORED_LINE;
                    return;
                }
                StringBuffer sb = new StringBuffer();
                do {
                    String replacement = "";
                    int i = 1;
                    while (i <= matcher.groupCount()) {
                        replacement = String.valueOf(replacement) + "$" + i;
                        ++i;
                    }
                    matcher.appendReplacement(sb, replacement);
                } while (matcher.find());
                matcher.appendTail(sb);
                text = sb.toString();
            }
            this.value = text.getBytes(Charset.forName("UTF-8"));
        }

        public boolean equals(@Nullable Object o) {
            if (!(o instanceof Line)) {
                return false;
            }
            Line that = (Line)o;
            return this == that || Arrays.equals(this.value, that.value);
        }

        public int hashCode() {
            return Arrays.hashCode(this.value);
        }

        public String toString() {
            return this.text;
        }

        @Override
        public void update(Checksum checksum) {
            checksum.update(this.value, 0, this.value.length);
        }
    }

    public static class LineEquivalence {
        public final Predicate<? super String> pathPattern;
        public final Pattern lineRegex;

        public LineEquivalence(Predicate<? super String> pathPattern, Pattern lineRegex) {
            this.pathPattern = pathPattern;
            this.lineRegex = lineRegex;
        }

        public String toString() {
            return this.pathPattern + ":" + this.lineRegex;
        }
    }

    public static enum Tokenization {
        LINE,
        JAVA;

    }
}

