/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.jdisasm;

import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.jdisasm.SignatureParser;
import java.io.DataInputStream;
import java.io.IOException;

public class ConstantPool {
    private SignatureParser signatureParser;
    final ConstantPoolEntry[] entries;

    public ConstantPool(final DataInputStream dis, SignatureParser signatureParser) throws IOException {
        this.signatureParser = signatureParser;
        int count = 0xFFFF & dis.readShort();
        abstract class RawEntry {
            RawEntry() {
            }

            abstract ConstantPoolEntry cook();

            ConstantClassInfo getConstantClassInfo(short index) {
                return (ConstantClassInfo)this.get(index);
            }

            ConstantNameAndTypeInfo getConstantNameAndTypeInfo(short index) {
                return (ConstantNameAndTypeInfo)this.get(index);
            }

            ConstantUtf8Info getConstantUtf8Info(short index) {
                return (ConstantUtf8Info)this.get(index);
            }

            abstract ConstantPoolEntry get(short var1);
        }
        final RawEntry[] rawEntries = new RawEntry[count];
        int i = 1;
        while (i < count) {
            abstract class RawEntry2
            extends RawEntry {
                final /* synthetic */ RawEntry[] val$rawEntries;

                RawEntry2() {
                    this.val$rawEntries = rawEntryArray;
                }

                @Override
                ConstantPoolEntry get(short index) {
                    if (ConstantPool.this.entries[0xFFFF & index] == null) {
                        ConstantPool.this.entries[0xFFFF & index] = new ConstantPoolEntry(){

                            @Nullable
                            public String toString() {
                                return null;
                            }
                        };
                        ConstantPool.this.entries[0xFFFF & index] = this.val$rawEntries[0xFFFF & index].cook();
                    }
                    return ConstantPool.this.entries[0xFFFF & index];
                }
            }
            RawEntry2 re;
            int idx = i++;
            byte tag = dis.readByte();
            switch (tag) {
                case 7: {
                    re = new RawEntry2(){
                        final short nameIndex;
                        {
                            super(ConstantPool.this, rawEntryArray);
                            this.nameIndex = dis.readShort();
                        }

                        @Override
                        ConstantPoolEntry cook() {
                            return new ConstantClassInfo(this.getConstantUtf8Info((short)this.nameIndex).bytes.replace('/', '.'));
                        }
                    };
                    break;
                }
                case 9: {
                    re = new RawEntry2(){
                        final short classIndex;
                        final short nameAndTypeIndex;
                        {
                            super(ConstantPool.this, rawEntryArray);
                            this.classIndex = dis.readShort();
                            this.nameAndTypeIndex = dis.readShort();
                        }

                        @Override
                        ConstantPoolEntry cook() {
                            return new ConstantFieldrefInfo(this.getConstantClassInfo(this.classIndex), this.getConstantNameAndTypeInfo(this.nameAndTypeIndex));
                        }
                    };
                    ++i;
                    break;
                }
                case 10: {
                    re = new RawEntry2(){
                        final short classIndex;
                        final short nameAndTypeIndex;
                        {
                            super(ConstantPool.this, rawEntryArray);
                            this.classIndex = dis.readShort();
                            this.nameAndTypeIndex = dis.readShort();
                        }

                        @Override
                        ConstantPoolEntry cook() {
                            return new ConstantMethodrefInfo(this.getConstantClassInfo(this.classIndex), this.getConstantNameAndTypeInfo(this.nameAndTypeIndex));
                        }
                    };
                    ++i;
                    break;
                }
                case 11: {
                    re = new RawEntry2(){
                        final short classIndex;
                        final short nameAndTypeIndex;
                        {
                            super(ConstantPool.this, rawEntryArray);
                            this.classIndex = dis.readShort();
                            this.nameAndTypeIndex = dis.readShort();
                        }

                        @Override
                        ConstantPoolEntry cook() {
                            return new ConstantInterfaceMethodrefInfo(this.getConstantClassInfo(this.classIndex), this.getConstantNameAndTypeInfo(this.nameAndTypeIndex));
                        }
                    };
                    ++i;
                    break;
                }
                case 8: {
                    re = new RawEntry2(){
                        final short stringIndex;
                        {
                            super(ConstantPool.this, rawEntryArray);
                            this.stringIndex = dis.readShort();
                        }

                        @Override
                        ConstantPoolEntry cook() {
                            return new ConstantStringInfo(this.getConstantUtf8Info((short)this.stringIndex).bytes);
                        }
                    };
                    ++i;
                    break;
                }
                case 3: {
                    re = new RawEntry2(){
                        final int byteS;
                        {
                            super(ConstantPool.this, rawEntryArray);
                            this.byteS = dis.readInt();
                        }

                        @Override
                        ConstantPoolEntry cook() {
                            return new ConstantIntegerInfo(this.byteS);
                        }
                    };
                    ++i;
                    break;
                }
                case 4: {
                    re = new RawEntry2(){
                        final float byteS;
                        {
                            super(ConstantPool.this, rawEntryArray);
                            this.byteS = dis.readFloat();
                        }

                        @Override
                        ConstantPoolEntry cook() {
                            return new ConstantFloatInfo(this.byteS);
                        }
                    };
                    ++i;
                    break;
                }
                case 5: {
                    re = new RawEntry2(){
                        final long bytes;
                        {
                            super(ConstantPool.this, rawEntryArray);
                            this.bytes = dis.readLong();
                        }

                        @Override
                        ConstantPoolEntry cook() {
                            return new ConstantLongInfo(this.bytes);
                        }
                    };
                    i += 2;
                    break;
                }
                case 6: {
                    re = new RawEntry2(){
                        final double bytes;
                        {
                            super(ConstantPool.this, rawEntryArray);
                            this.bytes = dis.readDouble();
                        }

                        @Override
                        ConstantPoolEntry cook() {
                            return new ConstantDoubleInfo(this.bytes);
                        }
                    };
                    i += 2;
                    break;
                }
                case 12: {
                    re = new RawEntry2(){
                        final short nameIndex;
                        final short descriptorIndex;
                        {
                            super(ConstantPool.this, rawEntryArray);
                            this.nameIndex = dis.readShort();
                            this.descriptorIndex = dis.readShort();
                        }

                        @Override
                        ConstantPoolEntry cook() {
                            return new ConstantNameAndTypeInfo(this.getConstantUtf8Info(this.nameIndex), this.getConstantUtf8Info(this.descriptorIndex));
                        }
                    };
                    ++i;
                    break;
                }
                case 1: {
                    re = new RawEntry2(){
                        final String bytes;
                        {
                            super(ConstantPool.this, rawEntryArray);
                            this.bytes = dis.readUTF();
                        }

                        @Override
                        ConstantPoolEntry cook() {
                            return new ConstantUtf8Info(this.bytes);
                        }
                    };
                    ++i;
                    break;
                }
                case 15: {
                    re = new RawEntry2(){
                        final byte referenceKind;
                        final short referenceIndex;
                        {
                            super(ConstantPool.this, rawEntryArray);
                            this.referenceKind = dis.readByte();
                            this.referenceIndex = dis.readShort();
                        }

                        @Override
                        ConstantPoolEntry cook() {
                            return new ConstantMethodHandleInfo(this.referenceKind, this.get(this.referenceIndex));
                        }
                    };
                    ++i;
                    break;
                }
                case 16: {
                    re = new RawEntry2(){
                        final short descriptorIndex;
                        {
                            super(ConstantPool.this, rawEntryArray);
                            this.descriptorIndex = dis.readShort();
                        }

                        @Override
                        ConstantPoolEntry cook() {
                            return new ConstantMethodTypeInfo(this.getConstantUtf8Info(this.descriptorIndex));
                        }
                    };
                    ++i;
                    break;
                }
                case 18: {
                    re = new RawEntry2(){
                        final short bootstrapMethodAttrIndex;
                        final short nameAndTypeIndex;
                        {
                            super(ConstantPool.this, rawEntryArray);
                            this.bootstrapMethodAttrIndex = dis.readShort();
                            this.nameAndTypeIndex = dis.readShort();
                        }

                        @Override
                        ConstantPoolEntry cook() {
                            return new ConstantInvokeDynamicInfo(this.bootstrapMethodAttrIndex, this.getConstantNameAndTypeInfo(this.nameAndTypeIndex));
                        }
                    };
                    ++i;
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid cp_info tag " + tag + " on entry #" + i + " of " + count);
                }
            }
            rawEntries[idx] = re;
        }
        this.entries = new ConstantPoolEntry[count];
        for (i = 0; i < count; ++i) {
            try {
                if (this.entries[i] != null || rawEntries[i] == null) continue;
                this.entries[i] = rawEntries[i].cook();
                continue;
            }
            catch (RuntimeException re) {
                throw new RuntimeException("Cooking CP entry #" + i + " of " + count + ": " + re.getMessage(), re);
            }
        }
    }

    public void setSignatureParser(SignatureParser signatureParser) {
        this.signatureParser = signatureParser;
    }

    public <T extends ConstantPoolEntry> T get(short index, Class<T> clasS) {
        int ii = 0xFFFF & index;
        if (ii == 0 || ii >= this.entries.length) {
            throw new IllegalArgumentException("Illegal constant pool index " + ii + " - only 1..." + (this.entries.length - 1) + " allowed");
        }
        ConstantPoolEntry e = this.entries[ii];
        if (e == null) {
            throw new NullPointerException("Unusable CP entry " + index);
        }
        if (!clasS.isAssignableFrom(e.getClass())) {
            throw new RuntimeException("CP entry #" + index + " is a " + e.getClass().getSimpleName() + ", not a " + clasS.getSimpleName());
        }
        ConstantPoolEntry result = e;
        return (T)result;
    }

    @Nullable
    public <T extends ConstantPoolEntry> T getOptional(short index, Class<T> clasS) {
        if (index == 0) {
            return null;
        }
        int ii = 0xFFFF & index;
        if (ii >= this.entries.length) {
            throw new IllegalArgumentException("Illegal constant pool index " + ii + " - only 0..." + (this.entries.length - 1) + " allowed");
        }
        ConstantPoolEntry e = this.entries[ii];
        if (e == null) {
            throw new NullPointerException("Unusable CP entry " + index);
        }
        if (!clasS.isAssignableFrom(e.getClass())) {
            throw new RuntimeException("CP entry #" + index + " is a " + e.getClass().getSimpleName() + ", not a " + clasS.getSimpleName());
        }
        ConstantPoolEntry result = e;
        return (T)result;
    }

    public int getSize() {
        return this.entries.length;
    }

    public static String stringToJavaLiteral(String s) {
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            int idx = "\r\n\"\t\b".indexOf(c);
            if (idx == -1) {
                ++i;
            } else {
                s = s.substring(0, i) + '\\' + "rn\"tb".charAt(idx) + s.substring(i + 1);
                i += 2;
            }
            if (i < 80) continue;
            return '\"' + s.substring(0, i) + "\"...";
        }
        return '\"' + s + '\"';
    }

    public static interface ConstantDoubleOrLongInfo
    extends ConstantPoolEntry {
    }

    public static interface ConstantDoubleOrFloatOrIntegerOrLongOrStringInfo
    extends ConstantPoolEntry {
    }

    public static interface ConstantDoubleOrFloatOrIntegerOrLongInfo
    extends ConstantPoolEntry {
    }

    public static interface ConstantClassOrFloatOrIntegerOrStringInfo
    extends ConstantPoolEntry {
    }

    public static class ConstantInvokeDynamicInfo
    implements ConstantPoolEntry {
        public final short bootstrapMethodAttrIndex;
        public final ConstantNameAndTypeInfo nameAndType;

        public ConstantInvokeDynamicInfo(short bootstrapMethodAttrIndex, ConstantNameAndTypeInfo nameAndType) {
            this.bootstrapMethodAttrIndex = bootstrapMethodAttrIndex;
            this.nameAndType = nameAndType;
        }

        public String toString() {
            return this.bootstrapMethodAttrIndex + ":" + this.nameAndType.name.toString();
        }
    }

    public class ConstantMethodTypeInfo
    implements ConstantPoolEntry {
        public final ConstantUtf8Info descriptor;

        public ConstantMethodTypeInfo(ConstantUtf8Info descriptor) {
            this.descriptor = descriptor;
        }

        public String toString() {
            try {
                return ConstantPool.this.signatureParser.decodeMethodDescriptor(this.descriptor.toString()).toString();
            }
            catch (SignatureParser.SignatureException e) {
                return this.descriptor.toString();
            }
        }
    }

    public static class ConstantMethodHandleInfo
    implements ConstantPoolEntry {
        private final short referenceKind;
        private final ConstantPoolEntry reference;

        public ConstantMethodHandleInfo(byte referenceKind, ConstantPoolEntry reference) {
            this.referenceKind = referenceKind;
            this.reference = reference;
        }

        public String toString() {
            return (this.referenceKind == 1 ? "REF_getField" : (this.referenceKind == 2 ? "REF_getStatic" : (this.referenceKind == 3 ? "REF_putField" : (this.referenceKind == 4 ? "REF_putStatic" : (this.referenceKind == 5 ? "REF_invokeVirtual" : (this.referenceKind == 6 ? "REF_invokeStatic" : (this.referenceKind == 7 ? "REF_invokeSpecial" : (this.referenceKind == 8 ? "REF_newInvokeSpecial" : (this.referenceKind == 9 ? "REF_invokeInterface" : "REF_??? (" + this.referenceKind + ")"))))))))) + ":" + this.reference.toString();
        }
    }

    public static class ConstantUtf8Info
    implements ConstantPoolEntry {
        public final String bytes;

        public ConstantUtf8Info(String bytes) {
            this.bytes = bytes;
        }

        public String toString() {
            return this.bytes;
        }
    }

    public class ConstantNameAndTypeInfo
    implements ConstantPoolEntry {
        public final ConstantUtf8Info name;
        public final ConstantUtf8Info descriptor;

        public ConstantNameAndTypeInfo(ConstantUtf8Info name, ConstantUtf8Info descriptor) {
            this.name = name;
            this.descriptor = descriptor;
        }

        public String toString() {
            try {
                return this.name + " : " + (this.descriptor.bytes.indexOf(40) == -1 ? ConstantPool.this.signatureParser.decodeFieldDescriptor(this.descriptor.bytes) : ConstantPool.this.signatureParser.decodeMethodDescriptor(this.descriptor.bytes));
            }
            catch (SignatureParser.SignatureException e) {
                return this.name + " : " + this.descriptor;
            }
        }
    }

    public static class ConstantDoubleInfo
    implements ConstantDoubleOrFloatOrIntegerOrLongOrStringInfo,
    ConstantDoubleOrLongInfo,
    ConstantDoubleOrFloatOrIntegerOrLongInfo {
        public final double bytes;

        public ConstantDoubleInfo(double bytes) {
            this.bytes = bytes;
        }

        public String toString() {
            return this.bytes + "D";
        }
    }

    public static class ConstantLongInfo
    implements ConstantDoubleOrFloatOrIntegerOrLongOrStringInfo,
    ConstantDoubleOrLongInfo,
    ConstantDoubleOrFloatOrIntegerOrLongInfo {
        public final long bytes;

        public ConstantLongInfo(long bytes) {
            this.bytes = bytes;
        }

        public String toString() {
            return this.bytes + "L";
        }
    }

    public static class ConstantFloatInfo
    implements ConstantClassOrFloatOrIntegerOrStringInfo,
    ConstantDoubleOrFloatOrIntegerOrLongOrStringInfo,
    ConstantDoubleOrFloatOrIntegerOrLongInfo {
        public final float bytes;

        public ConstantFloatInfo(float bytes) {
            this.bytes = bytes;
        }

        public String toString() {
            return this.bytes + "F";
        }
    }

    public static class ConstantIntegerInfo
    implements ConstantClassOrFloatOrIntegerOrStringInfo,
    ConstantDoubleOrFloatOrIntegerOrLongOrStringInfo,
    ConstantDoubleOrFloatOrIntegerOrLongInfo {
        public final int bytes;

        public ConstantIntegerInfo(int bytes) {
            this.bytes = bytes;
        }

        public String toString() {
            return Integer.toString(this.bytes);
        }
    }

    public static class ConstantStringInfo
    implements ConstantClassOrFloatOrIntegerOrStringInfo,
    ConstantDoubleOrFloatOrIntegerOrLongOrStringInfo {
        public final String string;

        public ConstantStringInfo(String string) {
            this.string = string;
        }

        public String toString() {
            return ConstantPool.stringToJavaLiteral(this.string);
        }
    }

    public class ConstantInterfaceMethodrefOrMethodrefInfo
    implements ConstantPoolEntry {
        public final ConstantClassInfo clasS;
        public final ConstantNameAndTypeInfo nameAndType;

        public ConstantInterfaceMethodrefOrMethodrefInfo(ConstantClassInfo clasS, ConstantNameAndTypeInfo nameAndType) {
            this.clasS = clasS;
            this.nameAndType = nameAndType;
        }

        public String toString() {
            try {
                return this.clasS.name + ":::" + ConstantPool.this.signatureParser.decodeMethodDescriptor(this.nameAndType.descriptor.toString()).toString(this.clasS.name, this.nameAndType.name.toString());
            }
            catch (SignatureParser.SignatureException e) {
                return this.clasS.name + ":::" + this.nameAndType;
            }
        }
    }

    public class ConstantInterfaceMethodrefInfo
    extends ConstantInterfaceMethodrefOrMethodrefInfo {
        public ConstantInterfaceMethodrefInfo(ConstantClassInfo clasS, ConstantNameAndTypeInfo nameAndType) {
            super(clasS, nameAndType);
        }

        @Override
        public String toString() {
            return super.toString().replace(":::", "::");
        }
    }

    public class ConstantMethodrefInfo
    extends ConstantInterfaceMethodrefOrMethodrefInfo {
        public ConstantMethodrefInfo(ConstantClassInfo clasS, ConstantNameAndTypeInfo nameAndType) {
            super(clasS, nameAndType);
        }
    }

    public class ConstantFieldrefInfo
    implements ConstantPoolEntry {
        public final ConstantClassInfo clasS;
        public final ConstantNameAndTypeInfo nameAndType;

        public ConstantFieldrefInfo(ConstantClassInfo clasS, ConstantNameAndTypeInfo nameAndType) {
            this.clasS = clasS;
            this.nameAndType = nameAndType;
        }

        public String toString() {
            try {
                return this.clasS.name + "::" + ConstantPool.this.signatureParser.decodeFieldDescriptor(this.nameAndType.descriptor.toString()) + " " + this.nameAndType.name;
            }
            catch (SignatureParser.SignatureException e) {
                return this.clasS.name + "::" + this.nameAndType;
            }
        }
    }

    public class ConstantClassInfo
    implements ConstantClassOrFloatOrIntegerOrStringInfo {
        public final String name;

        public ConstantClassInfo(String name) {
            this.name = name;
        }

        public String toString() {
            try {
                return ConstantPool.this.signatureParser.decodeClassNameOrFieldDescriptor(this.name).toString();
            }
            catch (SignatureParser.SignatureException e) {
                return this.name;
            }
        }
    }

    public static interface ConstantPoolEntry {
    }
}

