/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.logging.handler;

import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.expression.EvaluationException;
import de.unkrig.commons.text.parser.ParseException;
import de.unkrig.commons.util.logging.LogUtil;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

public abstract class AbstractStreamHandler
extends StreamHandler {
    public static final Level DEFAULT_LEVEL = Level.INFO;
    public static final boolean DEFAULT_AUTO_FLUSH = true;
    @Nullable
    public static final Filter DEFAULT_FILTER = null;
    public static final SimpleFormatter DEFAULT_FORMATTER = new SimpleFormatter();
    @Nullable
    public static final String DEFAULT_ENCODING = null;
    private boolean autoFlush;

    public AbstractStreamHandler() throws ParseException, EvaluationException {
        this(null);
    }

    public AbstractStreamHandler(@Nullable String propertyNamePrefix) throws ParseException, EvaluationException {
        if (propertyNamePrefix == null) {
            propertyNamePrefix = this.getClass().getName();
        }
        try {
            this.init(LogUtil.getLoggingProperty(String.valueOf(propertyNamePrefix) + ".autoFlush", true), LogUtil.getLoggingProperty(String.valueOf(propertyNamePrefix) + ".level", DEFAULT_LEVEL), LogUtil.getLoggingProperty(String.valueOf(propertyNamePrefix) + ".filter", Filter.class), LogUtil.getLoggingProperty(String.valueOf(propertyNamePrefix) + ".formatter", Formatter.class, DEFAULT_FORMATTER), LogUtil.getLoggingProperty(String.valueOf(propertyNamePrefix) + ".encoding"));
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            throw pe;
        }
        catch (EvaluationException ee) {
            ee.printStackTrace();
            throw ee;
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            throw re;
        }
    }

    public AbstractStreamHandler(boolean autoFlush, Level level, @Nullable Filter filter, Formatter formatter, @Nullable String encoding) {
        this.init(autoFlush, level, filter, formatter, encoding);
    }

    @Override
    public synchronized void publish(@Nullable LogRecord record) {
        super.publish(record);
        if (this.autoFlush) {
            this.flush();
        }
    }

    private void init(boolean autoFlush, Level level, @Nullable Filter filter, @Nullable Formatter formatter, @Nullable String encoding) {
        this.autoFlush = autoFlush;
        this.setLevel(level);
        this.setFilter(filter);
        this.setFormatter(formatter);
        try {
            this.setEncoding(encoding);
        }
        catch (Exception e) {
            try {
                this.setEncoding(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

