/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.collections;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.util.collections.Peekerator;
import java.util.Iterator;
import java.util.ListIterator;

public final class Peekerators {
    static {
        AssertionUtil.enableAssertionsForThisClass();
    }

    private Peekerators() {
    }

    public static <E> Peekerator<E> from(final Iterator<E> delegate) {
        return new Peekerator<E>(){
            boolean readAhead;
            @Nullable
            E buffer;

            @Override
            public boolean hasNext() {
                return this.readAhead || delegate.hasNext();
            }

            @Override
            @Nullable
            public E next() {
                if (this.readAhead) {
                    this.readAhead = false;
                    return this.buffer;
                }
                return delegate.next();
            }

            @Override
            public void remove() {
                delegate.remove();
            }

            @Override
            @Nullable
            public E peek() {
                if (this.readAhead) {
                    return this.buffer;
                }
                this.buffer = delegate.next();
                this.readAhead = true;
                return this.buffer;
            }
        };
    }

    public static <E> Peekerator<E> from(final ListIterator<E> delegate) {
        return new Peekerator<E>(){

            @Override
            public boolean hasNext() {
                return delegate.hasNext();
            }

            @Override
            @Nullable
            public E next() {
                return delegate.next();
            }

            @Override
            public void remove() {
                delegate.remove();
            }

            @Override
            @Nullable
            public E peek() {
                Object result = delegate.next();
                delegate.previous();
                return result;
            }
        };
    }
}

