/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.collections;

import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class LinearMap<K, V>
extends AbstractMap<K, V> {
    private Object[] keys;
    private Object[] values;
    private int size;
    @Nullable
    private Set<Map.Entry<K, V>> entrySet;

    public LinearMap() {
        this.keys = new Object[4];
        this.values = new Object[4];
    }

    public LinearMap(int initialCapacity) {
        this.keys = new Object[initialCapacity];
        this.values = new Object[initialCapacity];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        int i = this.size - 1;
        while (i >= 0) {
            if (this.keysEqual(this.keys[i], key)) {
                return true;
            }
            --i;
        }
        return false;
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        int i = this.size - 1;
        while (i >= 0) {
            if (this.valuesEqual(this.values[i], value)) {
                return true;
            }
            --i;
        }
        return false;
    }

    @Override
    @Nullable
    public V get(@Nullable Object key) {
        int i = this.size - 1;
        while (i >= 0) {
            if (this.keysEqual(this.keys[i], key)) {
                return (V)this.values[i];
            }
            --i;
        }
        return null;
    }

    @Override
    @Nullable
    public V put(@Nullable K key, @Nullable V value) {
        int i = this.size - 1;
        while (i >= 0) {
            if (this.keysEqual(this.keys[i], key)) {
                Object oldValue = this.values[i];
                this.values[i] = value;
                return (V)oldValue;
            }
            --i;
        }
        int n = this.size;
        if (n == this.keys.length) {
            Object[] tmpKeys = new Object[n << 1];
            System.arraycopy(this.keys, 0, tmpKeys, 0, n);
            this.keys = tmpKeys;
            Object[] tmpValues = new Object[n << 1];
            System.arraycopy(this.values, 0, tmpValues, 0, n);
            this.values = tmpValues;
        }
        this.keys[n] = key;
        this.values[n] = value;
        this.size = n + 1;
        return null;
    }

    @Override
    @Nullable
    public V remove(@Nullable Object key) {
        int i = this.size - 1;
        while (i >= 0) {
            if (this.keysEqual(this.keys[i], key)) {
                Object result = this.values[i];
                int n = this.size - 1;
                while (i < n) {
                    this.keys[i] = this.keys[i + 1];
                    this.values[i] = this.values[i + 1];
                    ++i;
                }
                this.keys[n] = null;
                this.values[n] = null;
                this.size = n;
                return (V)result;
            }
            --i;
        }
        return null;
    }

    @Override
    public void clear() {
        int i = this.size - 1;
        while (i >= 0) {
            this.keys[i] = null;
            this.values[i] = null;
            --i;
        }
        this.size = 0;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        if (es == null) {
            this.entrySet = es = new EntrySet();
        }
        return es;
    }

    protected boolean keysEqual(@Nullable Object key1, @Nullable Object key2) {
        return key1 == null ? key2 == null : key1.equals(key2);
    }

    protected boolean valuesEqual(@Nullable Object value1, @Nullable Object value2) {
        return value1 == null ? value2 == null : value1.equals(value2);
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public int size() {
            return LinearMap.this.size;
        }

        @Override
        public boolean isEmpty() {
            return LinearMap.this.size == 0;
        }

        @Override
        public boolean contains(@Nullable Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            int i = LinearMap.this.size - 1;
            while (i >= 0) {
                if (LinearMap.this.keysEqual(LinearMap.this.keys[i], entry.getKey()) && LinearMap.this.valuesEqual(LinearMap.this.values[i], entry.getValue())) {
                    return true;
                }
                --i;
            }
            return false;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                private int pos;
                {
                    this.pos = LinearMap.this.size;
                }

                @Override
                public boolean hasNext() {
                    return this.pos > 0;
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (this.pos == 0) {
                        throw new NoSuchElementException();
                    }
                    return EntrySet.this.newEntry(--this.pos);
                }

                @Override
                public void remove() {
                    if (this.pos == LinearMap.this.size) {
                        throw new IllegalStateException();
                    }
                    int n = LinearMap.this.size - 1;
                    int i = this.pos;
                    while (i < n) {
                        ((LinearMap)((EntrySet)EntrySet.this).LinearMap.this).keys[i] = LinearMap.this.keys[i + 1];
                        ((LinearMap)((EntrySet)EntrySet.this).LinearMap.this).values[i] = LinearMap.this.values[i + 1];
                        ++i;
                    }
                    ((LinearMap)((EntrySet)EntrySet.this).LinearMap.this).keys[n] = null;
                    ((LinearMap)((EntrySet)EntrySet.this).LinearMap.this).values[n] = null;
                    LinearMap.this.size = n;
                }
            };
        }

        @Override
        public Object[] toArray() {
            int n = LinearMap.this.size;
            Object[] result = new Object[n];
            int i = n - 1;
            while (i >= 0) {
                result[i] = this.newEntry(i);
                --i;
            }
            return result;
        }

        @Override
        @NotNullByDefault(value=false)
        public <T> T[] toArray(T[] result) {
            int n = LinearMap.this.size;
            if (result.length < n) {
                result = (Object[])Array.newInstance(result.getClass().getComponentType(), n);
            }
            int i = n - 1;
            while (i >= 0) {
                result[i] = this.newEntry(i);
                --i;
            }
            return result;
        }

        @Override
        @NotNullByDefault(value=false)
        public boolean add(Map.Entry<K, V> entry) {
            return LinearMap.this.put(entry.getKey(), entry.getValue()) != null;
        }

        @Override
        @NotNullByDefault(value=false)
        public boolean remove(Object key) {
            return LinearMap.this.remove(key) != null;
        }

        @Override
        public void clear() {
            LinearMap.this.clear();
        }

        private Map.Entry<K, V> newEntry(final int idx) {
            return new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return LinearMap.this.keys[idx];
                }

                @Override
                public V getValue() {
                    return LinearMap.this.values[idx];
                }

                @Override
                @NotNullByDefault(value=false)
                public V setValue(Object newValue) {
                    Object result = LinearMap.this.values[idx];
                    ((LinearMap)((EntrySet)EntrySet.this).LinearMap.this).values[idx] = newValue;
                    return result;
                }

                public String toString() {
                    return LinearMap.this.keys[idx] + "=" + LinearMap.this.values[idx];
                }
            };
        }
    }
}

