/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.collections;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.util.collections.IteratorUtil;
import de.unkrig.commons.util.collections.MapUtil;
import de.unkrig.commons.util.collections.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;

public final class CollectionUtil {
    @Deprecated
    public static final SortedMap EMPTY_SORTED_MAP;
    @Deprecated
    public static final SortedSet EMPTY_SORTED_SET;
    @Deprecated
    public static final Iterator AT_END;

    static {
        AssertionUtil.enableAssertionsForThisClass();
        EMPTY_SORTED_MAP = MapUtil.EMPTY_SORTED_MAP;
        EMPTY_SORTED_SET = Sets.EMPTY_SORTED_SET;
        AT_END = IteratorUtil.AT_END;
    }

    private CollectionUtil() {
    }

    @Nullable
    public static <T> T removeFirstFrom(Collection<T> subject) {
        Iterator<T> it = subject.iterator();
        if (!it.hasNext()) {
            return null;
        }
        T result = it.next();
        it.remove();
        return result;
    }

    @Deprecated
    public static <K, V> Map<K, V> map(Object ... keyValuePairs) {
        return MapUtil.map(keyValuePairs);
    }

    @Deprecated
    public static <K, V> Map<K, V> map(K[] keys, V[] values) {
        return MapUtil.map(keys, values);
    }

    @Deprecated
    public static <K, V> HashMap<K, V> hashMapOf(Map.Entry<K, V> ... entries) {
        return MapUtil.hashMapOf(entries);
    }

    @Deprecated
    public static <K, V> HashMap<K, V> hashMapOf(int initialCapacity, Map.Entry<K, V> ... entries) {
        return MapUtil.hashMapOf(initialCapacity, entries);
    }

    @Deprecated
    public static <K, V> TreeMap<K, V> treeMapOf(Map.Entry<K, V> ... entries) {
        return MapUtil.treeMapOf(entries);
    }

    @Deprecated
    public static <K, V, M extends Map<K, V>> M putAll(M subject, Map.Entry<K, V> ... entries) {
        return MapUtil.putAll(subject, entries);
    }

    @Deprecated
    public static <K, V, M extends Map<K, V>> M putAll(M subject, boolean allowDuplicateKeys, Map.Entry<K, V> ... entries) {
        return MapUtil.putAll(subject, allowDuplicateKeys, entries);
    }

    @Deprecated
    public static <K, V> Map.Entry<K, V> entry(K key, V initialValue) {
        return MapUtil.entry(key, initialValue);
    }

    @Deprecated
    public static <K, V> SortedMap<K, V> emptySortedMap() {
        return MapUtil.EMPTY_SORTED_MAP;
    }

    @Deprecated
    public static <T> SortedSet<T> emptySortedSet() {
        return Sets.emptySortedSet();
    }

    public static <T> Collection<T> sorted(Collection<T> collection) {
        Object[] a = collection.toArray();
        Arrays.sort(a);
        return Arrays.asList(a);
    }

    public static char[] toCharArray(Set<Character> charSet) {
        char[] result = new char[charSet.size()];
        int i = 0;
        for (Character c : charSet) {
            result[i++] = c.charValue();
        }
        return result;
    }

    public static int[] toIntArray(Set<Integer> intSet) {
        int[] result = new int[intSet.size()];
        int i = 0;
        for (int v : intSet) {
            result[i++] = v;
        }
        return result;
    }
}

