/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text.pattern;

import de.unkrig.commons.lang.protocol.FunctionWhichThrows;
import de.unkrig.commons.lang.protocol.TransformerWhichThrows;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Substitutor<EX extends Throwable>
implements TransformerWhichThrows<CharSequence, CharSequence, EX> {
    public static final int DEFAULT_LOOKBEHIND_LIMIT = 10;
    private final Pattern pattern;
    private final FunctionWhichThrows<? super Matcher, ? extends CharSequence, ? extends EX> matchReplacer;
    private final int lookBehindLimit;
    StringBuilder buffer = new StringBuilder();
    int start;
    private int substitutionCount;

    public Substitutor(Pattern pattern, FunctionWhichThrows<? super Matcher, ? extends CharSequence, ? extends EX> matchReplacer) {
        this(pattern, matchReplacer, 10);
    }

    public Substitutor(Pattern pattern, FunctionWhichThrows<? super Matcher, ? extends CharSequence, ? extends EX> matchReplacer, int lookBehindLimit) {
        this.pattern = pattern;
        this.matchReplacer = matchReplacer;
        this.lookBehindLimit = lookBehindLimit;
    }

    @Override
    public CharSequence transform(CharSequence in) throws EX {
        if (in.length() == 0) {
            return this.flush();
        }
        this.buffer.append(in);
        StringBuilder result = new StringBuilder();
        Matcher m = this.pattern.matcher(this.buffer);
        m.useTransparentBounds(true);
        m.useAnchoringBounds(false);
        while (true) {
            m.region(this.start, this.buffer.length());
            if (m.lookingAt()) {
                if (m.hitEnd()) break;
                CharSequence replacement = this.matchReplacer.call(m);
                if (replacement == null) {
                    result.append(this.buffer.charAt(this.start++));
                    continue;
                }
                result.append(replacement);
                if (m.end() == m.start()) {
                    result.append(this.buffer.charAt(this.start++));
                    continue;
                }
                this.start = m.end();
                continue;
            }
            if (m.hitEnd() || this.start == this.buffer.length()) break;
            result.append(this.buffer.charAt(this.start++));
        }
        if (this.start > this.lookBehindLimit) {
            this.buffer.delete(0, this.start - this.lookBehindLimit);
            this.start = this.lookBehindLimit;
        }
        if (this.buffer.capacity() > 10 * this.buffer.length()) {
            this.buffer.trimToSize();
        }
        return result.toString();
    }

    public int substitutionCount() {
        return this.substitutionCount;
    }

    private CharSequence flush() throws EX {
        if (this.buffer.length() == 0) {
            return "";
        }
        Matcher m = this.pattern.matcher(this.buffer);
        if (!m.find(this.start)) {
            String result = this.buffer.substring(this.start);
            this.buffer.setLength(0);
            this.start = 0;
            return result;
        }
        StringBuilder result = new StringBuilder();
        do {
            CharSequence replacement;
            if ((replacement = this.matchReplacer.call(m)) != null) {
                result.append(this.buffer, this.start, m.start()).append(replacement);
                this.start = m.end();
                ++this.substitutionCount;
            }
            if (m.start() != m.end()) continue;
            if (this.start == this.buffer.length()) break;
            result.append(this.buffer.charAt(this.start++));
        } while (m.find(this.start));
        result.append(this.buffer, this.start, this.buffer.length());
        this.buffer.setLength(0);
        this.start = 0;
        return result.toString();
    }
}

