/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text.pattern;

import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.protocol.Function;
import de.unkrig.commons.lang.protocol.Mapping;
import de.unkrig.commons.lang.protocol.Mappings;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.PredicateUtil;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.expression.EvaluationException;
import de.unkrig.commons.text.expression.Expression;
import de.unkrig.commons.text.expression.ExpressionEvaluator;
import de.unkrig.commons.text.parser.ParseException;
import de.unkrig.commons.text.pattern.PatternUtil;
import java.util.regex.Matcher;

public final class ExpressionMatchReplacer {
    private ExpressionMatchReplacer() {
    }

    public static String replaceSome(Matcher matcher, String spec) throws ParseException {
        return PatternUtil.replaceSome(matcher, ExpressionMatchReplacer.parse(spec));
    }

    public static Function<Matcher, String> parse(String spec) throws ParseException {
        return ExpressionMatchReplacer.parse(spec, Mappings.none(), PredicateUtil.<String>never());
    }

    public static Function<Matcher, String> parse(String spec, Object ... variableNamesAndValues) throws ParseException {
        Mapping variables = Mappings.mapping(variableNamesAndValues);
        Predicate<String> isValidVariableName = Mappings.containsKeyPredicate(variables);
        return ExpressionMatchReplacer.parse(spec, variables, isValidVariableName);
    }

    public static Function<Matcher, String> parse(String spec, Mapping<String, ?> variables, Predicate<String> isValidVariableName) throws ParseException {
        Predicate<String> variableNamePredicate = PredicateUtil.or(isValidVariableName, PredicateUtil.equal("m"));
        Expression expression = new ExpressionEvaluator(variableNamePredicate).parse(spec);
        return ExpressionMatchReplacer.get(expression, variables);
    }

    public static Function<Matcher, String> get(Expression expression, Object ... variableNamesAndValues) {
        return ExpressionMatchReplacer.get(expression, Mappings.mapping(variableNamesAndValues));
    }

    public static Function<Matcher, String> get(final Expression expression, final Mapping<String, ?> variables) {
        return new Function<Matcher, String>(){

            @Override
            @Nullable
            public String call(@Nullable Matcher matcher) {
                assert (matcher != null);
                Mapping v2 = Mappings.augment(variables, "m", matcher);
                try {
                    return expression.evaluateTo(v2, String.class);
                }
                catch (EvaluationException e) {
                    throw ExceptionUtil.wrap("Evaluating \"" + expression + "\"", e, IllegalArgumentException.class);
                }
            }
        };
    }
}

