/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang.crypto;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.UnrecoverableKeyException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public final class SecretKeys {
    static {
        AssertionUtil.enableAssertionsForThisClass();
    }

    private SecretKeys() {
    }

    public static SecretKey adHocSecretKey(File keyStoreFile, @Nullable char[] keyStorePassword, String keyAlias, char[] keyProtectionPassword) throws GeneralSecurityException, IOException {
        boolean keystoreDirty;
        SecretKey secretKey;
        KeyStore ks = KeyStore.getInstance("JCEKS");
        if (keyStoreFile.exists()) {
            SecretKeys.loadKeyStoreFromFile(keyStoreFile, keyStorePassword, ks);
            secretKey = (SecretKey)ks.getKey(keyAlias, keyProtectionPassword);
            keystoreDirty = false;
        } else {
            ks.load(null, keyStorePassword);
            secretKey = null;
            keystoreDirty = true;
        }
        if (secretKey == null) {
            secretKey = KeyGenerator.getInstance("AES").generateKey();
            ks.setKeyEntry(keyAlias, secretKey, keyProtectionPassword, null);
            keystoreDirty = true;
        }
        if (keystoreDirty) {
            SecretKeys.saveKeyStoreToFile(ks, keyStoreFile, keyStorePassword);
        }
        return secretKey;
    }

    @Nullable
    public static SecretKey adHocSecretKey(File keyStoreFile, @Nullable char[] keyStorePassword, String keyAlias, String dialogTitle, String messageCreateKey, String messageUseExistingKey) throws GeneralSecurityException, IOException {
        boolean keystoreDirty;
        SecretKey secretKey;
        KeyStore ks = KeyStore.getInstance("JCEKS");
        if (keyStoreFile.exists()) {
            SecretKeys.loadKeyStoreFromFile(keyStoreFile, keyStorePassword, ks);
            try {
                secretKey = (SecretKey)ks.getKey(keyAlias, new char[0]);
            }
            catch (UnrecoverableKeyException uke) {
                String label1 = "<html>" + messageUseExistingKey + "<br />" + "<br />" + "If yes, then enter the correct master password:" + "</html>";
                while (true) {
                    char[] keyProtectionPassword;
                    if ((keyProtectionPassword = SecretKeys.askForPassword(dialogTitle, label1, "<html><small>If you lost the password, you can always delete the keystore file<br />\"" + keyStoreFile + "\" and start<br />" + "over with a new password." + "</small>" + "</html>")) == null) {
                        return null;
                    }
                    try {
                        secretKey = (SecretKey)ks.getKey(keyAlias, keyProtectionPassword);
                    }
                    catch (UnrecoverableKeyException uke2) {
                        label1 = "The password you entered is wrong; please try again:";
                        continue;
                    }
                    break;
                }
            }
            keystoreDirty = false;
        } else {
            ks.load(null, keyStorePassword);
            secretKey = null;
            keystoreDirty = true;
        }
        if (secretKey == null) {
            secretKey = KeyGenerator.getInstance("AES").generateKey();
            char[] keyProtectionPassword = SecretKeys.askForPassword(dialogTitle, "<html>" + messageCreateKey + "<br />" + "<br />" + "If yes, then define a password for it:" + "</html>", "<html><small>Choosing an empty or trivial master password makes it possible for an<br />attacker to compromise the stored data.</small></html>");
            if (keyProtectionPassword == null) {
                return null;
            }
            ks.setKeyEntry(keyAlias, secretKey, keyProtectionPassword, null);
            keystoreDirty = true;
        }
        if (keystoreDirty) {
            SecretKeys.saveKeyStoreToFile(ks, keyStoreFile, keyStorePassword);
        }
        return secretKey;
    }

    private static void loadKeyStoreFromFile(File keyStoreFile, @Nullable char[] keyStorePassword, KeyStore keyStore) throws FileNotFoundException, GeneralSecurityException {
        FileInputStream is = new FileInputStream(keyStoreFile);
        try {
            try {
                keyStore.load(is, keyStorePassword);
                ((InputStream)is).close();
            }
            catch (IOException ioe) {
                if (ioe.getCause() instanceof UnrecoverableKeyException) {
                    throw new AssertionError((Object)ioe);
                }
                try {
                    ((InputStream)is).close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (Exception exception) {}
        }
    }

    private static void saveKeyStoreToFile(KeyStore keyStore, File keyStoreFile, @Nullable char[] keyStorePassword) throws GeneralSecurityException, IOException {
        FileOutputStream os = new FileOutputStream(keyStoreFile);
        try {
            keyStore.store(os, keyStorePassword);
            ((OutputStream)os).close();
        }
        finally {
            try {
                ((OutputStream)os).close();
            }
            catch (Exception exception) {}
        }
    }

    @Nullable
    private static char[] askForPassword(String title, String label1, @Nullable String label2) {
        JPasswordField passwordField = new JPasswordField();
        SecretKeys.focussify(passwordField);
        Object[] objectArray = new Object[3];
        objectArray[0] = new JLabel(label1);
        objectArray[1] = passwordField;
        Object object = objectArray[2] = label2 == null ? null : new JLabel(label2);
        if (JOptionPane.showOptionDialog(null, objectArray, title, 0, 3, null, null, null) != 0) {
            return null;
        }
        return passwordField.getPassword();
    }

    private static void focussify(JComponent component) {
        try {
            if (InetAddress.getLocalHost().getHostName().endsWith("DRMF")) {
                return;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        component.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(@Nullable AncestorEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError();
                }
                JComponent component = event.getComponent();
                component.requestFocusInWindow();
                component.removeAncestorListener(this);
            }

            @Override
            public void ancestorRemoved(@Nullable AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(@Nullable AncestorEvent event) {
            }
        });
    }
}

