/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang;

import de.unkrig.commons.lang.CharSequences;
import de.unkrig.commons.lang.PrettyPrinter;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.nullanalysis.Nullable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class StringUtil {
    public static final Predicate<CharSequence> IS_BLANK = new Predicate<CharSequence>(){

        @Override
        public boolean evaluate(CharSequence subject) {
            return StringUtil.isBlank(subject);
        }
    };

    private StringUtil() {
    }

    public static String join(Collection<? extends Object> elements, String glue) {
        if (elements.size() == 0) {
            return "";
        }
        if (elements.size() == 1) {
            return String.valueOf(elements.iterator().next());
        }
        Iterator<? extends Object> it = elements.iterator();
        StringBuilder sb = new StringBuilder();
        sb.append(it.next());
        while (it.hasNext()) {
            sb.append(glue).append(it.next());
        }
        return sb.toString();
    }

    public static boolean equals(CharSequence cs1, CharSequence cs2) {
        int l2;
        int l1 = cs1.length();
        if (l1 != (l2 = cs2.length())) {
            return false;
        }
        int i = 0;
        while (i < l1) {
            if (cs1.charAt(i) != cs2.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int compareTo(CharSequence cs1, CharSequence cs2) {
        int l1 = cs1.length();
        int l2 = cs1.length();
        int n = Math.min(l1, l2);
        int i = 0;
        while (i < n) {
            int diff = cs1.charAt(i) - cs2.charAt(i);
            if (diff != 0) {
                return diff;
            }
            ++i;
        }
        return l1 - l2;
    }

    public static String repeat(int n, char c) {
        if (n <= 0) {
            return "";
        }
        char[] ca = new char[n];
        Arrays.fill(ca, c);
        return String.copyValueOf(ca);
    }

    public static String repeat(int n, char[] chars) {
        if (n == 0) {
            return "";
        }
        int len = chars.length;
        if (len == 0) {
            return "";
        }
        if (len == 1) {
            return StringUtil.repeat(n, chars[0]);
        }
        char[] ca = new char[n * len];
        int i = 0;
        int o = 0;
        while (i < n) {
            int j = 0;
            while (j < len) {
                ca[o++] = chars[j];
                ++j;
            }
            ++i;
        }
        return String.copyValueOf(ca);
    }

    public static String repeat(int n, CharSequence cs) {
        if (n <= 0) {
            return "";
        }
        if (n == 1) {
            return cs.toString();
        }
        int len = cs.length();
        char[] src = CharSequences.toCharArray(cs);
        char[] dst = new char[n * len];
        int i = 0;
        while (i < n) {
            System.arraycopy(src, 0, dst, i * len, len);
            ++i;
        }
        return String.copyValueOf(dst);
    }

    public static boolean isBlank(CharSequence cs) {
        int i = cs.length() - 1;
        while (i >= 0) {
            if (cs.charAt(i) > ' ') {
                return false;
            }
            --i;
        }
        return true;
    }

    public static String firstLetterToUpperCase(String s) {
        if (s.isEmpty() || !Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1);
    }

    public static String firstLetterToLowerCase(String s) {
        if (s.isEmpty() || !Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return String.valueOf(s.substring(0, 1).toLowerCase()) + s.substring(1);
    }

    public static Iterable<Character> asIterable(final CharSequence subject) {
        return new Iterable<Character>(){

            @Override
            public Iterator<Character> iterator() {
                return StringUtil.iterator(subject);
            }
        };
    }

    public static Iterator<Character> iterator(final CharSequence subject) {
        return new Iterator<Character>(){
            int idx;

            @Override
            public void remove() {
                throw new NoSuchElementException("remove");
            }

            @Override
            public Character next() {
                if (this.idx >= subject.length()) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                return Character.valueOf(subject.charAt(this.idx++));
            }

            @Override
            public boolean hasNext() {
                return this.idx < subject.length();
            }
        };
    }

    public static Iterator<Character> reverseIterator(final CharSequence subject) {
        return new Iterator<Character>(){
            int idx;
            {
                this.idx = charSequence.length();
            }

            @Override
            public void remove() {
                throw new NoSuchElementException("remove");
            }

            @Override
            public Character next() {
                if (this.idx <= 0) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                return Character.valueOf(subject.charAt(--this.idx));
            }

            @Override
            public boolean hasNext() {
                return this.idx > 0;
            }
        };
    }

    public static String lessTrailingLineSeparators(String s) {
        if (s.isEmpty()) {
            return "";
        }
        int i = s.length() - 1;
        char c = s.charAt(i);
        if (c != '\r' && c != '\n') {
            return s;
        }
        --i;
        while (i >= 0) {
            c = s.charAt(i);
            if (c != '\r' && c != '\n') {
                return s.substring(0, i + 1);
            }
            --i;
        }
        return "";
    }

    public static boolean containsAny(String subject, String characters) {
        int i = characters.length() - 1;
        while (i >= 0) {
            if (subject.indexOf(Character.codePointAt(characters, i)) != -1) {
                return true;
            }
            --i;
        }
        return false;
    }

    public static boolean equalsIgnoreCase(@Nullable String s1, @Nullable String s2) {
        return s1 == null ? s2 == null : s1.equalsIgnoreCase(s2);
    }

    public static IndexOf indexOf(char[] needle) {
        return StringUtil.indexOf(CharSequences.from(needle));
    }

    public static IndexOf indexOf(CharSequence needle) {
        if (needle.length() < 16) {
            return StringUtil.naiveIndexOf(needle);
        }
        return StringUtil.boyerMooreHorspoolIndexOf(needle);
    }

    public static IndexOf naiveIndexOf(final CharSequence needle) {
        final String needle2 = needle.toString();
        return new AbstractIndexOf(){
            final int needleLength;
            {
                this.needleLength = charSequence.length();
            }

            @Override
            public int indexOf(CharSequence haystack, int minIndex, int maxIndex) {
                if (maxIndex >= haystack.length() - this.needleLength) {
                    return haystack.toString().indexOf(needle2, minIndex);
                }
                return haystack.toString().substring(0, maxIndex + this.needleLength).indexOf(needle2, minIndex);
            }

            @Override
            public int indexOf(CharSequence haystack, int minIndex, int maxIndex, int limit) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int lastIndexOf(CharSequence haystack, int minIndex, int maxIndex) {
                if (minIndex <= 0) {
                    return haystack.toString().lastIndexOf(needle2, maxIndex);
                }
                int result = (haystack = haystack.subSequence(minIndex, haystack.length())).toString().lastIndexOf(needle2, maxIndex -= minIndex);
                return result == -1 ? -1 : result + minIndex;
            }

            @Override
            public String toString() {
                return "naive(" + PrettyPrinter.toJavaStringLiteral(needle) + ")";
            }
        };
    }

    public static IndexOf boyerMooreHorspoolIndexOf(final CharSequence needle) {
        return new AbstractIndexOf(){
            final int needleLength;
            final int[] safeSkip1;
            final int[] safeSkip2;
            {
                this.needleLength = charSequence.length();
                this.safeSkip1 = new int[256];
                this.safeSkip2 = new int[256];
                Arrays.fill(this.safeSkip1, this.needleLength);
                Arrays.fill(this.safeSkip2, this.needleLength);
                int nl1 = this.needleLength - 1;
                int i = 0;
                while (i < this.needleLength) {
                    int ss2;
                    int ss = nl1 - i;
                    this.safeSkip1[0xFF & charSequence.charAt((int)i)] = ss2 = ss == 0 ? 1 : ss;
                    this.safeSkip2[0xFF & charSequence.charAt((int)ss)] = ss2;
                    ++i;
                }
            }

            @Override
            public int indexOf(CharSequence haystack, int minIndex, int maxIndex) {
                int nl1 = this.needleLength - 1;
                char lastChar = needle.charAt(nl1);
                int limit = maxIndex >= haystack.length() - nl1 ? haystack.length() - 1 : maxIndex + nl1;
                int o = minIndex <= 0 ? nl1 : minIndex + nl1;
                while (o <= limit) {
                    char c = haystack.charAt(o);
                    if (c != lastChar) {
                        o += this.safeSkip1[0xFF & c];
                        continue;
                    }
                    if (nl1 == 0) {
                        return o;
                    }
                    int o2 = o - 1;
                    int ni = nl1 - 1;
                    while (haystack.charAt(o2) == needle.charAt(ni)) {
                        if (ni == 0) {
                            return o2;
                        }
                        --ni;
                        --o2;
                    }
                    ++o;
                }
                return -1;
            }

            @Override
            public int indexOf(CharSequence haystack, int minIndex, int maxIndex, int limit) {
                if (maxIndex <= limit - this.needleLength) {
                    return this.indexOf(haystack, minIndex, maxIndex);
                }
                int result = this.indexOf(haystack, minIndex, limit - this.needleLength);
                if (result != -1) {
                    return result;
                }
                int nl1 = this.needleLength - 1;
                int minResult = Integer.MIN_VALUE;
                int maxResult = Integer.MAX_VALUE;
                int o = limit - 1;
                while (o > limit - this.needleLength) {
                    int maxOffset;
                    char c = haystack.charAt(o);
                    int ss1 = this.safeSkip1[0xFF & c];
                    if (ss1 == this.needleLength) {
                        return -1;
                    }
                    int minOffset = o + ss1 - nl1;
                    if (minOffset > minResult) {
                        minResult = minOffset;
                    }
                    if (c == needle.charAt(0)) {
                        maxOffset = o;
                    } else {
                        int ss2 = this.safeSkip2[0xFF & c];
                        maxOffset = o - ss2;
                    }
                    if (maxOffset < maxResult) {
                        maxResult = maxOffset;
                    }
                    if (maxResult == minResult) break;
                    --o;
                }
                if (minResult < minIndex) {
                    minResult = minIndex;
                }
                if (maxResult > maxIndex) {
                    maxResult = maxIndex;
                }
                int i = minResult;
                while (i <= maxResult) {
                    block14: {
                        int j = 0;
                        int i2 = i;
                        while (j < needle.length()) {
                            if (i2 == limit) {
                                return i;
                            }
                            if (needle.charAt(j) == haystack.charAt(i2)) {
                                ++j;
                                ++i2;
                                continue;
                            }
                            break block14;
                        }
                        return i;
                    }
                    ++i;
                }
                return -1;
            }

            @Override
            public int lastIndexOf(CharSequence haystack, int minIndex, int maxIndex) {
                int nl = this.needleLength;
                char firstChar = needle.charAt(0);
                int limit = haystack.length() - nl;
                int o = maxIndex <= limit ? maxIndex : limit;
                while (o >= minIndex) {
                    char c = haystack.charAt(o);
                    if (c != firstChar) {
                        o -= this.safeSkip2[0xFF & c];
                        continue;
                    }
                    if (nl == 1) {
                        return o;
                    }
                    int o2 = o + 1;
                    int ii = 1;
                    while (true) {
                        if (ii >= nl) {
                            return o;
                        }
                        if (haystack.charAt(o2) != needle.charAt(ii)) break;
                        ++ii;
                        ++o2;
                    }
                    --o;
                }
                return -1;
            }

            @Override
            public String toString() {
                return "boyerMooreHorspool(" + PrettyPrinter.toJavaStringLiteral(needle) + ")";
            }
        };
    }

    public static IndexOf indexOf(char[][] needle) {
        int len;
        block2: {
            len = needle.length;
            char[] univalentNeedle = new char[len];
            int i = 0;
            while (i < len) {
                if (needle[i].length == 1) {
                    univalentNeedle[i] = needle[i][0];
                    ++i;
                    continue;
                }
                break block2;
            }
            return StringUtil.indexOf(univalentNeedle);
        }
        return len < 3 ? StringUtil.naiveIndexOf(needle) : StringUtil.boyerMooreHorspoolIndexOf(needle);
    }

    private static IndexOf naiveIndexOf(final char[][] needle) {
        return new AbstractIndexOf(){

            @Override
            public int indexOf(CharSequence haystack, int minIndex, int maxIndex) {
                if (minIndex < 0) {
                    minIndex = 0;
                }
                if (maxIndex > haystack.length() - needle.length) {
                    maxIndex = haystack.length() - needle.length;
                }
                while (minIndex <= maxIndex) {
                    block6: {
                        int o = minIndex;
                        char[][] cArray = needle;
                        int n = needle.length;
                        int n2 = 0;
                        block1: while (n2 < n) {
                            char[] n3 = cArray[n2];
                            char c = haystack.charAt(o++);
                            char[] cArray2 = n3;
                            int n4 = n3.length;
                            int n5 = 0;
                            while (n5 < n4) {
                                char nc = cArray2[n5];
                                if (c != nc) {
                                    ++n5;
                                    continue;
                                }
                                ++n2;
                                continue block1;
                            }
                            break block6;
                        }
                        return minIndex;
                    }
                    ++minIndex;
                }
                return -1;
            }

            @Override
            public int indexOf(CharSequence haystack, int minIndex, int maxIndex, int limit) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int lastIndexOf(CharSequence haystack, int minIndex, int maxIndex) {
                if (minIndex < 0) {
                    minIndex = 0;
                }
                if (maxIndex > haystack.length() - needle.length) {
                    maxIndex = haystack.length() - needle.length;
                }
                while (maxIndex >= minIndex) {
                    block6: {
                        int o = maxIndex;
                        char[][] cArray = needle;
                        int n = needle.length;
                        int n2 = 0;
                        block1: while (n2 < n) {
                            char[] n3 = cArray[n2];
                            char c = haystack.charAt(o++);
                            char[] cArray2 = n3;
                            int n4 = n3.length;
                            int n5 = 0;
                            while (n5 < n4) {
                                char nc = cArray2[n5];
                                if (c != nc) {
                                    ++n5;
                                    continue;
                                }
                                ++n2;
                                continue block1;
                            }
                            break block6;
                        }
                        return maxIndex;
                    }
                    ++maxIndex;
                }
                return -1;
            }

            @Override
            public String toString() {
                return "naiveIndexOf(" + PrettyPrinter.toJavaArrayInitializer(needle) + ")";
            }
        };
    }

    public static IndexOf boyerMooreHorspoolIndexOf(final char[][] needle) {
        boolean univalent = true;
        int i = needle.length - 1;
        while (i >= 0) {
            char[] n = StringUtil.removeDuplicates(needle[i]);
            if (n.length != 1) {
                univalent = false;
            }
            needle[i] = n;
            --i;
        }
        if (univalent) {
            return StringUtil.boyerMooreHorspoolIndexOf(StringUtil.mirror(needle));
        }
        return new AbstractIndexOf(){
            final int needleLength;
            final int[] safeSkip1;
            final int[] safeSkip2;
            {
                char c;
                int n;
                int n2;
                char[] cArray2;
                this.needleLength = cArray.length;
                this.safeSkip1 = new int[256];
                this.safeSkip2 = new int[256];
                Arrays.fill(this.safeSkip1, this.needleLength);
                Arrays.fill(this.safeSkip2, this.needleLength);
                int nl1 = this.needleLength - 1;
                int i = 0;
                while (i < this.needleLength) {
                    cArray2 = cArray[i];
                    n2 = cArray2.length;
                    n = 0;
                    while (n < n2) {
                        c = cArray2[n];
                        this.safeSkip1[0xFF & c] = nl1 - i;
                        ++n;
                    }
                    ++i;
                }
                i = nl1;
                while (i >= 0) {
                    cArray2 = cArray[i];
                    n2 = cArray2.length;
                    n = 0;
                    while (n < n2) {
                        c = cArray2[n];
                        this.safeSkip2[0xFF & c] = i;
                        ++n;
                    }
                    --i;
                }
            }

            @Override
            public int indexOf(CharSequence haystack, int minIndex, int maxIndex) {
                int nl1 = this.needleLength - 1;
                char[] lastChars = needle[nl1];
                int limit = maxIndex >= haystack.length() - nl1 ? haystack.length() - 1 : maxIndex + nl1;
                int o = minIndex <= 0 ? nl1 : minIndex + nl1;
                block5: while (o <= limit) {
                    char c = haystack.charAt(o);
                    block0 : switch (lastChars.length) {
                        case 1: {
                            if (c == lastChars[0]) break;
                            o += this.safeSkip1[0xFF & c];
                            continue block5;
                        }
                        case 2: {
                            if (c == lastChars[0] || c == lastChars[1]) break;
                            o += this.safeSkip1[0xFF & c];
                            continue block5;
                        }
                        case 3: {
                            if (c == lastChars[0] || c == lastChars[1] || c == lastChars[2]) break;
                            o += this.safeSkip1[0xFF & c];
                            continue block5;
                        }
                        default: {
                            char[] cArray = lastChars;
                            int n = lastChars.length;
                            int n2 = 0;
                            while (n2 < n) {
                                char lc = cArray[n2];
                                if (lc == c) break block0;
                                ++n2;
                            }
                            o += this.safeSkip1[0xFF & c];
                            continue block5;
                        }
                    }
                    if (nl1 == 0) {
                        return o;
                    }
                    int o2 = o - 1;
                    int ni = nl1 - 1;
                    block7: while (true) {
                        c = haystack.charAt(o2);
                        char[] cArray = needle[ni];
                        int n = cArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            char nc = cArray[n3];
                            if (c != nc) {
                                ++n3;
                                continue;
                            }
                            if (ni == 0) {
                                return o2;
                            }
                            --ni;
                            --o2;
                            continue block7;
                        }
                        break;
                    }
                    ++o;
                }
                return -1;
            }

            @Override
            public int indexOf(CharSequence haystack, int minIndex, int maxIndex, int limit) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int lastIndexOf(CharSequence haystack, int minIndex, int maxIndex) {
                int nl = this.needleLength;
                char[] firstChars = needle[0];
                int limit = haystack.length() - nl;
                int o = maxIndex <= limit ? maxIndex : limit;
                block5: while (o >= minIndex) {
                    char c = haystack.charAt(o);
                    block0 : switch (firstChars.length) {
                        case 1: {
                            if (c == firstChars[0]) break;
                            o += this.safeSkip2[0xFF & c];
                            continue block5;
                        }
                        case 2: {
                            if (c == firstChars[0] || c == firstChars[1]) break;
                            o += this.safeSkip2[0xFF & c];
                            continue block5;
                        }
                        case 3: {
                            if (c == firstChars[0] || c == firstChars[1] || c == firstChars[2]) break;
                            o += this.safeSkip2[0xFF & c];
                            continue block5;
                        }
                        default: {
                            char[] cArray = firstChars;
                            int n = firstChars.length;
                            int n2 = 0;
                            while (n2 < n) {
                                char fc = cArray[n2];
                                if (fc == c) break block0;
                                ++n2;
                            }
                            o += this.safeSkip2[0xFF & c];
                            continue block5;
                        }
                    }
                    if (nl == 1) {
                        return o;
                    }
                    int o2 = o + 1;
                    int ni = 1;
                    block7: while (true) {
                        if (ni >= nl) {
                            return o;
                        }
                        c = haystack.charAt(o2);
                        char[] cArray = needle[ni];
                        int n = cArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            char nc = cArray[n3];
                            if (c != nc) {
                                ++n3;
                                continue;
                            }
                            ++ni;
                            ++o2;
                            continue block7;
                        }
                        break;
                    }
                    --o;
                }
                return -1;
            }

            @Override
            public String toString() {
                return "boyerMooreHorspool(" + PrettyPrinter.toJavaArrayInitializer(needle) + ")";
            }
        };
    }

    private static char[][] mirror(char[][] subject) {
        int height = subject.length;
        if (height == 0) {
            return new char[0][];
        }
        int width = subject[0].length;
        char[][] result = new char[width][];
        result[0] = new char[height];
        int j = 0;
        while (j < height) {
            if (subject[j].length != width) {
                throw new IllegalArgumentException();
            }
            result[0][j] = subject[j][0];
            ++j;
        }
        int i = 1;
        while (i < width) {
            result[i] = new char[height];
            int j2 = 0;
            while (j2 < height) {
                result[i][j2] = subject[j2][i];
                ++j2;
            }
            ++i;
        }
        return result;
    }

    private static char[] removeDuplicates(char[] subject) {
        int j = subject.length - 1;
        while (j >= 0) {
            int k = j - 1;
            while (k >= 0) {
                if (subject[k] == subject[j]) {
                    char[] tmp = new char[subject.length - 1];
                    System.arraycopy(subject, 0, tmp, 0, k);
                    System.arraycopy(subject, k + 1, tmp, k, subject.length - 1 - k);
                    --j;
                    --k;
                    subject = tmp;
                }
                --k;
            }
            --j;
        }
        return subject;
    }

    public static abstract class AbstractIndexOf
    implements IndexOf {
        @Override
        public int indexOf(CharSequence haystack) {
            return this.indexOf(haystack, 0, Integer.MAX_VALUE);
        }

        @Override
        public int indexOf(CharSequence haystack, int minIndex) {
            return this.indexOf(haystack, minIndex, Integer.MAX_VALUE);
        }

        @Override
        public int lastIndexOf(CharSequence haystack) {
            return this.lastIndexOf(haystack, 0, Integer.MAX_VALUE);
        }

        @Override
        public int lastIndexOf(CharSequence haystack, int maxIndex) {
            return this.lastIndexOf(haystack, 0, maxIndex);
        }

        @Override
        public int indexOf(CharSequence haystack, int minIndex, int maxIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(CharSequence haystack, int minIndex, int maxIndex, int limit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int lastIndexOf(CharSequence haystack, int minIndex, int maxIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public abstract String toString();
    }

    public static interface IndexOf {
        public int indexOf(CharSequence var1);

        public int indexOf(CharSequence var1, int var2);

        public int indexOf(CharSequence var1, int var2, int var3);

        public int indexOf(CharSequence var1, int var2, int var3, int var4);

        public int lastIndexOf(CharSequence var1);

        public int lastIndexOf(CharSequence var1, int var2);

        public int lastIndexOf(CharSequence var1, int var2, int var3);

        public String toString();
    }
}

