/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.junit4;

import de.unkrig.commons.nullanalysis.Nullable;
import java.util.List;
import org.junit.Assert;

public final class AssertString {
    private AssertString() {
    }

    public static void assertContains(String expectedInfix, String actual) {
        AssertString.assertContains(null, expectedInfix, actual);
    }

    public static void assertContains(@Nullable String message, String expectedInfix, String actual) {
        if (!actual.contains(expectedInfix)) {
            Assert.fail((String)(String.valueOf(message == null ? "[" : String.valueOf(message) + ": [") + actual + "] is not contained in [" + expectedInfix + "]"));
        }
    }

    public static void assertContains(List<String> expectedInfixes, List<String> actuals) {
        AssertString.assertContains(null, expectedInfixes, actuals);
    }

    public static void assertContains(@Nullable String message, List<String> expectedInfixes, List<String> actuals) {
        int i = 0;
        while (i < expectedInfixes.size() && i < actuals.size()) {
            String expectedInfix = expectedInfixes.get(i);
            String actual = actuals.get(i);
            AssertString.assertContains(String.valueOf(message == null ? "Element " : String.valueOf(message) + ": Element ") + i, expectedInfix, actual);
            ++i;
        }
        if (expectedInfixes.size() != actuals.size()) {
            Assert.fail((String)(String.valueOf(message == null ? "Expected " : String.valueOf(message) + ": Expected ") + expectedInfixes.size() + " strings, but got " + actuals.size()));
        }
    }
}

