/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.protocol.Consumer;
import de.unkrig.commons.lang.protocol.ConsumerUtil;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.Producer;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public final class OutputStreams {
    public static final OutputStream DISCARD = new OutputStream(){

        @Override
        public void write(@Nullable byte[] b, int off, int len) {
        }

        @Override
        public void write(int b) {
        }
    };
    private static final long[] THRESHOLDS = new long[126];

    static {
        long x = 2L;
        int i = 0;
        while (i < THRESHOLDS.length) {
            OutputStreams.THRESHOLDS[i++] = x;
            OutputStreams.THRESHOLDS[i++] = x + (x >> 1);
            x <<= 1;
        }
    }

    private OutputStreams() {
    }

    @NotNullByDefault(value=false)
    public static OutputStream tee(final OutputStream ... delegates) {
        return new OutputStream(){

            @Override
            public void close() throws IOException {
                IOException caughtIOException = null;
                OutputStream[] outputStreamArray = delegates;
                int n = delegates.length;
                int n2 = 0;
                while (n2 < n) {
                    OutputStream delegate = outputStreamArray[n2];
                    try {
                        delegate.close();
                    }
                    catch (IOException ioe) {
                        caughtIOException = ioe;
                    }
                    ++n2;
                }
                if (caughtIOException != null) {
                    throw caughtIOException;
                }
            }

            @Override
            public void flush() throws IOException {
                OutputStream[] outputStreamArray = delegates;
                int n = delegates.length;
                int n2 = 0;
                while (n2 < n) {
                    OutputStream delegate = outputStreamArray[n2];
                    delegate.flush();
                    ++n2;
                }
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                OutputStream[] outputStreamArray = delegates;
                int n = delegates.length;
                int n2 = 0;
                while (n2 < n) {
                    OutputStream delegate = outputStreamArray[n2];
                    delegate.write(b, off, len);
                    ++n2;
                }
            }

            @Override
            public void write(int b) throws IOException {
                OutputStream[] outputStreamArray = delegates;
                int n = delegates.length;
                int n2 = 0;
                while (n2 < n) {
                    OutputStream delegate = outputStreamArray[n2];
                    delegate.write(b);
                    ++n2;
                }
            }
        };
    }

    public static long writeAndCount(ConsumerWhichThrows<? super OutputStream, ? extends IOException> writeContents, OutputStream outputStream) throws IOException {
        ConsumerUtil.Produmer count = ConsumerUtil.store();
        writeContents.consume(OutputStreams.tee(outputStream, OutputStreams.lengthWritten(ConsumerUtil.cumulate(count, 0L))));
        Long result = (Long)count.produce();
        return result == null ? 0L : result;
    }

    public static OutputStream split(final ProducerWhichThrows<? extends OutputStream, ? extends IOException> delegates, final Producer<? extends Long> byteCountLimits) throws IOException {
        return new OutputStream(){
            private OutputStream delegate;
            private long delegateByteCount;
            {
                this.delegate = AssertionUtil.notNull((OutputStream)producerWhichThrows.produce(), "'delegates' produced <null>");
                this.delegateByteCount = AssertionUtil.notNull((Long)producer.produce(), "'byteCountLimits' produced <null>");
            }

            @Override
            public void write(int b) throws IOException {
                this.write(new byte[]{(byte)b}, 0, 1);
            }

            @Override
            public synchronized void write(@Nullable byte[] b, int off, int len) throws IOException {
                while ((long)len > this.delegateByteCount) {
                    this.delegate.write(b, off, (int)this.delegateByteCount);
                    this.delegate.close();
                    off = (int)((long)off + this.delegateByteCount);
                    len = (int)((long)len - this.delegateByteCount);
                    this.delegate = AssertionUtil.notNull((OutputStream)delegates.produce(), "'delegates' produced <null>");
                    this.delegateByteCount = AssertionUtil.notNull((Long)byteCountLimits.produce(), "'byteCountLimits' produced <null>");
                }
                this.delegate.write(b, off, len);
                this.delegateByteCount -= (long)len;
            }

            @Override
            public void flush() throws IOException {
                this.delegate.flush();
            }

            @Override
            public void close() throws IOException {
                this.delegate.close();
            }
        };
    }

    @Deprecated
    public static OutputStream unclosableOutputStream(OutputStream delegate) {
        return OutputStreams.unclosable(delegate);
    }

    public static OutputStream unclosable(OutputStream delegate) {
        return new FilterOutputStream(delegate){

            @Override
            public void close() {
            }

            @Override
            public void write(@Nullable byte[] b, int off, int len) throws IOException {
                this.out.write(b, off, len);
            }
        };
    }

    public static void fill(OutputStream outputStream, byte b, long count) throws IOException {
        byte[] ba;
        if (count > 8192L) {
            ba = new byte[8192];
            if (b != 0) {
                Arrays.fill(ba, b);
            }
            do {
                outputStream.write(ba);
            } while ((count -= 8192L) > 8192L);
        }
        ba = new byte[(int)count];
        Arrays.fill(ba, b);
        outputStream.write(ba);
    }

    public static OutputStream byteConsumerOutputStream(final ConsumerWhichThrows<? super Byte, ? extends IOException> delegate) {
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                delegate.consume((byte)b);
            }
        };
    }

    public static OutputStream[] compareOutput(final int n, Runnable whenIdentical, Runnable whenNotIdentical) {
        abstract class ChecksumOutputStream
        extends OutputStream {
            private final Checksum checksum = new CRC32();
            private long count;
            protected final long[] checksums = new long[OutputStreams.access$0().length];
            protected int idx;
            private boolean closed;

            ChecksumOutputStream() {
            }

            @Override
            public void write(int b) throws IOException {
                if (this.closed) {
                    throw new IOException("Stream is closed");
                }
                if (this.count == THRESHOLDS[this.idx]) {
                    this.pushChecksum();
                }
                this.checksum.update(b);
                ++this.count;
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public void write(@Nullable byte[] b, int off, int len) throws IOException {
                if (!OutputStreams.$assertionsDisabled && b == null) {
                    throw new AssertionError();
                }
                if (!this.closed) ** GOTO lbl11
                throw new IOException("Stream is closed");
lbl-1000:
                // 1 sources

                {
                    part = (int)Math.min(0x7FFFFFFFL, OutputStreams.access$0()[this.idx] - this.count);
                    this.checksum.update(b, off, part);
                    this.count = OutputStreams.access$0()[this.idx];
                    this.pushChecksum();
                    off += part;
                    len -= part;
lbl11:
                    // 2 sources

                    ** while (this.count + (long)len > OutputStreams.access$0()[this.idx])
                }
lbl12:
                // 1 sources

                this.checksum.update(b, off, len);
                this.count += (long)len;
            }

            private void pushChecksum() {
                this.checksums[this.idx] = this.checksum.getValue();
                this.checksumWasPushed(this.idx);
                ++this.idx;
            }

            abstract void checksumWasPushed(int var1);

            @Override
            public void close() {
                if (this.closed) {
                    return;
                }
                this.pushChecksum();
                this.closed = true;
                this.wasClosed();
            }

            abstract void wasClosed();
        }
        OutputStream[] result = new ChecksumOutputStream[n];
        int i = 0;
        while (i < n) {
            result[i] = new ChecksumOutputStream((ChecksumOutputStream[])result, whenNotIdentical, whenIdentical){
                private final /* synthetic */ ChecksumOutputStream[] val$result;
                private final /* synthetic */ Runnable val$whenNotIdentical;
                private final /* synthetic */ Runnable val$whenIdentical;
                {
                    this.val$result = checksumOutputStreamArray;
                    this.val$whenNotIdentical = runnable;
                    this.val$whenIdentical = runnable2;
                }

                @Override
                void checksumWasPushed(int idx) {
                    int i = 0;
                    while (i < n) {
                        if (this.val$result[i].idx == idx + 1 && this.val$result[i].checksums[idx] != this.checksums[idx]) {
                            this.val$whenNotIdentical.run();
                            return;
                        }
                        ++i;
                    }
                }

                @Override
                void wasClosed() {
                    int i = 0;
                    while (i < n) {
                        if (!this.val$result[i].closed) {
                            return;
                        }
                        if (this.val$result[i].idx != this.idx || this.val$result[i].checksums[this.idx - 1] != this.checksums[this.idx - 1]) {
                            this.val$whenNotIdentical.run();
                            return;
                        }
                        ++i;
                    }
                    this.val$whenIdentical.run();
                }
            };
            ++i;
        }
        return result;
    }

    public static OutputStream lengthWritten(final Consumer<? super Integer> delegate) {
        return new OutputStream(){

            @Override
            public void write(int b) {
                delegate.consume(1);
            }

            @Override
            public void write(@Nullable byte[] b, int off, int len) {
                delegate.consume(len);
            }
        };
    }
}

