/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.txt2html.mavenplugin;

import de.unkrig.commons.file.ExceptionHandler;
import de.unkrig.commons.file.contentstransformation.ContentsTransformer;
import de.unkrig.commons.file.filetransformation.FileContentsTransformer;
import de.unkrig.commons.file.filetransformation.FileTransformations;
import de.unkrig.commons.file.filetransformation.FileTransformer;
import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.lang.ObjectUtil;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.PredicateUtil;
import de.unkrig.commons.text.pattern.Glob;
import de.unkrig.commons.text.pattern.PatternUtil;
import de.unkrig.txt2html.CharMatrix2Svg;
import de.unkrig.txt2html.text.CharMatrix;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="txt2html", defaultPhase=LifecyclePhase.PACKAGE)
public class Txt2HtmlMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}/apidocs", property="dir", required=true)
    private File directory;
    @Parameter(property="outputDir", required=false)
    private File outputDirectory;
    @Parameter(property="keepOriginals", required=false)
    private boolean keepOriginals;
    @Parameter(defaultValue="true", property="saveSpace", required=false)
    private boolean saveSpace;
    @Parameter(defaultValue="UTF-8", property="encoding", required=false)
    private String encoding;
    @Parameter(defaultValue="<pre class=\"asciiart\"><code>\\.?([^<]*)</code></pre>", property="asciiArtPattern")
    private String asciiArtRegex;

    public void execute() throws MojoExecutionException {
        try {
            this.execute2();
        }
        catch (Exception e) {
            throw new MojoExecutionException(null, e);
        }
    }

    private void execute2() throws IOException {
        final Charset charset = Charset.forName(this.encoding);
        FileContentsTransformer ft = new FileContentsTransformer(new ContentsTransformer(){

            public void transform(String path, InputStream is, OutputStream os) throws IOException {
                IoUtil.copy((Reader)new InputStreamReader(is, charset), (Writer)Txt2HtmlMojo.this.make(new OutputStreamWriter(os, charset)));
            }
        }, this.keepOriginals);
        ft = FileTransformations.directoryTreeTransformer(null, (Predicate)PredicateUtil.never(), (Glob)Glob.ANY, (FileTransformations.DirectoryCombiner)FileTransformations.DirectoryCombiner.NOP, (FileTransformer)ft, (boolean)this.saveSpace, (boolean)this.keepOriginals, (ExceptionHandler)ExceptionHandler.defaultHandler());
        ft.transform(this.directory.getPath(), this.directory, (File)ObjectUtil.or((Object)this.outputDirectory, (Object)this.directory), FileTransformer.Mode.CHECK_AND_TRANSFORM);
    }

    public Writer make(Writer delegate) {
        return PatternUtil.replaceAllFilterWriter((Pattern)Pattern.compile(this.asciiArtRegex), mr -> {
            String text = mr.group(1);
            text = text.replace("&lt;", "<");
            text = text.replace("&gt;", ">");
            text = text.replace("&quot;", "\"");
            text = text.replace("&amp;", "&");
            StringWriter sw = new StringWriter();
            new CharMatrix2Svg((Writer)sw).convert(CharMatrix.read((Reader)new StringReader(text)));
            return sw.toString();
        }, (Appendable)delegate);
    }
}

