/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.ref4j.jur;

import de.unkrig.commons.lang.OptionalMethods;
import de.unkrig.ref4j.Matcher;
import de.unkrig.ref4j.Pattern;
import java.io.IOException;
import java.io.Serializable;
import java.util.regex.MatchResult;
import java.util.regex.PatternSyntaxException;

public final class PatternFactory
extends de.unkrig.ref4j.PatternFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final double JAVA_SPECIFICATION_VERSION = Double.parseDouble(System.getProperty("java.specification.version"));
    private static final int SUPPORTED_FLAGS = 0xFF | (JAVA_SPECIFICATION_VERSION >= 1.7 ? 256 : 0);
    public static final PatternFactory INSTANCE = new PatternFactory();
    static final OptionalMethods.MethodWrapper1<java.util.regex.Matcher, Integer, String, RuntimeException> MATCHER_START = OptionalMethods.get1((String)"Named capturing groups only available in Java 8+", java.util.regex.Matcher.class, (String)"start", String.class);
    static final OptionalMethods.MethodWrapper1<java.util.regex.Matcher, Integer, String, RuntimeException> MATCHER_END = OptionalMethods.get1((String)"Named capturing groups only available in Java 8+", java.util.regex.Matcher.class, (String)"end", String.class);
    static final OptionalMethods.MethodWrapper1<java.util.regex.Matcher, String, String, RuntimeException> MATCHER_GROUP = OptionalMethods.get1((String)"Named capturing groups only available in Java 8+", java.util.regex.Matcher.class, (String)"group", String.class);

    private PatternFactory() {
    }

    @Override
    public String getId() {
        return "java.util.regex";
    }

    @Override
    public int getSupportedFlags() {
        return SUPPORTED_FLAGS;
    }

    @Override
    public Pattern compile(final String regex, final int flags) throws PatternSyntaxException {
        class JurPattern
        implements Pattern,
        Serializable {
            private static final long serialVersionUID = 1L;
            final java.util.regex.Pattern jurPattern;

            JurPattern() {
                this.jurPattern = java.util.regex.Pattern.compile(regex, flags);
            }

            @Override
            public String pattern() {
                return this.jurPattern.pattern();
            }

            @Override
            public Matcher matcher(CharSequence subject) {
                final java.util.regex.Matcher m = this.jurPattern.matcher(subject);
                return new Matcher(){

                    @Override
                    public Matcher useTransparentBounds(boolean b) {
                        m.useTransparentBounds(b);
                        return this;
                    }

                    @Override
                    public Matcher usePattern(Pattern newPattern) {
                        m.usePattern(((JurPattern)newPattern).jurPattern);
                        return this;
                    }

                    @Override
                    public Matcher useAnchoringBounds(boolean b) {
                        m.useAnchoringBounds(b);
                        return this;
                    }

                    @Override
                    public MatchResult toMatchResult() {
                        return m.toMatchResult();
                    }

                    @Override
                    public int start(int group) {
                        return m.start(group);
                    }

                    @Override
                    public int start() {
                        return m.start();
                    }

                    @Override
                    public int start(String name) {
                        return (Integer)MATCHER_START.invoke((Object)m, (Object)name);
                    }

                    @Override
                    public Matcher reset(CharSequence input) {
                        m.reset(input);
                        return this;
                    }

                    @Override
                    public Matcher reset() {
                        m.reset();
                        return this;
                    }

                    @Override
                    public boolean requireEnd() {
                        return m.requireEnd();
                    }

                    @Override
                    public String replaceFirst(String replacement) {
                        return m.replaceFirst(replacement);
                    }

                    @Override
                    public String replaceAll(String replacement) {
                        return m.replaceAll(replacement);
                    }

                    @Override
                    public int regionStart() {
                        return m.regionStart();
                    }

                    @Override
                    public int regionEnd() {
                        return m.regionEnd();
                    }

                    @Override
                    public Matcher region(int start, int end) {
                        m.region(start, end);
                        return this;
                    }

                    @Override
                    public Pattern pattern() {
                        return this;
                    }

                    @Override
                    public boolean matches() {
                        return m.matches();
                    }

                    @Override
                    public boolean lookingAt() {
                        return m.lookingAt();
                    }

                    @Override
                    public String quoteReplacement(String s) {
                        return java.util.regex.Matcher.quoteReplacement(s);
                    }

                    @Override
                    public boolean hitEnd() {
                        return m.hitEnd();
                    }

                    @Override
                    public boolean hasTransparentBounds() {
                        return m.hasTransparentBounds();
                    }

                    @Override
                    public boolean hasAnchoringBounds() {
                        return m.hasAnchoringBounds();
                    }

                    @Override
                    public int groupCount() {
                        return m.groupCount();
                    }

                    @Override
                    public String group(int group) {
                        return m.group(group);
                    }

                    @Override
                    public String group() {
                        return m.group();
                    }

                    @Override
                    public String group(String name) {
                        return (String)MATCHER_GROUP.invoke((Object)m, (Object)name);
                    }

                    @Override
                    public boolean find(int start) {
                        return m.find(start);
                    }

                    @Override
                    public boolean find() {
                        return m.find();
                    }

                    @Override
                    public int end(int group) {
                        return m.end(group);
                    }

                    @Override
                    public int end() {
                        return m.end();
                    }

                    @Override
                    public int end(String name) {
                        return (Integer)MATCHER_END.invoke((Object)m, (Object)name);
                    }

                    @Override
                    public <T extends Appendable> T appendTail(T appendable) {
                        if (appendable instanceof StringBuffer) {
                            StringBuffer result = m.appendTail((StringBuffer)appendable);
                            return (T)result;
                        }
                        try {
                            StringBuffer sb = new StringBuffer();
                            m.appendTail(sb);
                            appendable.append(sb);
                            return appendable;
                        }
                        catch (IOException ioe) {
                            throw new AssertionError((Object)ioe);
                        }
                    }

                    @Override
                    public Matcher appendReplacement(Appendable appendable, String replacement) {
                        if (appendable instanceof StringBuffer) {
                            m.appendReplacement((StringBuffer)appendable, replacement);
                            return this;
                        }
                        try {
                            StringBuffer sb = new StringBuffer();
                            m.appendReplacement(sb, replacement);
                            appendable.append(sb);
                            return this;
                        }
                        catch (IOException ioe) {
                            throw new AssertionError((Object)ioe);
                        }
                    }
                };
            }

            @Override
            public int flags() {
                return this.jurPattern.flags();
            }

            @Override
            public boolean matches(CharSequence subject, int offset) {
                return this.jurPattern.matcher(subject.subSequence(offset, subject.length())).matches();
            }

            @Override
            public String[] split(CharSequence input) {
                return this.jurPattern.split(input);
            }

            @Override
            public String[] split(CharSequence input, int limit) {
                return this.jurPattern.split(input, limit);
            }

            public String toString() {
                return this.jurPattern.toString();
            }
        }
        return new JurPattern();
    }

    @Override
    public boolean matches(String regex, CharSequence input) {
        return java.util.regex.Pattern.matches(regex, input);
    }
}

