/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.ref4j;

import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.util.EnhancedServiceLoader;
import de.unkrig.ref4j.Pattern;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.PatternSyntaxException;

@NotNullByDefault
public abstract class PatternFactory {
    public static PatternFactory get() {
        String patternFactoryClassName = System.getProperty("de.unkrig.ref4j.PatternFactory");
        if (patternFactoryClassName != null) {
            return PatternFactory.get(patternFactoryClassName);
        }
        Iterator it = EnhancedServiceLoader.DEFAULT.load(PatternFactory.class).iterator();
        return it.hasNext() ? (PatternFactory)it.next() : de.unkrig.ref4j.jur.PatternFactory.INSTANCE;
    }

    public abstract String getId();

    @Nullable
    public static PatternFactory get(String fullyQualifiedClassName) {
        for (PatternFactory pf : EnhancedServiceLoader.DEFAULT.load(PatternFactory.class)) {
            if (!pf.getClass().getName().equals(fullyQualifiedClassName)) continue;
            return pf;
        }
        return null;
    }

    public abstract int getSupportedFlags();

    public Pattern compile(String regex) throws PatternSyntaxException {
        return this.compile(regex, 0);
    }

    public abstract Pattern compile(String var1, int var2) throws PatternSyntaxException;

    public abstract boolean matches(String var1, CharSequence var2);

    public String quote(String s) {
        return java.util.regex.Pattern.quote(s);
    }

    public String quoteReplacement(String s) {
        return Matcher.quoteReplacement(s);
    }
}

