/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.jsh.command;

import de.unkrig.jsh.util.Cloneable2;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributes;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.codehaus.commons.nullanalysis.NotNullByDefault;
import org.codehaus.commons.nullanalysis.Nullable;

public final class Ls
extends Cloneable2<Ls> {
    private boolean lonG;
    private boolean directory;
    private TimeKind timeToShow = TimeKind.LAST_MODIFIED_TIME;
    private DateFormat dateFormat = DateFormat.getDateTimeInstance();
    @Nullable
    private Comparator<File> sortingComparator = BY_PATH;
    private static final Comparator<File> BY_PATH = Ls.naturalOrderComparator();
    private static final Comparator<File> BY_LAST_MODIFIED_TIME = new FilesByTimeComparator(TimeKind.LAST_MODIFIED_TIME);
    private static final Comparator<File> BY_CREATION_TIME = new FilesByTimeComparator(TimeKind.CREATION_TIME);
    private static final Comparator<File> BY_LAST_ACCESS_TIME = new FilesByTimeComparator(TimeKind.LAST_ACCESS_TIME);
    private static final Comparator<File> BY_LENGTH = new Comparator<File>(){

        @Override
        @NotNullByDefault(value=false)
        public int compare(File f1, File f2) {
            return Long.compare(f1.length(), f2.length());
        }
    };
    private static final Comparator<File> BY_EXTENSION = new Comparator<File>(){

        @Override
        @NotNullByDefault(value=false)
        public int compare(File f1, File f2) {
            String extension1 = Ls.extension(f1.getName());
            String extension2 = Ls.extension(f2.getName());
            return Ls.compare((Comparable)((Object)extension1), (Comparable)((Object)extension2), (Comparable)((Object)f1.getPath()), (Comparable)((Object)f2.getPath()));
        }
    };

    public Ls c() {
        Ls result = (Ls)this.clone2();
        result.timeToShow = TimeKind.CREATION_TIME;
        if (!this.lonG || this.sortingComparator == BY_LAST_MODIFIED_TIME) {
            result.sortingComparator = BY_CREATION_TIME;
        }
        return result;
    }

    public Ls d() {
        Ls result = (Ls)this.clone2();
        result.directory = true;
        return result;
    }

    public Ls dateFormat(DateFormat dateFormat) {
        Ls result = (Ls)this.clone2();
        result.dateFormat = dateFormat;
        return result;
    }

    public Ls l() {
        Ls result = (Ls)this.clone2();
        result.lonG = true;
        return result;
    }

    public Ls S() {
        Ls result = (Ls)this.clone2();
        result.sortingComparator = BY_LENGTH;
        return result;
    }

    public Ls sort(String word) {
        switch (word) {
            case "none": {
                return this.U();
            }
            case "size": {
                return this.S();
            }
            case "time": {
                return this.t();
            }
            case "extension": {
                return this.X();
            }
        }
        throw new IllegalArgumentException(word);
    }

    public Ls t() {
        Ls result = (Ls)this.clone2();
        result.sortingComparator = BY_LAST_MODIFIED_TIME;
        return result;
    }

    public Ls u() {
        Ls result = (Ls)this.clone2();
        result.timeToShow = TimeKind.CREATION_TIME;
        if (!this.lonG || this.sortingComparator == BY_LAST_MODIFIED_TIME) {
            result.sortingComparator = BY_LAST_ACCESS_TIME;
        }
        return result;
    }

    public Ls U() {
        Ls result = (Ls)this.clone2();
        result.sortingComparator = null;
        return result;
    }

    public Ls X() {
        Ls result = (Ls)this.clone2();
        result.sortingComparator = BY_EXTENSION;
        return result;
    }

    public void $() {
        for (String memberName : new File(".").list()) {
            this.printMember(memberName, new File(memberName));
        }
    }

    public void $(File ... files) {
        this.$(Arrays.asList(files));
    }

    public void $(Collection<File> files) {
        File f;
        if (files.isEmpty()) {
            this.$();
            return;
        }
        if (!this.directory && files.size() == 1 && (f = files.iterator().next()).isDirectory()) {
            this.printMembers(f);
            return;
        }
        files = new ArrayList<File>(files);
        Collections.sort((List)files, this.sortingComparator);
        ArrayList<File> directories = new ArrayList<File>();
        for (File file : files) {
            if (!this.directory && file.isDirectory()) {
                directories.add(file);
                continue;
            }
            this.printMember(file.getPath(), file);
        }
        for (File d : directories) {
            System.out.println();
            System.out.println(d + ":");
            this.printMembers(d);
        }
    }

    private void printMembers(File directory) {
        File[] members = directory.listFiles();
        Arrays.sort(members, this.sortingComparator);
        for (File member : members) {
            this.printMember(member.getName(), member);
        }
    }

    private void printMember(String name, File member) {
        if (this.lonG) {
            FileTime time = Ls.getFileTime(member, this.timeToShow);
            System.out.printf("%c%c%c%c %-12s %9d %s %s%n", Character.valueOf(member.isDirectory() ? (char)'d' : '-'), Character.valueOf(member.canRead() ? (char)'r' : '-'), Character.valueOf(member.canWrite() ? (char)'w' : '-'), Character.valueOf(member.canExecute() ? (char)'x' : '-'), this.getOwnerName(member), member.length(), time == null ? "???" : Ls.threadSafeFormat(this.dateFormat, new Date(time.toMillis())), name);
        } else {
            System.out.println(name);
        }
    }

    private static String threadSafeFormat(DateFormat dateFormat, Date date) {
        return ((DateFormat)dateFormat.clone()).format(date);
    }

    @Nullable
    private String getOwnerName(File file) {
        try {
            return Files.readAttributes(file.toPath(), PosixFileAttributes.class, new LinkOption[0]).owner().getName();
        }
        catch (IOException ioe) {
            return null;
        }
        catch (UnsupportedOperationException ioe) {
            try {
                return Files.getFileAttributeView(file.toPath(), FileOwnerAttributeView.class, new LinkOption[0]).getOwner().getName();
            }
            catch (IOException ioe2) {
                return null;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                return null;
            }
        }
    }

    @Nullable
    private static FileTime getFileTime(@Nullable File file, TimeKind timeKind) {
        BasicFileAttributes basicFileAttributes = Ls.getBasicFileAttributes(file);
        if (basicFileAttributes == null) {
            return null;
        }
        switch (timeKind) {
            case CREATION_TIME: {
                return basicFileAttributes.creationTime();
            }
            case LAST_ACCESS_TIME: {
                return basicFileAttributes.lastAccessTime();
            }
            case LAST_MODIFIED_TIME: {
                return basicFileAttributes.lastModifiedTime();
            }
        }
        throw new AssertionError((Object)timeKind);
    }

    @Nullable
    private static BasicFileAttributes getBasicFileAttributes(@Nullable File file) {
        if (file == null) {
            return null;
        }
        try {
            return Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException | UnsupportedOperationException e) {
            return null;
        }
    }

    private static <T extends Comparable<T>> int compare(@Nullable T o1, @Nullable T o2) {
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o1.compareTo(o2);
    }

    private static <T1 extends Comparable<T1>, T2 extends Comparable<T2>> int compare(@Nullable T1 primary1, @Nullable T1 primary2, @Nullable T2 secondary1, @Nullable T2 secondary2) {
        int result = Ls.compare(primary1, primary2);
        return result != 0 ? result : Ls.compare(secondary1, secondary2);
    }

    @Nullable
    private static String extension(String name) {
        int dot = name.lastIndexOf(46);
        return dot == -1 ? null : name.substring(dot + 1);
    }

    private static <T extends Comparable<T>> Comparator<T> naturalOrderComparator() {
        return new Comparator<T>(){

            @Override
            @NotNullByDefault(value=false)
            public int compare(T o1, T o2) {
                return Ls.compare(o1, o2);
            }
        };
    }

    private static class FilesByTimeComparator
    implements Comparator<File> {
        private final TimeKind timeKind;

        FilesByTimeComparator(TimeKind timeKind) {
            this.timeKind = timeKind;
        }

        @Override
        @NotNullByDefault(value=false)
        public int compare(File f1, File f2) {
            return Ls.compare(Ls.getFileTime(f1, this.timeKind), Ls.getFileTime(f1, this.timeKind));
        }
    }

    private static enum TimeKind {
        LAST_MODIFIED_TIME,
        CREATION_TIME,
        LAST_ACCESS_TIME;

    }
}

