/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.jsh;

import de.unkrig.jsh.InteractiveShell;
import de.unkrig.jsh.JshBase;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.codehaus.commons.compiler.CompilerFactoryFactory;
import org.codehaus.commons.compiler.ICompilerFactory;
import org.codehaus.commons.compiler.IScriptEvaluator;
import org.codehaus.commons.compiler.samples.DemoBase;
import org.codehaus.commons.nullanalysis.Nullable;

public final class Main
extends DemoBase {
    private Main() {
    }

    public static void main(String[] args) throws Exception {
        String arg;
        int i;
        Class returnType = Void.TYPE;
        ArrayList<String> parameterNames = new ArrayList<String>();
        ArrayList<Class> parameterTypes = new ArrayList<Class>();
        ArrayList<Class> thrownExceptions = new ArrayList<Class>();
        ArrayList<String> defaultImports = new ArrayList<String>();
        String optionalEncoding = null;
        String compilerFactoryId = null;
        defaultImports.add("java.io.*");
        for (i = 0; i < args.length && (arg = args[i]).startsWith("-"); ++i) {
            if ("--return-type".equals(arg)) {
                returnType = DemoBase.stringToType((String)args[++i]);
                continue;
            }
            if ("--parameter".equals(arg)) {
                parameterTypes.add(DemoBase.stringToType((String)args[++i]));
                parameterNames.add(args[++i]);
                continue;
            }
            if ("--thrown-exception".equals(arg)) {
                thrownExceptions.add(DemoBase.stringToType((String)args[++i]));
                continue;
            }
            if ("--default-import".equals(arg)) {
                defaultImports.add(args[++i]);
                continue;
            }
            if ("--encoding".equals(arg)) {
                optionalEncoding = args[++i];
                continue;
            }
            if ("--compiler-factory".equals(arg)) {
                compilerFactoryId = args[++i];
                continue;
            }
            if ("--help".equals(arg)) {
                System.err.println("The \"Java shell\".");
                System.err.println();
                System.err.println("Usage as an interactive shell:");
                System.err.println("  Jsh { <option> }");
                System.err.println("Valid <option>s are:");
                System.err.println(" --thrown-exception <exception-type> (multiple allowed)");
                System.err.println(" --default-import <imports>          (multiple allowed)");
                System.err.println(" --encoding <encoding>");
                System.err.println(" --help");
                System.err.println();
                System.err.println("Usage for executing a script file (containing Java code):");
                System.err.println("  Jsh { <option> } <script-file> { <argument> }");
                System.err.println("Valid <option>s are thos described above, plus:");
                System.err.println(" --return-type <return-type>         (default: void)");
                System.err.println(" --parameter <type> <name>           (multiple allowed)");
                System.err.println(" --compiler-factory <id>             (One of " + Arrays.toString(CompilerFactoryFactory.getAllCompilerFactories()) + ")");
                System.err.println("If no \"--parameter\"s are specified, then the <argument>s are passed as a");
                System.err.println("single parameter \"String[] args\". Otherwise, the number of <argument>s must");
                System.err.println("exactly match the number of parameters, and each <argument> is converted to");
                System.err.println("the respective parameter's type.");
                System.err.println("Iff the return type is not \"void\", then the return value is printed to STDOUT");
                System.err.println("after the script completes.");
                return;
            }
            System.err.println("Invalid command line option \"" + arg + "\"; try \"--help\".");
            System.exit(1);
        }
        if (i == args.length) {
            if (compilerFactoryId != null) {
                System.err.println("Compiler factory by cannot be set if reading from STDIN");
                System.exit(1);
            }
            if (returnType != Void.TYPE) {
                System.err.println("Return type not possible if reading from STDIN");
                System.exit(1);
            }
            if (!parameterTypes.isEmpty()) {
                System.err.println("Parameters are not possible if the script is read from STDIN");
                System.exit(1);
            }
            InteractiveShell.run(defaultImports.toArray(new String[defaultImports.size()]), thrownExceptions.toArray(new Class[thrownExceptions.size()]), optionalEncoding);
        } else {
            File scriptFile = new File(args[i++]);
            Main.executeScriptFile(compilerFactoryId, scriptFile, optionalEncoding, defaultImports.toArray(new String[defaultImports.size()]), returnType, parameterNames.toArray(new String[parameterNames.size()]), parameterTypes.toArray(new Class[parameterTypes.size()]), thrownExceptions.toArray(new Class[thrownExceptions.size()]), Arrays.copyOfRange(args, i, args.length));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeScriptFile(@Nullable String compilerFactoryId, File scriptFile, @Nullable String optionalEncoding, String[] defaultImports, Class<?> returnType, String[] parameterNames, Class<?>[] parameterTypes, Class<?>[] thrownExceptions, String[] args) throws Exception {
        Object[] arguments;
        ICompilerFactory compilerFactory;
        block14: {
            if (compilerFactoryId != null) {
                for (ICompilerFactory cf : CompilerFactoryFactory.getAllCompilerFactories()) {
                    if (!cf.getId().equals(compilerFactoryId)) continue;
                    compilerFactory = cf;
                    break block14;
                }
                System.err.println("Invalid compiler factory id \"" + compilerFactoryId + "\"; try \"--help\".");
                System.exit(1);
                return;
            }
            compilerFactory = CompilerFactoryFactory.getDefaultCompilerFactory();
        }
        IScriptEvaluator se = compilerFactory.newScriptEvaluator();
        se.setDefaultImports(defaultImports);
        se.setExtendedClass(JshBase.class);
        se.setReturnType(returnType);
        se.setThrownExceptions((Class[])thrownExceptions);
        if (parameterNames.length == 0 && parameterTypes.length == 0) {
            parameterNames = new String[]{"args"};
            parameterTypes = new Class[]{String[].class};
            arguments = new Object[]{args};
        } else {
            if (args.length != parameterTypes.length) {
                System.err.println("Argument count (" + args.length + ") and parameter count (" + parameterTypes.length + ") do not match; try \"--help\".");
                System.exit(1);
            }
            arguments = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                arguments[i] = DemoBase.createObject(parameterTypes[i], (String)args[i]);
            }
        }
        se.setParameters(parameterNames, (Class[])parameterTypes);
        FileInputStream is = new FileInputStream(scriptFile);
        try {
            se.cook(scriptFile.toString(), (InputStream)is, optionalEncoding);
            ((InputStream)is).close();
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (Exception cf) {}
        }
        Object res = se.evaluate(arguments);
        if (returnType != Void.TYPE) {
            System.out.println(res instanceof Object[] ? Arrays.toString((Object[])res) : String.valueOf(res));
        }
    }
}

