/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.jsh;

import de.unkrig.jsh.Brief;
import de.unkrig.jsh.Command;
import de.unkrig.jsh.command.Cd;
import de.unkrig.jsh.command.Echo;
import de.unkrig.jsh.command.Ls;
import de.unkrig.jsh.command.Pwd;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.commons.nullanalysis.Nullable;

public abstract class JshBase {
    public static final Cd cd = new Cd();
    public static final Echo echo = new Echo();
    public static final Ls ls = new Ls();
    public static final Pwd pwd = new Pwd();
    public static final DateFormat ISO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static final DateFormat ISO_DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    public static final DateFormat LONG_ISO_DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    public static final DateFormat FULL_ISO_DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    public static final DateFormat ISO_TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    public static final DateFormat LONG_ISO_TIME_FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
    public static final DateFormat FULL_ISO_TIME_FORMAT = new SimpleDateFormat("HH:mm:ss.SSSZ");

    public static void cd() {
        cd.$();
    }

    public static void cd(File dir) {
        cd.$(dir);
    }

    public static void cd(String dirName) {
        cd.$(new File(dirName));
    }

    public static void echo(Object ... args) {
        echo.$(args);
    }

    public static void err(@Nullable Object subject) {
        Brief.print(subject, System.err);
    }

    public static void exit() {
        System.exit(0);
    }

    public static void exit(int status) {
        System.exit(status);
    }

    public static void ls(File ... files) {
        ls.$(files);
    }

    public static void out(@Nullable Object subject) {
        Brief.print(subject, System.out);
    }

    public static void pwd() {
        Pwd.$();
    }

    public static int run(String ... command) throws IOException, InterruptedException {
        return Command.run(command);
    }

    public static DateFormat dateFormat() {
        return DateFormat.getDateInstance();
    }

    public static DateFormat dateFormat(int dateStyle) {
        return DateFormat.getDateInstance(dateStyle);
    }

    public static DateFormat dateTimeFormat() {
        return DateFormat.getDateTimeInstance();
    }

    public static DateFormat dateTimeFormat(int dateStyle, int timeStyle) {
        return DateFormat.getDateTimeInstance(dateStyle, timeStyle);
    }

    public static File file(String pathname) {
        return new File(pathname);
    }

    public static Command from(File inputFile) {
        return Command.from(inputFile);
    }

    public static File getcwd() {
        return new File(System.getProperty("user.dir"));
    }

    @Nullable
    public static Collection<? extends File> glob(String ... globs) {
        return globs == null ? null : Brief.glob(null, globs);
    }

    public static List list() {
        return new ArrayList();
    }

    public static Map map() {
        return new HashMap();
    }

    public static Command pipe(String ... command) {
        return Command.pipe(command);
    }

    public static Set set() {
        return new HashSet();
    }

    public static DateFormat timeFormat() {
        return DateFormat.getTimeInstance();
    }

    public static DateFormat timeFormat(int timeStyle) {
        return DateFormat.getTimeInstance(timeStyle);
    }
}

