/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.jsh;

import de.unkrig.commons.lang.StringUtil;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.util.ArrayUtil;
import de.unkrig.jsh.JshBase;
import de.unkrig.jsh.StatementEvaluator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import jline.console.ConsoleReader;
import jline.console.history.FileHistory;
import jline.console.history.History;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.samples.DemoBase;
import org.codehaus.commons.nullanalysis.Nullable;
import org.codehaus.janino.Java;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.ScriptEvaluator;
import org.codehaus.janino.TokenType;
import org.codehaus.janino.Visitor;

public final class InteractiveShell
extends DemoBase {
    private static final File USER_HOME_DIR = new File(System.getProperty("user.home", "."));
    private static final File JSH_HISTORY_FILE = new File(USER_HOME_DIR, ".jsh_history");
    private static final File JSHRC_FILE = new File(USER_HOME_DIR, ".jshrc");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private InteractiveShell() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(String[] defaultImports, Class<?>[] thrownExceptions, @Nullable String optionalEncoding) throws IOException, CompileException, InvocationTargetException {
        block20: {
            FileInputStream is;
            ScriptEvaluator se = new ScriptEvaluator();
            se.setDefaultImports(defaultImports);
            se.setExtendedClass(JshBase.class);
            se.setThrownExceptions((Class[])thrownExceptions);
            try {
                is = new FileInputStream(JSHRC_FILE);
            }
            catch (FileNotFoundException fnfe) {
                break block20;
            }
            try {
                se.cook(JSHRC_FILE.toString(), (InputStream)is, optionalEncoding);
                ((InputStream)is).close();
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception fnfe) {}
            }
            se.evaluate(null);
        }
        final ConsoleReader cr = new ConsoleReader();
        cr.setExpandEvents(false);
        final FileHistory fileHistory = new FileHistory(JSH_HISTORY_FILE);
        cr.setHistory((History)fileHistory);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    fileHistory.flush();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        });
        ProducerWhichThrows<String, IOException> lp = new ProducerWhichThrows<String, IOException>(){

            @Nullable
            public String produce() throws IOException {
                String result = cr.readLine();
                cr.setPrompt("> ");
                return result;
            }
        };
        StatementEvaluator se = new StatementEvaluator();
        se.setDefaultImports(defaultImports);
        se.setExtendedClass(JshBase.class);
        se.setThrownExceptions(thrownExceptions);
        System.err.println("Welcome, stranger, and speak!");
        while (true) {
            Parser parser = new Parser(new Scanner(null, InteractiveShell.lineProducerReader((ProducerWhichThrows<String, ? extends IOException>)lp)));
            cr.setPrompt("$ ");
            try {
                if (parser.peek().type == TokenType.END_OF_INPUT) break;
                if (parser.peek("package")) {
                    se.setClassName(parser.parsePackageDeclaration().packageName + ".SC");
                } else if (parser.peekRead("throws")) {
                    Java.ReferenceType[] tes = parser.parseReferenceTypeList();
                    parser.read(";");
                    for (Java.ReferenceType te : tes) {
                        Class<?> tec = InteractiveShell.class.getClassLoader().loadClass(StringUtil.join(Arrays.asList(te.identifiers), (String)"."));
                        thrownExceptions = (Class[])ArrayUtil.append((Object[])thrownExceptions, (Object[])new Class[]{tec});
                    }
                    se.setThrownExceptions(thrownExceptions);
                } else if (parser.peek("import")) {
                    Java.AbstractCompilationUnit.ImportDeclaration id = parser.parseImportDeclaration();
                    String imporT = (String)id.accept((Visitor.ImportVisitor)new Visitor.ImportVisitor<String, RuntimeException>(){

                        @Nullable
                        public String visitSingleTypeImportDeclaration(Java.AbstractCompilationUnit.SingleTypeImportDeclaration stid) {
                            return InteractiveShell.join(stid.identifiers, ".");
                        }

                        @Nullable
                        public String visitTypeImportOnDemandDeclaration(Java.AbstractCompilationUnit.TypeImportOnDemandDeclaration tiodd) {
                            return InteractiveShell.join(tiodd.identifiers, ".") + ".*";
                        }

                        @Nullable
                        public String visitSingleStaticImportDeclaration(Java.AbstractCompilationUnit.SingleStaticImportDeclaration ssid) {
                            return "static " + InteractiveShell.join(ssid.identifiers, ".");
                        }

                        @Nullable
                        public String visitStaticImportOnDemandDeclaration(Java.AbstractCompilationUnit.StaticImportOnDemandDeclaration siodd) {
                            return "static " + InteractiveShell.join(siodd.identifiers, ".") + ".*";
                        }
                    });
                    defaultImports = (String[])ArrayUtil.append((Object[])defaultImports, (Object[])new String[]{imporT});
                    se.setDefaultImports(defaultImports);
                } else {
                    se.cook(parser);
                    se.execute();
                }
            }
            catch (CompileException ce) {
                System.out.flush();
                System.err.println(ce.getLocalizedMessage());
            }
            catch (Exception e) {
                System.out.flush();
                e.printStackTrace();
            }
            System.out.flush();
        }
    }

    private static Reader lineProducerReader(final ProducerWhichThrows<String, ? extends IOException> lineProducer) {
        return new Reader(){
            @Nullable
            String line = "";
            int offset;

            @Override
            public int read(@Nullable char[] cbuf, int off, int len) throws IOException {
                if (len <= 0) {
                    return 0;
                }
                String l = this.line;
                if (l == null) {
                    return -1;
                }
                while (this.offset >= l.length()) {
                    l = (String)lineProducer.produce();
                    if (l == null) {
                        this.line = null;
                        return -1;
                    }
                    this.line = l + LINE_SEPARATOR;
                    this.offset = 0;
                }
                int n = Math.min(l.length() - this.offset, len);
                l.getChars(this.offset, this.offset + n, cbuf, off);
                this.offset += n;
                return n;
            }

            @Override
            public void close() {
            }
        };
    }

    private static String join(Object[] elements, String glue) {
        if (elements.length == 0) {
            return "";
        }
        if (elements.length == 1) {
            return String.valueOf(elements[0]);
        }
        StringBuilder sb = new StringBuilder().append(elements[0]).append(glue).append(elements[1]);
        for (int i = 2; i < elements.length; ++i) {
            sb.append(glue).append(elements[i]);
        }
        return sb.toString();
    }
}

