/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.jsh;

import de.unkrig.commons.io.IoUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class Command {
    public static int run(String ... command) throws InterruptedException, IOException {
        return Command.run(ProcessBuilder.Redirect.INHERIT, command);
    }

    public static int run(ProcessBuilder.Redirect redirectError, String ... command) throws InterruptedException, IOException {
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.redirectInput(ProcessBuilder.Redirect.INHERIT);
        pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        pb.redirectError(redirectError);
        return pb.start().waitFor();
    }

    public static Command from(final File inputFile) {
        return new Command(){

            @Override
            protected InputStream start() throws IOException {
                return new FileInputStream(inputFile);
            }
        };
    }

    public static Command pipe(final String ... command) {
        return new Command(){
            private ProcessBuilder.Redirect redirectError = ProcessBuilder.Redirect.INHERIT;

            public Command redirectError(ProcessBuilder.Redirect redirectError) {
                this.redirectError = redirectError;
                return this;
            }

            @Override
            protected InputStream start() throws IOException {
                ProcessBuilder pb = new ProcessBuilder(command);
                pb.redirectError(this.redirectError);
                return Command.outputOf(pb.start());
            }
        };
    }

    public void print() throws IOException {
        IoUtil.copy((InputStream)this.start(), (boolean)true, (OutputStream)System.out, (boolean)false);
    }

    public int to(String ... command) throws InterruptedException, IOException {
        return this.to(ProcessBuilder.Redirect.INHERIT, command);
    }

    public int to(ProcessBuilder.Redirect redirectError, String ... command) throws InterruptedException, IOException {
        InputStream fromProcess1 = this.start();
        ProcessBuilder pb2 = new ProcessBuilder(command);
        pb2.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        pb2.redirectError(redirectError);
        Process process2 = pb2.start();
        try {
            IoUtil.copy((InputStream)fromProcess1, (boolean)true, (OutputStream)process2.getOutputStream(), (boolean)true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return process2.waitFor();
    }

    public void to(File outputFile) throws IOException {
        FileOutputStream os = new FileOutputStream(outputFile);
        IoUtil.copy((InputStream)this.start(), (boolean)true, (OutputStream)os, (boolean)true);
    }

    public Command through(final String ... command) throws InterruptedException, IOException {
        return new Command(){
            private ProcessBuilder.Redirect redirectError = ProcessBuilder.Redirect.INHERIT;

            public Command redirectError(ProcessBuilder.Redirect redirectError) {
                this.redirectError = redirectError;
                return this;
            }

            @Override
            protected InputStream start() throws IOException {
                final InputStream fromProcess1 = Command.this.start();
                ProcessBuilder pb2 = new ProcessBuilder(command);
                pb2.redirectError(this.redirectError);
                Process process2 = pb2.start();
                final OutputStream toProcess2 = Command.inputOf(process2);
                InputStream fromProcess2 = Command.outputOf(process2);
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        try {
                            IoUtil.copy((InputStream)fromProcess1, (boolean)true, (OutputStream)toProcess2, (boolean)true);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                };
                t.setDaemon(true);
                t.start();
                return fromProcess2;
            }
        };
    }

    private static InputStream outputOf(final Process process) {
        return new FilterInputStream(process.getInputStream()){

            @Override
            public void close() throws IOException {
                super.close();
                try {
                    process.waitFor();
                }
                catch (InterruptedException ie) {
                    throw new IOException(ie);
                }
            }
        };
    }

    private static OutputStream inputOf(final Process process) {
        return new FilterOutputStream(process.getOutputStream()){

            @Override
            public void close() throws IOException {
                super.close();
                try {
                    process.waitFor();
                }
                catch (InterruptedException ie) {
                    throw new IOException(ie);
                }
            }
        };
    }

    protected abstract InputStream start() throws IOException;
}

