/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.jsh;

import de.unkrig.commons.lang.protocol.Consumer;
import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.codehaus.commons.nullanalysis.Nullable;

public final class Brief {
    private Brief() {
    }

    public static void print(@Nullable Object subject, PrintWriter pw) {
        Brief.print(subject, Brief.printWriterPrintln(pw));
    }

    private static Consumer<Object> printWriterPrintln(final PrintWriter pw) {
        return new Consumer<Object>(){

            public void consume(@Nullable Object subject) {
                pw.println(subject);
            }
        };
    }

    public static void print(@Nullable Object subject, PrintStream ps) {
        Brief.print(subject, Brief.printStreamPrintln(ps));
    }

    private static Consumer<Object> printStreamPrintln(final PrintStream ps) {
        return new Consumer<Object>(){

            public void consume(@Nullable Object subject) {
                ps.println(subject);
            }
        };
    }

    public static void print(@Nullable Object subject, Consumer<Object> destination) {
        if (subject == null) {
            return;
        }
        if (subject instanceof Object[]) {
            for (Object e : (Object[])subject) {
                destination.consume(e);
            }
            return;
        }
        if (subject.getClass().isArray()) {
            int length = Array.getLength(subject);
            for (int i = 0; i < length; ++i) {
                destination.consume(Array.get(subject, i));
            }
            return;
        }
        if (subject instanceof Collection) {
            for (Object e : (Collection)subject) {
                destination.consume(e);
            }
            return;
        }
        if (subject instanceof Map) {
            for (Map.Entry e : ((Map)subject).entrySet()) {
                destination.consume((Object)(e.getKey() + "=" + e.getValue()));
            }
            return;
        }
        destination.consume(subject);
    }

    public static Collection<File> glob(@Nullable File parent, String ... globs) {
        ArrayList<File> result = new ArrayList<File>();
        for (String glob : globs) {
            Brief.glob(parent, glob, result);
        }
        return result;
    }

    private static void glob(@Nullable File parent, String glob, Collection<File> result) {
        String suffix;
        String prefix;
        int idx = glob.indexOf(47);
        if (idx == -1) {
            prefix = glob;
            suffix = null;
        } else {
            prefix = glob.substring(0, idx);
            ++idx;
            while (idx < glob.length() && glob.charAt(idx) == '/') {
                ++idx;
            }
            suffix = idx == glob.length() ? null : glob.substring(idx);
        }
        File[] children = (parent == null ? new File(".") : parent).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(@Nullable File dir, @Nullable String name) {
                assert (name != null);
                return Brief.wildmatch(prefix, name);
            }
        });
        if (parent == null) {
            for (int i = 0; i < children.length; ++i) {
                children[i] = new File(children[i].getName());
            }
        }
        if (suffix == null) {
            result.addAll(Arrays.asList(children));
        } else {
            for (File child : children) {
                Brief.glob(child, suffix, result);
            }
        }
    }

    public static boolean wildmatch(@Nullable String pattern, String text) {
        int i;
        if (pattern == null) {
            return true;
        }
        block4: for (i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            switch (c) {
                case '?': {
                    if (i != text.length()) continue block4;
                    return false;
                }
                case '*': {
                    if (pattern.length() == i + 1) {
                        return true;
                    }
                    pattern = pattern.substring(i + 1);
                    while (i <= text.length()) {
                        if (Brief.wildmatch(pattern, text.substring(i))) {
                            return true;
                        }
                        ++i;
                    }
                    return false;
                }
                default: {
                    if (i == text.length()) {
                        return false;
                    }
                    if (text.charAt(i) == c) continue block4;
                    return false;
                }
            }
        }
        return text.length() == i;
    }

    public static boolean containsWildcards(@Nullable String pattern) {
        return pattern != null && (pattern.indexOf(42) != -1 || pattern.indexOf(63) != -1);
    }
}

