/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.html2txt;

import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.html2txt.Html2Txt;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;

public class AntTask
extends Task {
    private final Html2Txt html2txt = new Html2Txt();
    @Nullable
    private File file;
    @Nullable
    private File tofile;
    @Nullable
    private File todir;
    private final List<ResourceCollection> resourceCollections = new ArrayList<ResourceCollection>();

    public void setFile(File value) {
        this.file = value;
    }

    public void setTofile(File value) {
        this.tofile = value;
    }

    public void setTodir(File value) {
        this.todir = value;
    }

    public void setPageLeftMargin(int value) {
        this.html2txt.setPageLeftMarginWidth(value);
    }

    public void setPageRightMargin(int value) {
        this.html2txt.setPageRightMarginWidth(value);
    }

    public void setPageWidth(int value) {
        this.html2txt.setPageWidth(value);
    }

    public void setInputCharset(String charsetName) {
        this.html2txt.setInputCharset(Charset.forName(charsetName));
    }

    public void setOutputCharset(String charsetName) {
        this.html2txt.setOutputCharset(Charset.forName(charsetName));
    }

    public void addConfigured(ResourceCollection value) {
        this.resourceCollections.add(value);
    }

    @Override
    public void execute() throws BuildException {
        try {
            this.execute2();
        }
        catch (Exception e) {
            throw new BuildException(e);
        }
    }

    private void execute2() throws Exception {
        File file = this.file;
        File tofile = this.tofile;
        List<ResourceCollection> resourceCollections = this.resourceCollections;
        ArrayList<FileResource> resources = new ArrayList<FileResource>();
        if (file != null) {
            resources.add(new FileResource(file));
        }
        for (ResourceCollection resourceCollection : resourceCollections) {
            Iterator it = resourceCollection.iterator();
            while (it.hasNext()) {
                resources.add((FileResource)it.next());
            }
        }
        if (resources.isEmpty()) {
            return;
        }
        if (resources.size() == 1 && tofile != null && this.todir == null) {
            this.convertResource((Resource)resources.get(0), tofile);
        } else if (tofile == null) {
            for (Resource resource : resources) {
                String outputFileName;
                File todir = this.todir;
                if (todir == null && resource.isFilesystemOnly()) {
                    todir = ((FileResource)resource).getBaseDir();
                }
                if (todir == null) {
                    todir = this.getProject().getBaseDir();
                }
                if ((outputFileName = resource.getName()).endsWith(".html")) {
                    outputFileName = outputFileName.substring(0, outputFileName.length() - 5);
                }
                outputFileName = outputFileName + ".txt";
                this.convertResource(resource, new File(todir, outputFileName));
            }
        } else {
            throw new BuildException("Invalid combination of attributes and subelements");
        }
    }

    private void convertResource(Resource in, final File out) throws Exception {
        if (in.isFilesystemOnly()) {
            this.html2txt.html2txt(((FileResource)in).getFile(), out);
        } else {
            IoUtil.asFile(in.getInputStream(), true, "h2t", ".html", null, new ConsumerWhichThrows<File, Exception>(){

                @Override
                public void consume(File temporaryFile) throws Exception {
                    AntTask.this.html2txt.html2txt(temporaryFile, out);
                }
            });
        }
    }
}

