/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text.scanner;

import de.unkrig.commons.io.LineUtil;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.scanner.AbstractScanner;
import de.unkrig.commons.text.scanner.DocumentScanner;
import de.unkrig.commons.text.scanner.ScanException;
import de.unkrig.commons.text.scanner.StringScanner;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;

public final class ScannerUtil {
    public static final int UNESCAPE_NUL = 1;
    public static final int UNESCAPE_DOUBLE_QUOTE = 2;
    public static final int UNESCAPE_SINGLE_QUOTE = 4;
    public static final int UNESCAPE_UNICODE = 8;
    public static final int UNESCAPE_OCTAL = 16;

    private ScannerUtil() {
    }

    public static <TT extends Enum<TT>> DocumentScanner<TT> toDocumentScanner(final StringScanner<TT> stringScanner, Reader reader) {
        final ProducerWhichThrows<String, IOException> lineProducer = LineUtil.readLineWithSeparator(reader);
        return new DocumentScanner<TT>(){
            private int lineNumber;

            @Override
            @Nullable
            public AbstractScanner.Token<TT> produce() throws ScanException {
                AbstractScanner.Token token;
                while ((token = stringScanner.produce()) == null) {
                    String line;
                    try {
                        line = (String)lineProducer.produce();
                    }
                    catch (IOException ioe) {
                        throw new ScanException(ioe);
                    }
                    if (line == null) {
                        return null;
                    }
                    ++this.lineNumber;
                    stringScanner.setInput(line);
                }
                return token;
            }

            @Override
            public int getPreviousTokenLineNumber() {
                return this.lineNumber;
            }

            @Override
            public int getPreviousTokenColumnNumber() {
                return stringScanner.getPreviousTokenOffset() + 1;
            }

            @Override
            public String toString() {
                return "Line " + this.getPreviousTokenLineNumber() + ", column " + this.getPreviousTokenColumnNumber();
            }
        };
    }

    public static <TT extends Enum<TT>> ProducerWhichThrows<AbstractScanner.Token<TT>, ScanException> scanner(StringScanner<TT> stringScanner, File file, Charset charset) throws FileNotFoundException {
        return ScannerUtil.augmentScanningLocation(ScannerUtil.toDocumentScanner(stringScanner, new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset))), file.toString());
    }

    public static <T, EX extends Throwable> ProducerWhichThrows<T, EX> augmentScanningLocation(final ProducerWhichThrows<? extends T, ? extends EX> delegate, final @Nullable String prefix) {
        return new ProducerWhichThrows<T, EX>(){

            @Override
            @Nullable
            public T produce() throws Throwable {
                return delegate.produce();
            }

            @Override
            @Nullable
            public String toString() {
                return prefix == null ? delegate.toString() : String.valueOf(prefix) + ": " + delegate.toString();
            }
        };
    }

    public static <TT extends Enum<TT>> StringScanner<TT> filter(final StringScanner<TT> delegate, final Predicate<? super AbstractScanner.Token<TT>> predicate) {
        return new StringScanner<TT>(){

            @Override
            @Nullable
            public AbstractScanner.Token<TT> produce() throws ScanException {
                AbstractScanner.Token token;
                do {
                    if ((token = delegate.produce()) != null) continue;
                    return null;
                } while (!predicate.evaluate(token));
                return token;
            }

            @Override
            public StringScanner<TT> setInput(CharSequence cs) {
                delegate.setInput(cs);
                return this;
            }

            @Override
            public int getOffset() {
                return delegate.getOffset();
            }

            @Override
            public int getPreviousTokenOffset() {
                return delegate.getPreviousTokenOffset();
            }

            @Override
            @Nullable
            public String toString() {
                return delegate.toString();
            }
        };
    }

    public static String unescape(String s, int options) throws ScanException {
        if (s.indexOf(92) == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() + 3);
        int i = 0;
        while (i < s.length()) {
            block16: {
                char c = s.charAt(i);
                if (Character.isISOControl(c)) {
                    throw new ScanException("Character " + c + " not allowed in string");
                }
                if (c != '\\') {
                    sb.append(c);
                } else {
                    try {
                        c = s.charAt(++i);
                        if (c == '0' && (options & 1) != 0) {
                            sb.append('\u0000');
                            break block16;
                        }
                        if (c == '\"' && (options & 2) != 0) {
                            sb.append('\"');
                            break block16;
                        }
                        if (c == '\'' && (options & 4) != 0) {
                            sb.append('\'');
                            break block16;
                        }
                        int idx = "\\/bfnrt".indexOf(c);
                        if (idx != -1) {
                            sb.append("\\/\b\f\n\r\t".charAt(idx));
                            break block16;
                        }
                        if (c == 'u' && (options & 8) != 0) {
                            int h = 0;
                            int j = 0;
                            while (j < 4) {
                                int nibble;
                                if ((nibble = Character.digit(c = s.charAt(++i), 16)) == -1) {
                                    throw new ScanException("'" + c + "' is not a hex digit");
                                }
                                h = (h << 4) + nibble;
                                ++j;
                            }
                            sb.append((char)h);
                            break block16;
                        }
                        if (c >= '0' && c <= '7' && (options & 0x10) != 0) {
                            int octel;
                            int o = Character.digit(c, 8);
                            if (i < s.length() - 1 && (octel = Character.digit(s.charAt(i + 1), 8)) != -1 && (o = (o << 3) + octel) <= 31 && ++i < s.length() - 1 && (octel = Character.digit(s.charAt(i + 1), 8)) != -1) {
                                o = (o << 3) + octel;
                                ++i;
                            }
                            sb.append((char)o);
                            break block16;
                        }
                        throw new ScanException("Invalid character '" + c + "' after backslash");
                    }
                    catch (IndexOutOfBoundsException ioobe) {
                        throw new ScanException("Truncated escape sequence");
                    }
                }
            }
            ++i;
        }
        return sb.toString();
    }
}

