/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.stream;

import de.unkrig.commons.lang.protocol.ProducerUtil;
import de.unkrig.commons.lang.protocol.RunnableUtil;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;

@NotNullByDefault(value=false)
public class PassiveSocketOutputStream
extends OutputStream {
    private final ServerSocket serverSocket;
    private final Map<Socket, OutputStream> connections = new HashMap<Socket, OutputStream>();
    private static final long ACCEPT_INTERVAL = 1000L;
    private static final int ACCEPT_TIMEOUT = 1;
    private static final int SO_TIMEOUT = 1000;
    private final Runnable connectionAcceptor = RunnableUtil.sparingRunnable(new Runnable(){

        @Override
        public void run() {
            PassiveSocketOutputStream.this.acceptConnections();
        }
    }, ProducerUtil.every(1000L));
    private static final int BACKLOG = 50;

    public PassiveSocketOutputStream(int port) throws IOException {
        this.serverSocket = new ServerSocket(port, 50);
        this.serverSocket.setSoTimeout(1);
        this.acceptConnections();
    }

    public PassiveSocketOutputStream(InetSocketAddress localAddress) throws IOException {
        this.serverSocket = new ServerSocket(localAddress.getPort(), 50, localAddress.getAddress());
        this.serverSocket.setSoTimeout(1);
        this.acceptConnections();
    }

    @Override
    public void write(int b) {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        this.connectionAcceptor.run();
        for (Map.Entry<Socket, OutputStream> entry : this.connections.entrySet()) {
            Socket socket = entry.getKey();
            OutputStream outputStream = entry.getValue();
            try {
                outputStream.write(b, off, len);
            }
            catch (IOException e) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.connections.remove(socket);
            }
        }
    }

    private void acceptConnections() {
        try {
            while (true) {
                Socket socket = this.serverSocket.accept();
                socket.setReuseAddress(true);
                socket.setSoTimeout(1000);
                OutputStream outputStream = socket.getOutputStream();
                this.connections.put(socket, outputStream);
            }
        }
        catch (IOException e) {
            return;
        }
    }
}

