/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.http;

import de.unkrig.commons.io.FileBufferedChannel;
import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.io.Multiplexer;
import de.unkrig.commons.lang.protocol.ConsumerUtil;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.Stoppable;
import de.unkrig.commons.net.TcpServer;
import de.unkrig.commons.net.http.HttpRequest;
import de.unkrig.commons.net.http.HttpResponse;
import de.unkrig.commons.net.http.InvalidHttpMessageException;
import de.unkrig.commons.net.http.servlett.Servlett;
import de.unkrig.commons.util.collections.IterableUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpClientConnectionHandler
implements TcpServer.ConnectionHandler,
Stoppable {
    private static final Logger LOGGER = Logger.getLogger(HttpClientConnectionHandler.class.getName());
    private Iterable<Servlett> servletts;
    private final Collection<Stoppable> stoppables = Collections.synchronizedCollection(new HashSet());

    public HttpClientConnectionHandler() {
        this.servletts = Collections.emptyList();
    }

    public HttpClientConnectionHandler(Servlett servlett) {
        this.servletts = Collections.singletonList(servlett);
    }

    public HttpClientConnectionHandler(Iterable<Servlett> servletts) {
        this.servletts = servletts;
    }

    public Iterable<Servlett> getServletts() {
        return IterableUtil.unmodifiableIterable(this.servletts);
    }

    public void setServlett(Servlett servlett) {
        this.servletts = Collections.singletonList(servlett);
    }

    public void setServletts(Iterable<Servlett> servletts) {
        this.servletts = servletts;
    }

    @Override
    public void handleConnection(InputStream in, OutputStream out, InetSocketAddress localSocketAddress, InetSocketAddress remoteSocketAddress, Stoppable stoppable) throws IOException, InvalidHttpMessageException {
        this.processRequests(in, out, stoppable);
    }

    public void handleConnection(ReadableByteChannel in, WritableByteChannel out, InetSocketAddress localSocketAddress, InetSocketAddress remoteSocketAddress, Multiplexer multiplexer, Stoppable stoppable) throws IOException {
        this.processRequests(in, out, multiplexer, stoppable);
    }

    /*
     * Unable to fully structure code
     */
    protected void processRequests(InputStream in, OutputStream out, Stoppable stoppable) throws IOException, InvalidHttpMessageException {
        block15: {
            try {
                block14: {
                    requestSize = null;
                    responseSize = null;
                    if (HttpClientConnectionHandler.LOGGER.isLoggable(Level.INFO)) {
                        requestSize = ConsumerUtil.store();
                        responseSize = ConsumerUtil.store();
                        out = IoUtil.tee(new OutputStream[]{out, IoUtil.lengthWritten(ConsumerUtil.cumulate(responseSize, 0L))});
                        in = IoUtil.wye(in, IoUtil.lengthWritten(ConsumerUtil.cumulate(requestSize, 0L)));
                    }
                    this.stoppables.add(stoppable);
                    HttpClientConnectionHandler.LOGGER.fine("Reading request from client");
                    request = HttpRequest.read(in);
                    for (Servlett servlett : this.servletts) {
                        httpResponse = servlett.handleRequest(request, new ConsumerWhichThrows<HttpResponse, IOException>(finalOut = out, hadProvisionalResponses = new boolean[1]){
                            private final /* synthetic */ OutputStream val$finalOut;
                            private final /* synthetic */ boolean[] val$hadProvisionalResponses;
                            {
                                this.val$finalOut = outputStream;
                                this.val$hadProvisionalResponses = blArray;
                            }

                            @Override
                            public void consume(HttpResponse provisionalResponse) throws IOException {
                                if (!$assertionsDisabled && !provisionalResponse.isProvisional()) {
                                    throw new AssertionError();
                                }
                                provisionalResponse.write(this.val$finalOut);
                                this.val$hadProvisionalResponses[0] = true;
                            }
                        });
                        if (httpResponse == null) {
                            if (!HttpClientConnectionHandler.$assertionsDisabled && hadProvisionalResponses[0]) {
                                throw new AssertionError((Object)("Servlett \"" + servlett + "\" sent provisional responses, but returned NULL"));
                            }
                            continue;
                        }
                        break block14;
                    }
                    httpResponse = HttpResponse.response(HttpResponse.Status.INTERNAL_SERVER_ERROR, "None of " + this.servletts + " handled the request");
                }
                if (!HttpClientConnectionHandler.$assertionsDisabled && httpResponse == null) {
                    throw new AssertionError();
                }
                HttpClientConnectionHandler.LOGGER.fine("Sending response to client");
                httpResponse.write(out);
                request.removeBody().dispose();
                if (requestSize == null) ** break block16
                if (responseSize != null) {
                    HttpClientConnectionHandler.LOGGER.info((Object)request.getMethod() + " " + request.getUri() + " => " + (Object)httpResponse.getStatus() + " (" + requestSize.produce() + "/" + responseSize.produce() + " bytes)");
                }
                break block17;
            }
            finally {
                this.stoppables.remove(stoppable);
                if (!this.stoppables.isEmpty()) break block15;
                var14_14 = this.servletts.iterator();
                if (true) ** GOTO lbl49
            }
            {
                block17: {
                }
            }
            do {
                servlett = var14_14.next();
                try {
                    servlett.close();
                }
                catch (IOException var15_18) {
                    // empty catch block
                }
lbl49:
                // 3 sources

            } while (var14_14.hasNext());
        }
    }

    private void processRequests(ReadableByteChannel in, WritableByteChannel out, Multiplexer multiplexer, Stoppable stoppable) throws IOException {
        this.stoppables.add(stoppable);
        final FileBufferedChannel fbc = new FileBufferedChannel(multiplexer, (SelectableChannel)((Object)out));
        ConsumerWhichThrows<HttpRequest, IOException> requestConsumer = new ConsumerWhichThrows<HttpRequest, IOException>(){

            @Override
            public void consume(HttpRequest request) throws IOException {
                HttpResponse response;
                block4: {
                    for (Servlett servlett : HttpClientConnectionHandler.this.servletts) {
                        boolean[] hadProvisionalResponses;
                        response = servlett.handleRequest(request, new ConsumerWhichThrows<HttpResponse, IOException>(hadProvisionalResponses = new boolean[1]){
                            private final /* synthetic */ boolean[] val$hadProvisionalResponses;
                            {
                                this.val$hadProvisionalResponses = blArray;
                            }

                            @Override
                            public void consume(HttpResponse provisionalResponse) throws IOException {
                                if (!$assertionsDisabled && !provisionalResponse.isProvisional()) {
                                    throw new AssertionError();
                                }
                                provisionalResponse.write(Channels.newOutputStream(fbc));
                                this.val$hadProvisionalResponses[0] = true;
                            }
                        });
                        if (response == null) {
                            if (!$assertionsDisabled && hadProvisionalResponses[0]) {
                                throw new AssertionError((Object)("Servlett \"" + servlett + "\" sent provisional responses, but returned NULL"));
                            }
                            continue;
                        }
                        break block4;
                    }
                    response = HttpResponse.response(HttpResponse.Status.INTERNAL_SERVER_ERROR, "None of " + HttpClientConnectionHandler.this.servletts + " handled the request");
                }
                request.removeBody().dispose();
                LOGGER.fine("Sending response to client");
                if (!$assertionsDisabled && response == null) {
                    throw new AssertionError();
                }
                response.write(Channels.newOutputStream(fbc));
            }
        };
        HttpRequest.read(in, multiplexer, requestConsumer);
    }

    @Override
    public void stop() {
        for (Stoppable stoppable : this.stoppables) {
            stoppable.stop();
        }
    }
}

