/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net;

import de.unkrig.commons.io.HexOutputStream;
import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.util.logging.LogUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class TcpClient
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger(TcpClient.class.getName());
    private final Socket socket;
    private final InputStream fromServer;
    private final OutputStream toServer;

    public TcpClient(String host, int port) throws IOException {
        this(InetAddress.getByName(host), port);
    }

    public TcpClient(InetAddress address, int port) throws IOException {
        this.socket = new Socket(address, port);
        LOGGER.fine("Connected to " + this.socket.getRemoteSocketAddress());
        InputStream in = this.socket.getInputStream();
        OutputStream out = this.socket.getOutputStream();
        boolean logData = LOGGER.isLoggable(Level.FINEST);
        this.fromServer = logData ? IoUtil.wye(in, new HexOutputStream(LogUtil.logWriter(LOGGER, Level.FINEST, "<From Server< "))) : in;
        this.toServer = logData ? IoUtil.tee(out, new HexOutputStream(LogUtil.logWriter(LOGGER, Level.FINEST, ">To   Server> "))) : out;
    }

    public InputStream getInputStream() {
        return this.fromServer;
    }

    public OutputStream getOutputStream() {
        return this.toServer;
    }

    @Override
    public void close() throws IOException {
        LOGGER.fine("Closing connection to " + this.socket.getRemoteSocketAddress());
        this.socket.close();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.socket.getRemoteSocketAddress();
    }
}

