/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang;

import de.unkrig.commons.nullanalysis.Nullable;
import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.util.Formatter;

public final class PrettyPrinter {
    public static final int ARRAY_ELLIPSIS = 10;
    public static final int CHAR_ARRAY_ELLIPSIS = 20;
    public static final int CHAR_SEQUENCE_ELLIPSIS = 100;
    public static final int TOTAL_LENGTH_ELLIPSIS = 1024;

    private PrettyPrinter() {
    }

    @Nullable
    public static String toString(@Nullable Object o) {
        if (o == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        return PrettyPrinter.append(o, sb).toString();
    }

    private static StringBuilder append(@Nullable Object o, StringBuilder sb) {
        if (o == null) {
            return sb.append("null");
        }
        Class<?> clasS = o.getClass();
        if (clasS.isArray()) {
            return PrettyPrinter.appendArray(o, null, sb);
        }
        if (o instanceof CharSequence) {
            return PrettyPrinter.append((CharSequence)o, sb);
        }
        if (clasS == Character.class) {
            return PrettyPrinter.append(((Character)o).charValue(), sb);
        }
        if (clasS == Byte.class) {
            return sb.append(((Byte)o).toString()).append('B');
        }
        if (clasS == Short.class) {
            return sb.append(((Short)o).toString()).append('S');
        }
        if (clasS == Long.class) {
            return sb.append(((Long)o).toString()).append('L');
        }
        if (clasS == Float.class) {
            return sb.append(new DecimalFormat().format(((Float)o).floatValue())).append('F');
        }
        if (clasS == Double.class) {
            return sb.append(new DecimalFormat().format((Double)o)).append('D');
        }
        return sb.append(o);
    }

    private static StringBuilder appendArray(Object o, @Nullable Object[][] dejaVu, StringBuilder sb) {
        int length = Array.getLength(o);
        String canonicalName = PrettyPrinter.getPrettyClassName(o);
        int idx = canonicalName.indexOf(93);
        if (idx == -1) {
            throw new IllegalArgumentException(canonicalName);
        }
        sb.append(canonicalName.substring(0, idx)).append(length).append(canonicalName.substring(idx));
        if (length == 0) {
            return sb;
        }
        if (o.getClass().getComponentType() == Character.TYPE) {
            sb.append(" '");
            char[] ca = (char[])o;
            int i = 0;
            while (i < length) {
                if (i >= 20 || sb.length() >= 1024) {
                    return sb.append("'...");
                }
                PrettyPrinter.appendChar(ca[i], sb);
                ++i;
            }
            return sb.append('\'');
        }
        sb.append(" { ");
        int i = 0;
        while (true) {
            block15: {
                Object element;
                if ((element = Array.get(o, i)) instanceof Object[]) {
                    if (element == o) {
                        sb.append("[self]");
                    } else if (dejaVu == null) {
                        PrettyPrinter.appendArray(element, new Object[][]{(Object[])o}, sb);
                    } else {
                        Object[][] objectArray = dejaVu;
                        int n = dejaVu.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object[] other = objectArray[n2];
                            if (element == other) {
                                sb.append("[parent]");
                                break block15;
                            }
                            ++n2;
                        }
                        Object[][] tmp = new Object[dejaVu.length + 1][];
                        System.arraycopy(dejaVu, 0, tmp, 0, dejaVu.length);
                        tmp[dejaVu.length] = (Object[])o;
                        PrettyPrinter.appendArray(element, tmp, sb);
                    }
                } else {
                    PrettyPrinter.append(element, sb);
                }
            }
            if (++i == length) break;
            if (i >= 10 || sb.length() >= 1024) {
                return sb.append(", ... }");
            }
            sb.append(", ");
        }
        return sb.append(" }");
    }

    private static String getPrettyClassName(Object o) {
        String result = o.getClass().getCanonicalName();
        if (result.startsWith("java.")) {
            result = result.substring(result.lastIndexOf(46) + 1);
        }
        return result;
    }

    private static StringBuilder append(CharSequence cs, StringBuilder sb) {
        if (cs instanceof String) {
            sb.append('\"');
        } else {
            sb.append(PrettyPrinter.getPrettyClassName(cs)).append(" \"");
        }
        int length = cs.length();
        int i = 0;
        while (i < length) {
            if (i >= 100 || sb.length() >= 1024) {
                return sb.append("\"... (").append(length).append(" chars)");
            }
            PrettyPrinter.appendChar(cs.charAt(i), sb);
            ++i;
        }
        return sb.append('\"');
    }

    private static StringBuilder append(char c, StringBuilder sb) {
        sb.append('\'');
        return PrettyPrinter.appendChar(c, sb).append('\'');
    }

    private static StringBuilder appendChar(char c, StringBuilder sb) {
        int idx = "\b\t\n\f\r\"'\\".indexOf(c);
        if (idx != -1) {
            return sb.append('\\').append("btnfr\"'\\".charAt(idx));
        }
        if (c < ' ') {
            return sb.append('\\').append(Integer.toOctalString(c));
        }
        if (c <= '\u00ff') {
            return sb.append(c);
        }
        new Formatter(sb).format("\\u%04x", c);
        return sb;
    }
}

