/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.junit4;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.AbstractPrinter;
import de.unkrig.commons.text.Printer;
import de.unkrig.commons.text.Printers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;

public final class AssertPrinters {
    static {
        AssertionUtil.enableAssertionsForThisClass();
    }

    private AssertPrinters() {
    }

    public static <EX extends Exception> void assertMessages(RunnableWhichThrows<EX> runnable, String ... expectedMessages) throws EX {
        AssertPrinters.assertEquals(Arrays.asList(expectedMessages), AssertPrinters.recordMessages(runnable));
    }

    public static <EX extends Exception> void assertContainsMessages(RunnableWhichThrows<EX> runnable, String ... expectedMessages) throws EX {
        AssertPrinters.assertContainsAll(Arrays.asList(expectedMessages), AssertPrinters.recordMessages(runnable));
    }

    private static <EX extends Exception> List<String> recordMessages(RunnableWhichThrows<EX> runnable) throws EX {
        final ArrayList<String> result = new ArrayList<String>();
        AbstractPrinter recorder = new AbstractPrinter(){

            @Override
            public void error(@Nullable String message) {
                result.add("E: " + message);
            }

            @Override
            public void warn(@Nullable String message) {
                result.add("W: " + message);
            }

            @Override
            public void info(@Nullable String message) {
                result.add("I: " + message);
            }

            @Override
            public void verbose(@Nullable String message) {
                result.add("V: " + message);
            }

            @Override
            public void debug(@Nullable String message) {
                result.add("D: " + message);
            }
        };
        Printers.withPrinter((Printer)recorder, runnable);
        return result;
    }

    public static void assertEquals(List<?> expected, List<?> actual) {
        AssertPrinters.assertEquals(null, expected, actual);
    }

    public static void assertEquals(@Nullable String message, List<?> expected, List<?> actual) {
        int i = 0;
        while (i < expected.size() && i < actual.size()) {
            TestCase.assertEquals((String)(message == null ? "[" + i + "]" : String.valueOf(message) + " [" + i + "]"), expected.get(i), actual.get(i));
            ++i;
        }
        if (expected.size() != actual.size()) {
            TestCase.fail((String)("expected " + expected.size() + " element(s), but was " + actual.size() + " element(s)"));
        }
    }

    public static void assertContainsAll(Collection<?> expected, Collection<?> actual) {
        AssertPrinters.assertContainsAll(null, expected, actual);
    }

    public static void assertContainsAll(@Nullable String message, Collection<?> expected, Collection<?> actual) {
        for (Object e : expected) {
            if (actual.contains(e)) continue;
            String m = "\"" + e + "\" is missing from " + actual;
            TestCase.fail((String)(message == null ? m : String.valueOf(message) + ": " + m));
        }
    }
}

