/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.nullanalysis.NotNullByDefault;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.MalformedInputException;

@NotNullByDefault(value=false)
public class PercentEncodingInputStream
extends FilterInputStream {
    public PercentEncodingInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        int b = this.in.read();
        if (b != 37) {
            return b;
        }
        int hex1 = Character.digit(this.in.read(), 16);
        if (hex1 == -1) {
            throw new MalformedInputException(2);
        }
        int hex2 = Character.digit(this.in.read(), 16);
        if (hex2 == -1) {
            throw new MalformedInputException(3);
        }
        return (hex1 << 4) + hex2;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (off < 0 || off > buf.length) {
            throw new IndexOutOfBoundsException("off");
        }
        if (len < 0 || len > buf.length - off) {
            throw new IndexOutOfBoundsException("len");
        }
        if (len == 0) {
            return 0;
        }
        int b = this.read();
        if (b == -1) {
            return -1;
        }
        buf[off] = (byte)b;
        int i = 1;
        while (i < len) {
            try {
                b = this.read();
            }
            catch (IOException ioe) {
                return i;
            }
            if (b == -1) {
                return i;
            }
            buf[off + i] = (byte)b;
            ++i;
        }
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        int count;
        if (n <= 0L) {
            return 0L;
        }
        byte[] buf = new byte[4096];
        long remaining = n;
        do {
            if ((count = this.read(buf, 0, (int)Math.min((long)buf.length, remaining))) != -1) continue;
            return n - remaining;
        } while ((remaining -= (long)count) != 0L);
        return n;
    }

    @Override
    public int available() {
        return 0;
    }
}

