/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.org.apache.commons.compress.compressors.lzma;

import de.unkrig.commons.file.org.apache.commons.compress.compressors.CompressionFormat;
import de.unkrig.commons.util.collections.MapUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.FileNameUtil;
import org.apache.commons.compress.compressors.lzma.LZMACompressorInputStream;

public final class LZMACompressionFormat
implements CompressionFormat {
    private static final FileNameUtil FILE_NAME_UTIL = new FileNameUtil(MapUtil.map(".lzma", "", ".tlz", ".tar"), ".lzma");
    private static final CompressionFormat INSTANCE = new LZMACompressionFormat();

    private LZMACompressionFormat() {
    }

    public static CompressionFormat get() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return "lzma";
    }

    @Override
    public boolean isCompressedFileName(String fileName) {
        return FILE_NAME_UTIL.isCompressedFilename(fileName);
    }

    @Override
    public String getCompressedFileName(String fileName) {
        return FILE_NAME_UTIL.getCompressedFilename(fileName);
    }

    @Override
    public String getUncompressedFileName(String fileName) {
        return FILE_NAME_UTIL.getUncompressedFilename(fileName);
    }

    @Override
    public CompressorInputStream compressorInputStream(InputStream is) throws IOException {
        return new LZMACompressorInputStream(is);
    }

    @Override
    public CompressorInputStream open(File compressedFile) throws IOException {
        FileInputStream is = new FileInputStream(compressedFile);
        try {
            return new LZMACompressorInputStream((InputStream)is);
        }
        catch (IOException ioe) {
            try {
                ((InputStream)is).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ioe;
        }
    }

    @Override
    public CompressorOutputStream compressorOutputStream(OutputStream os) throws CompressorException {
        throw new CompressorException("Creation of 'lzma' compressed contents is not supported");
    }

    @Override
    public CompressorOutputStream create(File compressedFile) throws CompressorException {
        throw new CompressorException("Creation of 'lzma' compressed contents is not supported");
    }

    @Override
    public boolean matches(byte[] signature, int signatureLength) {
        return false;
    }

    public String toString() {
        return this.getName();
    }
}

