/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.org.apache.commons.compress.archivers.sevenz;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;

class SevenZArchiveOutputStream
extends ArchiveOutputStream {
    private final SevenZOutputFile szof;

    static {
        AssertionUtil.enableAssertionsForThisClass();
    }

    SevenZArchiveOutputStream(SevenZOutputFile szof) {
        this.szof = szof;
    }

    public void putArchiveEntry(@Nullable ArchiveEntry ae) throws IOException {
        this.szof.putArchiveEntry(ae);
    }

    public void write(int b) throws IOException {
        this.szof.write(b);
    }

    public void write(@Nullable byte[] b, int off, int len) throws IOException {
        this.szof.write(b, off, len);
    }

    public void closeArchiveEntry() throws IOException {
        this.szof.closeArchiveEntry();
    }

    public void finish() throws IOException {
        this.szof.finish();
    }

    public void close() throws IOException {
        this.szof.close();
    }

    public ArchiveEntry createArchiveEntry(@Nullable File inputFile, @Nullable String entryName) {
        assert (inputFile != null);
        assert (entryName != null);
        SevenZArchiveEntry szae = new SevenZArchiveEntry();
        szae.setCreationDate(new Date(inputFile.lastModified()));
        szae.setHasCreationDate(true);
        szae.setName(entryName);
        return szae;
    }
}

