/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.contentsprocessing;

import de.unkrig.commons.file.CompressUtil;
import de.unkrig.commons.file.ExceptionHandler;
import de.unkrig.commons.file.contentsprocessing.ContentsProcessor;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormat;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormatFactory;
import de.unkrig.commons.file.org.apache.commons.compress.compressors.CompressionFormat;
import de.unkrig.commons.file.org.apache.commons.compress.compressors.CompressionFormatFactory;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.protocol.HardReference;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.compressors.CompressorInputStream;

public final class ContentsProcessings {
    private static final ContentsProcessor<?> NOP_CONTENTS_PROCESSOR;
    private static final ArchiveCombiner<?> NOP_ARCHIVE_COMBINER;

    static {
        AssertionUtil.enableAssertionsForThisClass();
        NOP_CONTENTS_PROCESSOR = new ContentsProcessor<Object>(){

            @Override
            @Nullable
            public Object process(String path, InputStream inputStream, long size, long crc32, ProducerWhichThrows<? extends InputStream, ? extends IOException> opener) {
                return null;
            }
        };
        NOP_ARCHIVE_COMBINER = new ArchiveCombiner<Object>(){

            @Override
            @Nullable
            public Object combine(String archivePath, List<Object> combinables) {
                return null;
            }
        };
    }

    private ContentsProcessings() {
    }

    public static <T> ContentsProcessor<T> nopContentsProcessor() {
        return NOP_CONTENTS_PROCESSOR;
    }

    public static <T> ArchiveCombiner<T> nopArchiveCombiner() {
        return NOP_ARCHIVE_COMBINER;
    }

    @Nullable
    public static <T> T processArchive(String archivePath, ArchiveInputStream archiveInputStream, ContentsProcessor<T> contentsProcessor, ArchiveCombiner<T> entryCombiner, final ProducerWhichThrows<? extends ArchiveInputStream, ? extends IOException> archiveOpener, ExceptionHandler<IOException> exceptionHandler) throws IOException {
        ArrayList<T> combinables = new ArrayList<T>();
        ArchiveEntry ae = archiveInputStream.getNextEntry();
        while (ae != null) {
            final String entryName = ArchiveFormatFactory.normalizeEntryName(ae.getName());
            final String entryPath = String.valueOf(archivePath) + '!' + entryName;
            try {
                ProducerWhichThrows<InputStream, IOException> opener = new ProducerWhichThrows<InputStream, IOException>(){

                    @Override
                    @Nullable
                    public InputStream produce() throws IOException {
                        ArchiveInputStream ais = AssertionUtil.notNull((ArchiveInputStream)archiveOpener.produce());
                        ArchiveEntry ae2 = ais.getNextEntry();
                        while (ae2 != null) {
                            String name2 = ArchiveFormatFactory.normalizeEntryName(ae2.getName());
                            if (name2.equals(entryName)) {
                                return ais;
                            }
                            ae2 = ais.getNextEntry();
                        }
                        ais.close();
                        throw new IOException(entryPath);
                    }
                };
                long crc32 = ArchiveFormatFactory.getEntryCrc32(ae);
                combinables.add(contentsProcessor.process(entryPath, (InputStream)archiveInputStream, ae.getSize(), crc32, opener));
            }
            catch (IOException ioe) {
                exceptionHandler.handle(entryPath, ioe);
            }
            catch (RuntimeException re) {
                exceptionHandler.handle(entryPath, re);
            }
            ae = archiveInputStream.getNextEntry();
        }
        return entryCombiner.combine(archivePath, combinables);
    }

    public static <T> ContentsProcessor<T> compressedAndArchiveContentsProcessor(final Predicate<? super String> lookIntoFormat, final ContentsProcessor<T> archiveContentsProcessor, final ArchiveCombiner<T> archiveEntryCombiner, final ContentsProcessor<T> compressedContentsProcessor, final ContentsProcessor<T> normalContentsProcessor, final ExceptionHandler<IOException> exceptionHandler) {
        return new ContentsProcessor<T>(){

            @Override
            @Nullable
            public T process(String path, InputStream inputStream, long size, long crc32, ProducerWhichThrows<? extends InputStream, ? extends IOException> opener) throws IOException {
                return CompressUtil.processStream(path, inputStream, lookIntoFormat, ContentsProcessings.archiveHandler(path, archiveContentsProcessor, archiveEntryCombiner, opener, exceptionHandler), ContentsProcessings.compressorHandler(path, compressedContentsProcessor, opener), ContentsProcessings.normalContentsHandler(path, normalContentsProcessor, size, crc32, opener));
            }

            public String toString() {
                return "compressedAndArchiveContentsProcessor";
            }
        };
    }

    public static <T> ContentsProcessor<T> recursiveCompressedAndArchiveContentsProcessor(Predicate<? super String> lookIntoFormat, ArchiveCombiner<T> archiveEntryCombiner, ContentsProcessor<T> normalContentsProcessor, ExceptionHandler<IOException> exceptionHandler) {
        final HardReference<ContentsProcessor<T>> loopback = new HardReference<ContentsProcessor<T>>();
        ContentsProcessor tmp = new ContentsProcessor<T>(){

            @Override
            @Nullable
            public T process(String name, InputStream inputStream, long size, long crc32, ProducerWhichThrows<? extends InputStream, ? extends IOException> opener) throws IOException {
                ContentsProcessor l = (ContentsProcessor)loopback.get();
                if (!$assertionsDisabled && l == null) {
                    throw new AssertionError();
                }
                return l.process(name, inputStream, size, crc32, opener);
            }
        };
        ContentsProcessor<T> result = ContentsProcessings.compressedAndArchiveContentsProcessor(lookIntoFormat, tmp, archiveEntryCombiner, tmp, normalContentsProcessor, exceptionHandler);
        loopback.set(result);
        return result;
    }

    public static <T> CompressUtil.ArchiveHandler<T> archiveHandler(final String path, final ContentsProcessor<T> contentsProcessor, final ArchiveCombiner<T> archiveEntryCombiner, final ProducerWhichThrows<? extends InputStream, ? extends IOException> opener, final ExceptionHandler<IOException> exceptionHandler) {
        return new CompressUtil.ArchiveHandler<T>(){

            @Override
            @Nullable
            public T handleArchive(ArchiveInputStream archiveInputStream, final ArchiveFormat archiveFormat) throws IOException {
                return ContentsProcessings.processArchive(path, archiveInputStream, contentsProcessor, archiveEntryCombiner, (ProducerWhichThrows<? extends ArchiveInputStream, ? extends IOException>)new ProducerWhichThrows<ArchiveInputStream, IOException>(){

                    @Override
                    @Nullable
                    public ArchiveInputStream produce() throws IOException {
                        try {
                            InputStream is = (InputStream)opener.produce();
                            if (!$assertionsDisabled && is == null) {
                                throw new AssertionError();
                            }
                            return archiveFormat.archiveInputStream(is);
                        }
                        catch (ArchiveException ae) {
                            throw ExceptionUtil.wrap(null, ae, IOException.class);
                        }
                    }
                }, exceptionHandler);
            }
        };
    }

    public static <T> CompressUtil.CompressorHandler<T> compressorHandler(final String path, final ContentsProcessor<T> contentsProcessor, final ProducerWhichThrows<? extends InputStream, ? extends IOException> opener) {
        return new CompressUtil.CompressorHandler<T>(){

            @Override
            @Nullable
            public T handleCompressor(CompressorInputStream compressorInputStream, final CompressionFormat compressionFormat) throws IOException {
                long size = CompressionFormatFactory.getUncompressedSize(compressorInputStream);
                return contentsProcessor.process(String.valueOf(path) + '!', (InputStream)compressorInputStream, size, -1L, (ProducerWhichThrows<InputStream, IOException>)new ProducerWhichThrows<InputStream, IOException>(){

                    @Override
                    @Nullable
                    public InputStream produce() throws IOException {
                        return compressionFormat.compressorInputStream(AssertionUtil.notNull((InputStream)opener.produce()));
                    }
                });
            }
        };
    }

    public static <T> CompressUtil.NormalContentsHandler<T> normalContentsHandler(final String path, final ContentsProcessor<T> contentsProcessor, final long size, final long crc32, final ProducerWhichThrows<? extends InputStream, ? extends IOException> opener) {
        return new CompressUtil.NormalContentsHandler<T>(){

            @Override
            @Nullable
            public T handleNormalContents(InputStream inputStream) throws IOException {
                return contentsProcessor.process(path, inputStream, size, crc32, opener);
            }
        };
    }

    public static interface ArchiveCombiner<T> {
        @Nullable
        public T combine(String var1, List<T> var2);
    }
}

