/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file;

import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormat;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormatFactory;
import de.unkrig.commons.file.org.apache.commons.compress.compressors.CompressionFormat;
import de.unkrig.commons.file.org.apache.commons.compress.compressors.CompressionFormatFactory;
import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.io.MarkableFileInputStream;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.compressors.CompressorInputStream;

public final class CompressUtil {
    private static final Logger LOGGER;

    static {
        AssertionUtil.enableAssertionsForThisClass();
        LOGGER = Logger.getLogger(CompressUtil.class.getName());
    }

    private CompressUtil() {
    }

    @Nullable
    public static <T> T processStream(String path, InputStream inputStream, Predicate<? super String> lookIntoFormat, ArchiveHandler<? extends T> archiveHandler, CompressorHandler<? extends T> compressorHandler, NormalContentsHandler<? extends T> normalContentsHandler) throws IOException {
        return CompressUtil.processStream(inputStream, CompressUtil.lookIntoArchive(path, lookIntoFormat), archiveHandler, CompressUtil.lookIntoCompressed(path, lookIntoFormat), compressorHandler, normalContentsHandler);
    }

    @Nullable
    public static <T> T processStream(InputStream inputStream, Predicate<? super ArchiveFormat> lookIntoArchive, ArchiveHandler<? extends T> archiveHandler, Predicate<? super CompressionFormat> lookIntoCompressed, CompressorHandler<? extends T> compressorHandler, NormalContentsHandler<? extends T> normalContentsHandler) throws IOException {
        ArchiveFormat archiveFormat;
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if ((archiveFormat = ArchiveFormatFactory.forContents(inputStream)) != null) {
            ArchiveInputStream ais;
            if (!lookIntoArchive.evaluate(archiveFormat)) {
                return normalContentsHandler.handleNormalContents(inputStream);
            }
            try {
                ais = archiveFormat.archiveInputStream(IoUtil.unclosableInputStream(inputStream));
            }
            catch (ArchiveException ae) {
                throw new IOException(archiveFormat.getName(), ae);
            }
            return archiveHandler.handleArchive(ais, archiveFormat);
        }
        CompressionFormat compressionFormat = CompressionFormatFactory.forContents(inputStream);
        if (compressionFormat != null) {
            if (!lookIntoCompressed.evaluate(compressionFormat)) {
                return normalContentsHandler.handleNormalContents(inputStream);
            }
            return compressorHandler.handleCompressor(compressionFormat.compressorInputStream(IoUtil.unclosableInputStream(inputStream)), compressionFormat);
        }
        return normalContentsHandler.handleNormalContents(inputStream);
    }

    @Nullable
    public static <T> T processFile(String path, File file, Predicate<? super String> lookIntoFormat, ArchiveHandler<? extends T> archiveHandler, CompressorHandler<? extends T> compressorHandler, NormalContentsHandler<? extends T> normalContentsHandler) throws IOException {
        return CompressUtil.processFile(file, CompressUtil.lookIntoArchive(path, lookIntoFormat), archiveHandler, CompressUtil.lookIntoCompressed(path, lookIntoFormat), compressorHandler, normalContentsHandler);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static <T> T processFile(File file, Predicate<? super ArchiveFormat> lookIntoArchive, ArchiveHandler<? extends T> archiveHandler, Predicate<? super CompressionFormat> lookIntoCompressed, CompressorHandler<? extends T> compressorHandler, NormalContentsHandler<? extends T> normalContentsHandler) throws IOException {
        MarkableFileInputStream is = new MarkableFileInputStream(file);
        try {
            ArchiveFormat archiveFormat = ArchiveFormatFactory.forContents(is);
            if (archiveFormat != null) {
                if (!lookIntoArchive.evaluate(archiveFormat)) {
                    T t = normalContentsHandler.handleNormalContents(is);
                    return t;
                }
                ((InputStream)is).close();
                ArchiveInputStream ais = archiveFormat.open(file);
                is = ais;
                T result = archiveHandler.handleArchive(ais, archiveFormat);
                ais.close();
                T t = result;
                return t;
            }
            CompressionFormat compressionFormat = CompressionFormatFactory.forContents(is);
            if (compressionFormat != null) {
                if (!lookIntoCompressed.evaluate(compressionFormat)) {
                    T t = normalContentsHandler.handleNormalContents(is);
                    return t;
                }
                CompressorInputStream cis = compressionFormat.compressorInputStream(is);
                T result = compressorHandler.handleCompressor(cis, compressionFormat);
                cis.close();
                T t = result;
                return t;
            }
            LOGGER.log(Level.FINER, "Processing normal file \"{0}\"", file);
            T result = normalContentsHandler.handleNormalContents(is);
            ((InputStream)is).close();
            T t = result;
            return t;
        }
        catch (ArchiveException ae) {
            throw ExceptionUtil.wrap(file.toString(), ae, IOException.class);
        }
        catch (IOException ioe) {
            throw ExceptionUtil.wrap(file.toString(), ioe);
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (Exception exception) {}
        }
    }

    private static Predicate<ArchiveFormat> lookIntoArchive(final String path, final Predicate<? super String> lookIntoFormat) {
        return new Predicate<ArchiveFormat>(){

            @Override
            public boolean evaluate(ArchiveFormat af) {
                boolean result = lookIntoFormat.evaluate(String.valueOf(af.getName()) + ':' + path);
                LOGGER.log(Level.FINER, "Look into archive \"{0}\"? => {1}", new Object[]{path, result});
                return result;
            }
        };
    }

    private static Predicate<CompressionFormat> lookIntoCompressed(final String path, final Predicate<? super String> lookIntoFormat) {
        return new Predicate<CompressionFormat>(){

            @Override
            public boolean evaluate(CompressionFormat cf) {
                boolean result = lookIntoFormat.evaluate(String.valueOf(cf.getName()) + ':' + path);
                LOGGER.log(Level.FINER, "Look into compressed \"{0}\"? => {1}", new Object[]{path, result});
                return result;
            }
        };
    }

    public static interface ArchiveHandler<T> {
        @Nullable
        public T handleArchive(ArchiveInputStream var1, ArchiveFormat var2) throws IOException;
    }

    public static interface CompressorHandler<T> {
        @Nullable
        public T handleCompressor(CompressorInputStream var1, CompressionFormat var2) throws IOException;
    }

    public static interface NormalContentsHandler<T> {
        @Nullable
        public T handleNormalContents(InputStream var1) throws IOException;
    }
}

