/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.doclet.main;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import de.unkrig.commons.doclet.Annotations;
import de.unkrig.commons.doclet.Tags;
import de.unkrig.commons.doclet.html.Html;
import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.Longjump;
import de.unkrig.commons.lang.protocol.ProducerUtil;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.Notations;
import de.unkrig.commons.util.CommandLineOptions;
import de.unkrig.commons.util.annotation.CommandLineOption;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public final class MainDoclet {
    private static File destination;
    private static String method;
    private static Charset docEncoding;
    @Nullable
    private static String charset;
    @Nullable
    private static String doctitle;
    private static boolean quiet;

    @CommandLineOption(name={"-d", "--destination"})
    public static void setDestination(File destDir) {
        destination = destDir;
    }

    @CommandLineOption
    public static void setMethod(String method) {
        MainDoclet.method = method;
    }

    @CommandLineOption
    public static void setDocencoding(Charset charset) {
        docEncoding = charset;
    }

    @CommandLineOption
    public static void setCharset(String name) {
        charset = name;
    }

    @CommandLineOption
    public static void setDoctitle(String title) {
        doctitle = title;
    }

    @CommandLineOption
    public static void setQuiet() {
        quiet = true;
    }

    @CommandLineOption
    public static void setBottom(String text) {
    }

    @CommandLineOption
    public static void addLink(String extDocUrl) {
    }

    @CommandLineOption
    public static void addLinkoffline(String extDocUrl, String packageListLoc) {
    }

    @CommandLineOption
    public static void setWindowtitle(String title) {
    }

    private MainDoclet() {
    }

    public static LanguageVersion languageVersion() {
        return LanguageVersion.JAVA_1_5;
    }

    public static int optionLength(String option) throws IOException {
        if ("-help".equals(option)) {
            CommandLineOptions.printResource(MainDoclet.class, (String)"start(RootDoc).txt", (Charset)Charset.forName("UTF-8"), (OutputStream)System.out);
            return 1;
        }
        Method m = CommandLineOptions.getMethodForOption((String)option, MainDoclet.class);
        return m == null ? 0 : 1 + m.getParameterTypes().length;
    }

    public static boolean start(RootDoc rootDoc) throws IOException {
        for (String[] option : rootDoc.options()) {
            int res;
            Method m = CommandLineOptions.getMethodForOption((String)option[0], MainDoclet.class);
            if (m == null) continue;
            try {
                res = CommandLineOptions.applyCommandLineOption((String)option[0], (Method)m, (String[])option, (int)1, null);
            }
            catch (Exception e) {
                throw (IOException)ExceptionUtil.wrap((String)("Parsing command line option \"" + option[0] + "\""), (Throwable)e, IOException.class);
            }
            assert (res == option.length);
        }
        ArrayList<ClassDoc> allClasses = new ArrayList<ClassDoc>();
        allClasses.addAll(Arrays.asList(rootDoc.specifiedClasses()));
        for (PackageDoc pd : rootDoc.specifiedPackages()) {
            allClasses.addAll(Arrays.asList(pd.allClasses()));
        }
        if (allClasses.isEmpty()) {
            System.err.println("No classes specified.");
            throw new IOException();
        }
        for (ClassDoc cd : allClasses) {
            for (MethodDoc md : cd.methods()) {
                String tmp = md.name() + md.flatSignature();
                if (!method.equals(tmp)) continue;
                MainDoclet.convertDoc((Doc)md, destination, docEncoding, rootDoc);
            }
        }
        return true;
    }

    private static void convertDoc(Doc doc, File destination, Charset charset, RootDoc rootDoc) throws IOException {
        String htmlText;
        final ClassDoc cd = doc.isClass() ? (ClassDoc)doc : (doc instanceof MemberDoc ? ((MemberDoc)doc).containingClass() : (ClassDoc)ExceptionUtil.throW((Throwable)((Object)new AssertionError((Object)String.valueOf(doc)))));
        Html html = new Html(Html.STANDARD_LINK_MAKER){

            /*
             * Could not resolve type clashes
             * Unable to fully structure code
             */
            protected String expandTag(Doc ref, RootDoc rootDoc, Tag tag) throws Longjump {
                block11: {
                    tagName = tag.name();
                    if (!"@main.commandLineOptions".equals(tagName) && !"@command-line-options".equals(tagName)) break block11;
                    if ("@command-line-options".equals(tagName)) {
                        rootDoc.printWarning(ref.position(), "\"@command-line-options\" is deprecated; use \"@main.commandLineOptions\" instead");
                    }
                    sb = new StringBuilder();
                    first = ProducerUtil.once();
                    for (c = cd; c != null; c = c.superclass()) {
                        block1: for (MethodDoc md : c.methods()) {
                            block12: {
                                cload = Annotations.get((ProgramElementDoc)md, CommandLineOption.class, (RootDoc)rootDoc);
                                if (cload == null || MainDoclet.getCompanionOf(md, rootDoc) != null) continue;
                                clogts = md.tags("@main.commandLineOptionGroup");
                                if (clogts.length == 0 && (clogts = md.tags("@command-line-option-group")).length > 0) {
                                    rootDoc.printWarning(ref.position(), "\"@command-line-option-group\" is deprecated; use \"@main.commandLineOptionGroup\" instead");
                                }
                                if (tag.inlineTags().length != 0) break block12;
                                if (clogts.length != 0) {
                                    continue;
                                }
                                ** GOTO lbl25
                            }
                            var14_14 = clogts;
                            var15_16 = var14_14.length;
                            for (var16_18 = 0; var16_18 < var15_16; ++var16_18) {
                                clogt = var14_14[var16_18];
                                if (!clogt.text().equals(tag.text())) {
                                    continue;
                                }
lbl25:
                                // 3 sources

                                if (!first.produce()) {
                                    sb.append('\n');
                                }
                                this.attributeTerm(md, sb, rootDoc);
                                for (Tag md2 : c.methods()) {
                                    if (MainDoclet.getCompanionOf((MethodDoc)md2, rootDoc) != md) continue;
                                    this.attributeTerm((MethodDoc)md2, sb, rootDoc);
                                }
                                sb.append("<dd>\n  ");
                                deprecatedTag = Tags.optionalTag((Doc)md, (String)"deprecated", (DocErrorReporter)rootDoc);
                                if (deprecatedTag != null) {
                                    sb.append("<i><b>Deprecated</b> - ");
                                    sb.append(this.fromTags(deprecatedTag.inlineTags(), (Doc)md, rootDoc));
                                    sb.append("</i>");
                                }
                                if ((its = md.inlineTags()).length == 0 && (seeTag = (SeeTag)Tags.optionalTag((Doc)md, (String)"see", (DocErrorReporter)rootDoc)) != null && (target = Html.targetOfSeeTag((SeeTag)seeTag)) != null) {
                                    its = target.inlineTags();
                                }
                                sb.append(this.fromTags(its, (Doc)md, rootDoc));
                                sb.append("\n</dd>\n");
                                continue block1;
                            }
                        }
                    }
                    return sb.toString();
                }
                return super.expandTag(ref, rootDoc, tag);
            }

            /*
             * WARNING - void declaration
             */
            private void attributeTerm(MethodDoc md, StringBuilder out, RootDoc rootDoc) throws Longjump {
                AnnotationDesc cload = Annotations.get((ProgramElementDoc)md, CommandLineOption.class, (RootDoc)rootDoc);
                if (cload == null) {
                    return;
                }
                assert (cload != null);
                String[] names = (String[])Annotations.getElementValue((AnnotationDesc)cload, (String)"name", String[].class);
                if (names == null) {
                    String n = md.name();
                    if (n.startsWith("set")) {
                        n = n.substring(3);
                    } else if (n.startsWith("add")) {
                        n = n.substring(3);
                    } else if (n.startsWith("is")) {
                        n = n.substring(2);
                    }
                    names = new String[]{Notations.fromCamelCase((String)n).toLowerCaseHyphenated()};
                }
                String suffix = "";
                block6: for (Parameter p : md.parameters()) {
                    for (Tag paramTag : md.tags("@param")) {
                        String fs = this.fromTags(paramTag.firstSentenceTags(), (Doc)md, rootDoc);
                        if (!paramTag.text().startsWith(p.name() + " ")) continue;
                        suffix = suffix + fs.substring(p.name().length());
                        continue block6;
                    }
                    ClassDoc classDoc = p.type().asClassDoc();
                    if (classDoc != null && classDoc.isEnum()) {
                        suffix = suffix + " ";
                        Iterator<FieldDoc> it = Arrays.asList(classDoc.enumConstants()).iterator();
                        while (true) {
                            suffix = suffix + "<code>" + it.next().name() + "</code>";
                            if (!it.hasNext()) continue block6;
                            suffix = suffix + "|";
                        }
                    }
                    suffix = suffix + " <var>" + Notations.fromCamelCase((String)p.name()).toLowerCaseHyphenated() + "</var>";
                }
                CommandLineOption.Cardinality cardinality = CommandLineOption.Cardinality.OPTIONAL;
                for (AnnotationDesc.ElementValuePair elementValuePair : cload.elementValues()) {
                    if (!elementValuePair.element().name().equals("cardinality")) continue;
                    cardinality = CommandLineOption.Cardinality.valueOf((String)((FieldDoc)elementValuePair.value().value()).name());
                }
                switch (cardinality) {
                    case OPTIONAL: {
                        break;
                    }
                    case MANDATORY: {
                        suffix = suffix + " (mandatory)";
                        break;
                    }
                    case ONCE_OR_MORE: {
                        suffix = suffix + " (once or multiple)";
                        break;
                    }
                    case ANY: {
                        suffix = suffix + " (may appear multiply)";
                        break;
                    }
                    default: {
                        throw new AssertionError(cardinality);
                    }
                }
                for (String string : names) {
                    void var11_22;
                    if (!string.startsWith("-")) {
                        String string2 = (string.length() == 1 ? "-" : "--") + string;
                    }
                    out.append("<dt><code>" + (String)var11_22 + "</code>" + suffix + "</dt>\n");
                }
            }
        };
        try {
            htmlText = html.fromTags(doc.inlineTags(), doc, rootDoc);
        }
        catch (Longjump e) {
            return;
        }
        File outputFile = new File(destination, cd.qualifiedName().replace('.', File.separatorChar) + "." + doc.name() + (doc instanceof ExecutableMemberDoc ? ((ExecutableMemberDoc)doc).flatSignature() : "") + ".html");
        if (!quiet) {
            System.err.println("Generating \"" + outputFile + "\"...");
        }
        if (destination.exists() && !outputFile.getParentFile().isDirectory()) {
            outputFile.getParentFile().mkdirs();
        }
        try {
            IoUtil.outputFilePrintWriter((File)outputFile, (Charset)charset, (ConsumerWhichThrows)new ConsumerWhichThrows<PrintWriter, Exception>(){

                public void consume(PrintWriter pw) throws Exception {
                    pw.println("<html>");
                    pw.println("  <head>");
                    if (charset != null) {
                        pw.println("    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + charset + "\" />");
                    }
                    pw.println("  </head>");
                    pw.println("  <body>");
                    if (doctitle != null) {
                        pw.println("    <h1>" + doctitle + "</h1>");
                    }
                    pw.println(htmlText);
                    pw.println("  </body>");
                    pw.println("</html>");
                }
            });
        }
        catch (Exception e) {
            throw new IOException(null, e);
        }
    }

    @Nullable
    protected static MethodDoc getCompanionOf(MethodDoc source, RootDoc rootDoc) throws Longjump {
        if (source.inlineTags().length != 0) {
            return null;
        }
        SeeTag seeTag = (SeeTag)Tags.optionalTag((Doc)source, (String)"see", (DocErrorReporter)rootDoc);
        if (seeTag == null) {
            return null;
        }
        Doc target = Html.targetOfSeeTag((SeeTag)seeTag);
        if (target instanceof MethodDoc && Annotations.get((ProgramElementDoc)((MethodDoc)target), CommandLineOption.class, (RootDoc)rootDoc) != null) {
            return (MethodDoc)target;
        }
        return null;
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
        destination = new File(".");
        method = "main(String[])";
        docEncoding = Charset.defaultCharset();
    }
}

