/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.logging.handler;

import de.unkrig.commons.io.OutputStreams;
import de.unkrig.commons.lang.protocol.ConsumerUtil;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.expression.EvaluationException;
import de.unkrig.commons.text.parser.ParseException;
import de.unkrig.commons.util.TimeTable;
import de.unkrig.commons.util.logging.LogUtil;
import de.unkrig.commons.util.logging.handler.AbstractStreamHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

@NotNullByDefault(value=false)
public class ArchivingFileHandler
extends AbstractStreamHandler {
    private String fileNamePattern;
    private long sizeLimit;
    private TimeTable timeTable;
    private File currentFile;
    private Date nextArchiving;
    private ConsumerUtil.Produmer<Long, Long> byteCount;
    public static final long NO_LIMIT = Long.MAX_VALUE;
    private static final String DATE_PATTERN = "_yyyy-MM-dd_HH-mm-ss";
    public static final String DEFAULT_PATTERN = "%h/java%d.log";
    public static final long DEFAULT_SIZE_LIMIT = Long.MAX_VALUE;
    public static final TimeTable DEFAULT_TIME_TABLE = TimeTable.NEVER;
    public static final boolean DEFAULT_APPEND = false;

    public ArchivingFileHandler() throws ParseException, EvaluationException, IOException {
        this(0, null);
    }

    protected ArchivingFileHandler(int dummy, @Nullable String propertyNamePrefix) throws ParseException, EvaluationException, IOException {
        super(propertyNamePrefix);
        if (propertyNamePrefix == null) {
            propertyNamePrefix = this.getClass().getName();
        }
        try {
            this.init(LogUtil.getLoggingProperty(propertyNamePrefix + ".pattern", DEFAULT_PATTERN), LogUtil.getLoggingProperty(propertyNamePrefix + ".sizeLimit", Long.MAX_VALUE), LogUtil.getLoggingProperty(propertyNamePrefix + ".timeTable", TimeTable.class, DEFAULT_TIME_TABLE), LogUtil.getLoggingProperty(propertyNamePrefix + ".append", false));
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            throw pe;
        }
        catch (EvaluationException ee) {
            ee.printStackTrace();
            throw ee;
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            throw re;
        }
    }

    public ArchivingFileHandler(String pattern) throws IOException {
        this(pattern, Long.MAX_VALUE, DEFAULT_TIME_TABLE, false, true, AbstractStreamHandler.DEFAULT_LEVEL, AbstractStreamHandler.DEFAULT_FILTER, AbstractStreamHandler.DEFAULT_FORMATTER, AbstractStreamHandler.DEFAULT_ENCODING);
    }

    public ArchivingFileHandler(String pattern, boolean append) throws IOException {
        this(pattern, Long.MAX_VALUE, DEFAULT_TIME_TABLE, append, true, AbstractStreamHandler.DEFAULT_LEVEL, AbstractStreamHandler.DEFAULT_FILTER, AbstractStreamHandler.DEFAULT_FORMATTER, AbstractStreamHandler.DEFAULT_ENCODING);
    }

    public ArchivingFileHandler(String pattern, long sizeLimit) throws IOException {
        this(pattern, sizeLimit, DEFAULT_TIME_TABLE, false, true, AbstractStreamHandler.DEFAULT_LEVEL, AbstractStreamHandler.DEFAULT_FILTER, AbstractStreamHandler.DEFAULT_FORMATTER, AbstractStreamHandler.DEFAULT_ENCODING);
    }

    public ArchivingFileHandler(String pattern, long sizeLimit, boolean append) throws IOException {
        this(pattern, sizeLimit, DEFAULT_TIME_TABLE, append, true, AbstractStreamHandler.DEFAULT_LEVEL, AbstractStreamHandler.DEFAULT_FILTER, AbstractStreamHandler.DEFAULT_FORMATTER, AbstractStreamHandler.DEFAULT_ENCODING);
    }

    public ArchivingFileHandler(String pattern, TimeTable timeTable) throws IOException {
        this(pattern, Long.MAX_VALUE, timeTable, false, true, AbstractStreamHandler.DEFAULT_LEVEL, AbstractStreamHandler.DEFAULT_FILTER, AbstractStreamHandler.DEFAULT_FORMATTER, AbstractStreamHandler.DEFAULT_ENCODING);
    }

    public ArchivingFileHandler(String pattern, TimeTable timeTable, boolean append) throws IOException {
        this(pattern, Long.MAX_VALUE, timeTable, append, true, AbstractStreamHandler.DEFAULT_LEVEL, AbstractStreamHandler.DEFAULT_FILTER, AbstractStreamHandler.DEFAULT_FORMATTER, AbstractStreamHandler.DEFAULT_ENCODING);
    }

    public ArchivingFileHandler(String pattern, long sizeLimit, TimeTable timeTable, boolean append, boolean autoFlush, Level level, Filter filter, Formatter formatter, String encoding) throws IOException {
        super(autoFlush, level, filter, formatter, encoding);
        this.init(pattern, sizeLimit, timeTable, append);
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (new Date().compareTo(this.nextArchiving) >= 0) {
            try {
                this.archive(this.nextArchiving);
            }
            catch (Exception e) {
                this.reportError(null, e, 1);
            }
        }
        super.publish(record);
        Long fileSize = (Long)this.byteCount.produce();
        assert (fileSize != null);
        if (fileSize >= this.sizeLimit) {
            try {
                this.archive(new Date());
            }
            catch (Exception e) {
                this.reportError(null, e, 1);
            }
        }
    }

    private void init(String pattern, long sizeLimit, TimeTable timeTable, boolean append) throws IOException {
        pattern = pattern.replace('/', File.separatorChar);
        pattern = ArchivingFileHandler.replaceAll(pattern, "%%", "\u0001");
        pattern = ArchivingFileHandler.replaceAll(pattern, "%h", System.getProperty("user.home", ".") + File.separatorChar);
        if (!(pattern = ArchivingFileHandler.replaceAll(pattern, "%t", System.getProperty("java.io.tmpdir", ".") + File.separatorChar)).contains("%d")) {
            pattern = pattern + "%d";
        }
        this.fileNamePattern = pattern = pattern.replace('\u0001', '%');
        this.currentFile = new File(ArchivingFileHandler.replaceAll(pattern, "%d", ""));
        this.sizeLimit = sizeLimit;
        this.timeTable = timeTable;
        if (!(!this.currentFile.exists() || append && this.currentFile.length() < this.sizeLimit || this.currentFile.renameTo(this.getArchiveFile(new Date())))) {
            this.sizeLimit = Long.MAX_VALUE;
            this.nextArchiving = TimeTable.MAX_DATE;
        }
        this.openCurrentFile();
        this.nextArchiving = this.timeTable.next(new Date());
    }

    private File getArchiveFile(Date date) {
        String archiveFileName = ArchivingFileHandler.replaceAll(this.fileNamePattern, "%d", new SimpleDateFormat(DATE_PATTERN).format(date));
        File archiveFile = new File(archiveFileName);
        if (archiveFile.exists()) {
            int uniqueId = 1;
            while (true) {
                File alternativeArchiveFile;
                if (!(alternativeArchiveFile = new File(archiveFileName + '.' + uniqueId)).exists()) {
                    archiveFile = alternativeArchiveFile;
                    break;
                }
                ++uniqueId;
            }
        }
        return archiveFile;
    }

    private void openCurrentFile() throws IOException {
        this.byteCount = ConsumerUtil.store();
        this.setOutputStream(OutputStreams.tee(new FileOutputStream(this.currentFile, true), OutputStreams.lengthWritten(ConsumerUtil.cumulate(this.byteCount, 0L))));
    }

    private void archive(Date date) throws IOException {
        this.close();
        if (!this.currentFile.renameTo(this.getArchiveFile(date))) {
            this.sizeLimit = Long.MAX_VALUE;
            this.nextArchiving = TimeTable.MAX_DATE;
        } else {
            this.nextArchiving = this.timeTable.next(new Date());
        }
        this.openCurrentFile();
    }

    private static String replaceAll(String subject, String infix, String replacement) {
        int idx = subject.indexOf(infix);
        while (idx != -1) {
            subject = subject.substring(0, idx) + replacement + subject.substring(idx + infix.length());
            idx = subject.indexOf(infix, idx + replacement.length());
        }
        return subject;
    }
}

