/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.logging.filter;

import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.protocol.Mapping;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.nullanalysis.NotNull;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.expression.EvaluationException;
import de.unkrig.commons.text.expression.Expression;
import de.unkrig.commons.text.expression.ExpressionEvaluator;
import de.unkrig.commons.text.parser.ParseException;
import de.unkrig.commons.util.logging.LogUtil;
import java.util.logging.Filter;
import java.util.logging.LogRecord;

@NotNullByDefault(value=false)
public class ByExpressionFilter
implements Filter {
    private static final Predicate<? super String> IS_VALID_VARIABLE_NAME = new Predicate<String>(){

        @Override
        public boolean evaluate(@NotNull String variableName) {
            return "name".equals(variableName) || "level".equals(variableName) || "class".equals(variableName) || "method".equals(variableName) || "message".equals(variableName) || "params".equals(variableName);
        }
    };
    private Expression condition;

    public ByExpressionFilter() throws ParseException {
        this((String)null);
    }

    public ByExpressionFilter(String propertyNamePrefix) throws ParseException {
        if (propertyNamePrefix == null) {
            propertyNamePrefix = this.getClass().getName();
        }
        try {
            this.init(LogUtil.parseLoggingProperty(propertyNamePrefix + ".condition", IS_VALID_VARIABLE_NAME));
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            throw pe;
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            throw re;
        }
    }

    public ByExpressionFilter(Expression condition) {
        this.init(condition);
    }

    private void init(Expression condition) {
        if (condition == null) {
            throw new NullPointerException("condition");
        }
        this.condition = condition;
    }

    @Override
    public boolean isLoggable(final LogRecord record) {
        Mapping<String, Object> variables = new Mapping<String, Object>(){

            @Override
            public boolean containsKey(@Nullable Object key) {
                return key instanceof String && IS_VALID_VARIABLE_NAME.evaluate((String)key);
            }

            @Override
            public Object get(@Nullable Object key) {
                return "name".equals(key) ? record.getLoggerName() : ("level".equals(key) ? record.getLevel().getName() : ("class".equals(key) ? record.getSourceClassName() : ("method".equals(key) ? record.getSourceMethodName() : ("message".equals(key) ? record.getMessage() : ("params".equals(key) ? record.getParameters() : ExceptionUtil.throW(new IllegalStateException("Value of variable '" + key + "' missing")))))));
            }
        };
        try {
            return ExpressionEvaluator.toBoolean(this.condition.evaluate(variables));
        }
        catch (EvaluationException e) {
            return false;
        }
    }
}

